/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import xreliquary.items.ToggleableItem;
import xreliquary.items.util.FilteredBigItemStack;
import xreliquary.items.util.FilteredItemHandlerProvider;
import xreliquary.items.util.FilteredItemStackHandler;
import xreliquary.items.util.ILeftClickableItem;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;

public class RendingGaleItem
extends ToggleableItem
implements ILeftClickableItem {
    private static final String FLIGHT_TAG = "flight";
    private static final String COUNT_TAG = "count";

    public RendingGaleItem() {
        super("rending_gale", new Item.Properties().func_200917_a(1));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack rendingGale, @Nullable World world, List<ITextComponent> tooltip) {
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"charge", (Object)String.valueOf(this.getFeatherCount(rendingGale, true) / 100)), tooltip);
        if (this.isEnabled(rendingGale)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.RED + Items.field_151008_G.func_200295_i(new ItemStack((IItemProvider)Items.field_151008_G)).getString())), tooltip);
        } else {
            LanguageHelper.formatTooltip("tooltip.absorb", tooltip);
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    private static int getChargeLimit() {
        return (Integer)Settings.COMMON.items.rendingGale.chargeLimit.get();
    }

    public static int getChargeCost() {
        return (Integer)Settings.COMMON.items.rendingGale.castChargeCost.get();
    }

    private static int getFeathersWorth() {
        return (Integer)Settings.COMMON.items.rendingGale.chargeFeatherWorth.get();
    }

    private static int getBoltChargeCost() {
        return (Integer)Settings.COMMON.items.rendingGale.boltChargeCost.get();
    }

    private static int getBoltTargetRange() {
        return (Integer)Settings.COMMON.items.rendingGale.blockTargetRange.get();
    }

    private static int getRadialPushRadius() {
        return (Integer)Settings.COMMON.items.rendingGale.pushPullRadius.get();
    }

    private void attemptFlight(LivingEntity entityLiving) {
        double distance;
        if (!(entityLiving instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        BlockRayTraceResult rayTrace = RendingGaleItem.func_219968_a((World)player.field_70170_p, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        Vector3d motion = player.func_70040_Z();
        if (rayTrace.func_216346_c() == RayTraceResult.Type.BLOCK && (distance = player.func_233580_cy_().func_177951_i((Vector3i)rayTrace.func_216350_a())) < 40.0) {
            double slowDownFactor = distance / 40.0;
            motion = player.func_70040_Z().func_216372_d(slowDownFactor, slowDownFactor, slowDownFactor);
        }
        player.func_213317_d(motion);
        player.func_213315_a(MoverType.SELF, player.func_213322_ci());
        player.field_70143_R = 0.0f;
    }

    public void func_77663_a(ItemStack rendingGale, World world, Entity entity, int slotNumber, boolean isSelected) {
        if (world.field_72995_K || !(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (this.isEnabled(rendingGale) && this.getFeatherCount(rendingGale) + RendingGaleItem.getFeathersWorth() <= RendingGaleItem.getChargeLimit() && InventoryHelper.consumeItem(new ItemStack((IItemProvider)Items.field_151008_G), player)) {
            this.setFeatherCount(rendingGale, this.getFeatherCount(rendingGale) + RendingGaleItem.getFeathersWorth(), !player.func_184587_cr());
        }
    }

    public String getMode(ItemStack stack) {
        if (NBTHelper.getString("mode", stack).equals("")) {
            this.setMode(stack, FLIGHT_TAG);
        }
        return NBTHelper.getString("mode", stack);
    }

    private void setMode(ItemStack stack, String s) {
        NBTHelper.putString("mode", stack, s);
    }

    private void cycleMode(ItemStack stack, boolean isRaining) {
        if (this.isFlightMode(stack)) {
            this.setMode(stack, "push");
        } else if (this.isPushMode(stack)) {
            this.setMode(stack, "pull");
        } else if (this.isPullMode(stack) && isRaining) {
            this.setMode(stack, "bolt");
        } else {
            this.setMode(stack, FLIGHT_TAG);
        }
    }

    private boolean isPullMode(ItemStack stack) {
        return this.getMode(stack).equals("pull");
    }

    @Override
    public ActionResultType onLeftClickItem(ItemStack stack, LivingEntity entityLiving) {
        if (!entityLiving.func_225608_bj_()) {
            return ActionResultType.CONSUME;
        }
        if (entityLiving.field_70170_p.field_72995_K) {
            return ActionResultType.PASS;
        }
        this.cycleMode(stack, entityLiving.field_70170_p.func_72896_J());
        return ActionResultType.SUCCESS;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FilteredItemHandlerProvider(Collections.singletonList(new FilteredItemStackHandler.RemovableStack(new FilteredBigItemStack(Items.field_151008_G, (int)((Integer)Settings.COMMON.items.rendingGale.chargeLimit.get()), (int)((Integer)Settings.COMMON.items.rendingGale.chargeFeatherWorth.get())), false)));
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 6000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            super.func_77659_a(world, player, hand);
        } else {
            player.func_184598_c(hand);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack rendingGale, LivingEntity entity, int count) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (this.getFeatherCount(rendingGale, player.field_70170_p.field_72995_K) <= 0) {
            player.func_184597_cx();
            return;
        }
        if (this.isBoltMode(rendingGale)) {
            if (count % 8 == 0) {
                this.spawnBolt(rendingGale, player);
            }
        } else {
            if (this.isFlightMode(rendingGale)) {
                this.attemptFlight((LivingEntity)player);
                this.spawnFlightParticles(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_(), player);
            } else if (this.isPushMode(rendingGale)) {
                this.doRadialPush(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player, false);
            } else if (this.isPullMode(rendingGale)) {
                this.doRadialPush(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player, true);
            }
            if (!player.field_70170_p.field_72995_K) {
                this.setFeatherCount(rendingGale, Math.max(0, this.getFeatherCount(rendingGale) - RendingGaleItem.getChargeCost()), false);
            }
        }
    }

    private void spawnBolt(ItemStack rendingGale, PlayerEntity player) {
        RayTraceResult rayTraceResult = player.func_213324_a((double)RendingGaleItem.getBoltTargetRange(), 1.0f, true);
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            LightningBoltEntity bolt;
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
            BlockPos pos = blockRayTraceResult.func_216350_a();
            int attemptedY = pos.func_177956_o();
            if (!player.field_70170_p.func_175727_C(pos)) {
                ++attemptedY;
            }
            if (!player.field_70170_p.field_72995_K && player.field_70170_p.func_175727_C(new BlockPos(pos.func_177958_n(), attemptedY, pos.func_177952_p())) && (bolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(player.field_70170_p)) != null) {
                bolt.func_225653_b_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                player.field_70170_p.func_217376_c((Entity)bolt);
                this.setFeatherCount(rendingGale, Math.max(0, this.getFeatherCount(rendingGale) - RendingGaleItem.getBoltChargeCost()), false);
            }
        }
    }

    public void func_77615_a(ItemStack rendingGale, World world, LivingEntity entityLiving, int timeLeft) {
        if (world.field_72995_K) {
            return;
        }
        NBTHelper.putInt(COUNT_TAG, rendingGale, this.getFeatherCount(rendingGale));
    }

    private boolean isPushMode(ItemStack stack) {
        return this.getMode(stack).equals("push");
    }

    public boolean isFlightMode(ItemStack stack) {
        return this.getMode(stack).equals(FLIGHT_TAG);
    }

    public boolean hasFlightCharge(ItemStack stack) {
        return this.getFeatherCount(stack) > 0;
    }

    private boolean isBoltMode(ItemStack stack) {
        return this.getMode(stack).equals("bolt");
    }

    public int getFeatherCount(ItemStack rendingGale) {
        return this.getFeatherCount(rendingGale, false);
    }

    private int getFeatherCount(ItemStack rendingGale, boolean isClient) {
        if (isClient) {
            return NBTHelper.getInt(COUNT_TAG, rendingGale);
        }
        return rendingGale.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).filter(FilteredItemStackHandler.class::isInstance).map(handler -> ((FilteredItemStackHandler)handler).getTotalAmount(0)).orElse(0);
    }

    public void setFeatherCount(ItemStack stack, int featherCount, boolean updateNBT) {
        stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).filter(FilteredItemStackHandler.class::isInstance).ifPresent(handler -> {
            ((FilteredItemStackHandler)handler).setTotalAmount(0, featherCount);
            if (updateNBT) {
                NBTHelper.putInt(COUNT_TAG, stack, featherCount);
            }
        });
    }

    public void doRadialPush(World world, double posX, double posY, double posZ, @Nullable PlayerEntity player, boolean pull) {
        this.spawnRadialHurricaneParticles(world, posX, posY, posZ, player, pull);
        if (world.field_72995_K) {
            return;
        }
        double lowerX = posX - (double)RendingGaleItem.getRadialPushRadius();
        double lowerY = posY - (double)RendingGaleItem.getRadialPushRadius() / 5.0;
        double lowerZ = posZ - (double)RendingGaleItem.getRadialPushRadius();
        double upperX = posX + (double)RendingGaleItem.getRadialPushRadius();
        double upperY = posY + (double)RendingGaleItem.getRadialPushRadius() / 5.0;
        double upperZ = posZ + (double)RendingGaleItem.getRadialPushRadius();
        List entities = world.func_175647_a(Entity.class, new AxisAlignedBB(lowerX, lowerY, lowerZ, upperX, upperY, upperZ), e -> e instanceof MobEntity || e instanceof ProjectileEntity);
        for (Entity entity : entities) {
            double distance = this.getDistanceToEntity(posX, posY, posZ, entity);
            if (!(distance < (double)RendingGaleItem.getRadialPushRadius()) || this.isBlacklistedEntity(entity) || entity.equals((Object)player)) continue;
            Vector3d pushVector = pull ? new Vector3d(posX - entity.func_226277_ct_(), posY - entity.func_226278_cu_(), posZ - entity.func_226281_cx_()) : new Vector3d(entity.func_226277_ct_() - posX, entity.func_226278_cu_() - posY, entity.func_226281_cx_() - posZ);
            pushVector = pushVector.func_72432_b();
            entity.func_213315_a(MoverType.PLAYER, new Vector3d(0.0, 0.2, 0.0));
            entity.func_213315_a(MoverType.PLAYER, new Vector3d(pushVector.field_72450_a, Math.min(pushVector.field_72448_b, 0.1) * 1.5, pushVector.field_72449_c));
        }
    }

    private boolean isBlacklistedEntity(Entity entity) {
        if (entity.func_200600_R().getRegistryName() == null) {
            return false;
        }
        String entityName = entity.func_200600_R().getRegistryName().toString();
        return this.isBlacklistedLivingEntity(entity, entityName) || (Boolean)Settings.COMMON.items.rendingGale.canPushProjectiles.get() != false && this.isBlacklistedProjectile(entity, entityName);
    }

    private boolean isBlacklistedProjectile(Entity entity, String entityName) {
        return entity instanceof ProjectileEntity && ((List)Settings.COMMON.items.rendingGale.pushableProjectilesBlacklist.get()).contains(entityName);
    }

    private boolean isBlacklistedLivingEntity(Entity entity, String entityName) {
        return entity instanceof MobEntity && ((List)Settings.COMMON.items.rendingGale.pushableEntitiesBlacklist.get()).contains(entityName);
    }

    private float getDistanceToEntity(double posX, double posY, double posZ, Entity entityIn) {
        float f = (float)(posX - entityIn.func_226277_ct_());
        float f1 = (float)(posY - entityIn.func_226278_cu_());
        float f2 = (float)(posZ - entityIn.func_226281_cx_());
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    private void spawnFlightParticles(World world, double x, double y, double z, PlayerEntity player) {
        Vector3d lookVector = player.func_70040_Z();
        BlockParticleData blockParticleData = new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196604_cC.func_176223_P());
        for (int i = 0; i < 8; ++i) {
            float randX = 10.0f * (field_77697_d.nextFloat() - 0.5f);
            float randY = 10.0f * (field_77697_d.nextFloat() - 0.5f);
            float randZ = 10.0f * (field_77697_d.nextFloat() - 0.5f);
            world.func_195594_a((IParticleData)blockParticleData, x + (double)randX + lookVector.field_72450_a * 20.0, y + (double)randY + lookVector.field_72448_b * 20.0, z + (double)randZ + lookVector.field_72449_c * 20.0, -lookVector.field_72450_a * 5.0, -lookVector.field_72448_b * 5.0, -lookVector.field_72449_c * 5.0);
        }
    }

    private void spawnRadialHurricaneParticles(World world, double posX, double posY, double posZ, @Nullable PlayerEntity player, boolean pull) {
        BlockParticleData blockParticleData = new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196604_cC.func_176223_P());
        for (int i = 0; i < 3; ++i) {
            float randX = world.field_73012_v.nextFloat() - 0.5f;
            float randZ = world.field_73012_v.nextFloat() - 0.5f;
            float motX = randX * 10.0f;
            float motZ = randZ * 10.0f;
            if (pull) {
                randX *= 10.0f;
                randZ *= 10.0f;
                motX *= -1.0f;
                motZ *= -1.0f;
            }
            double posYAdjusted = player == null ? posY : posY + (double)player.func_70047_e() - (double)(player.func_213302_cg() / 2.0f);
            world.func_195594_a((IParticleData)blockParticleData, posX + (double)randX, posYAdjusted, posZ + (double)randZ, (double)motX, 0.0, (double)motZ);
        }
    }

    public int getFeatherCountClient(ItemStack rendingGale, PlayerEntity player) {
        int featherCount = this.getFeatherCount(rendingGale, true);
        String mode = this.getMode(rendingGale);
        int ticksInUse = this.func_77626_a(rendingGale) - player.func_184605_cv();
        if (player.func_184587_cr()) {
            featherCount = Math.max(0, featherCount - (mode.equals("bolt") ? RendingGaleItem.getBoltChargeCost() * (ticksInUse / 8) : RendingGaleItem.getChargeCost() * ticksInUse));
        }
        return featherCount;
    }
}

