/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.registries.ForgeRegistries;
import xreliquary.init.ModItems;
import xreliquary.items.MobCharmDefinition;
import xreliquary.items.MobCharmItem;

public class MobCharmRegistry {
    private static final Map<String, MobCharmDefinition> REGISTERED_CHARM_DEFINITIONS = new HashMap<String, MobCharmDefinition>();
    private static final Map<String, MobCharmDefinition> ENTITY_NAME_CHARM_DEFINITIONS = new HashMap<String, MobCharmDefinition>();
    private static final Set<String> DYNAMICALLY_REGISTERED = new HashSet<String>();

    private MobCharmRegistry() {
    }

    public static void registerMobCharmDefinition(MobCharmDefinition charmDefinition) {
        REGISTERED_CHARM_DEFINITIONS.put(charmDefinition.getRegistryName(), charmDefinition);
        for (String registryName : charmDefinition.getEntities()) {
            ENTITY_NAME_CHARM_DEFINITIONS.put(registryName, charmDefinition);
        }
    }

    static Optional<MobCharmDefinition> getCharmDefinitionFor(Entity entity) {
        return Optional.ofNullable(ENTITY_NAME_CHARM_DEFINITIONS.get(entity.func_200600_R().getRegistryName().toString()));
    }

    public static Optional<MobCharmDefinition> getCharmDefinitionFor(ItemStack stack) {
        if (stack.func_77973_b() != ModItems.MOB_CHARM) {
            return Optional.empty();
        }
        return Optional.ofNullable(ENTITY_NAME_CHARM_DEFINITIONS.get(MobCharmItem.getEntityRegistryName(stack)));
    }

    public static Set<String> getRegisteredNames() {
        return REGISTERED_CHARM_DEFINITIONS.keySet();
    }

    public static void registerDynamicCharmDefinitions(WorldEvent.Load event) {
        for (EntityType entityType : ForgeRegistries.ENTITIES) {
            IWorld world = event.getWorld();
            String registryName = entityType.getRegistryName().toString();
            if (ENTITY_NAME_CHARM_DEFINITIONS.containsKey(registryName) || entityType.func_220339_d() != EntityClassification.MONSTER || !(world instanceof World) || !MobCharmRegistry.isNonBossMob(entityType, (World)world)) continue;
            MobCharmRegistry.registerMobCharmDefinition(new MobCharmDefinition(registryName));
            DYNAMICALLY_REGISTERED.add(registryName);
        }
    }

    private static boolean isNonBossMob(EntityType<?> entityType, World world) {
        Entity e = entityType.func_200721_a(world);
        return e != null && e.func_184222_aU() && e instanceof MobEntity;
    }

    public static void handleAddingFragmentDrops(LivingDropsEvent evt) {
        if (!evt.getSource().func_76355_l().equals("player")) {
            return;
        }
        LivingEntity entity = evt.getEntityLiving();
        ResourceLocation regName = entity.func_200600_R().getRegistryName();
        if (regName == null || !DYNAMICALLY_REGISTERED.contains(regName.toString())) {
            return;
        }
        double skeletonDropChance = 0.1 * (double)evt.getLootingLevel() * 0.05;
        double dynamicDropChance = skeletonDropChance / 6.0;
        if ((double)entity.field_70170_p.field_73012_v.nextFloat() < dynamicDropChance) {
            ItemEntity fragmentItemEntity = new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), ModItems.MOB_CHARM_FRAGMENT.getStackFor(regName.toString()));
            fragmentItemEntity.func_174869_p();
            evt.getDrops().add(fragmentItemEntity);
        }
    }

    static {
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.ZOMBIE);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.SKELETON);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.WITHER_SKELETON);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.CREEPER);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.WITCH);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.ZOMBIFIED_PIGLIN);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.CAVE_SPIDER);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.SPIDER);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.ENDERMAN);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.GHAST);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.SLIME);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.MAGMA_CUBE);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.BLAZE);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.GUARDIAN);
    }
}

