/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import xreliquary.init.ModItems;
import xreliquary.items.MobCharmFragmentItem;

public class MobCharmDefinition {
    static final MobCharmDefinition ZOMBIE = new MobCharmDefinition("minecraft:zombie", ModItems.ZOMBIE_HEART, "minecraft:zombie", "minecraft:husk", "minecraft:drowned");
    static final MobCharmDefinition SKELETON = new MobCharmDefinition("minecraft:skeleton", ModItems.RIB_BONE, "minecraft:skeleton", "minecraft:stray");
    static final MobCharmDefinition WITHER_SKELETON = new MobCharmDefinition("minecraft:wither_skeleton", ModItems.WITHERED_RIB, "minecraft:wither_skeleton");
    static final MobCharmDefinition CREEPER = new MobCharmDefinition("minecraft:creeper", ModItems.CATALYZING_GLAND, "minecraft:creeper");
    static final MobCharmDefinition WITCH = new MobCharmDefinition("minecraft:witch", (Item)ModItems.WITCH_HAT, "minecraft:witch");
    static final MobCharmDefinition ZOMBIFIED_PIGLIN = new MobCharmDefinition("minecraft:zombified_piglin", ModItems.ZOMBIE_HEART, "minecraft:zombified_piglin").setResetTargetInLivingUpdateEvent(true);
    static final MobCharmDefinition CAVE_SPIDER = new MobCharmDefinition("minecraft:cave_spider", ModItems.CHELICERAE, "minecraft:cave_spider");
    static final MobCharmDefinition SPIDER = new MobCharmDefinition("minecraft:spider", ModItems.CHELICERAE, "minecraft:spider");
    static final MobCharmDefinition ENDERMAN = new MobCharmDefinition("minecraft:enderman", ModItems.NEBULOUS_HEART, "minecraft:enderman").setResetTargetInLivingUpdateEvent(true);
    static final MobCharmDefinition GHAST = new MobCharmDefinition("minecraft:ghast", ModItems.CATALYZING_GLAND, "minecraft:ghast").setResetTargetInLivingUpdateEvent(true);
    static final MobCharmDefinition SLIME = new MobCharmDefinition("minecraft:slime", ModItems.SLIME_PEARL, "minecraft:slime").setResetTargetInLivingUpdateEvent(true);
    static final MobCharmDefinition MAGMA_CUBE = new MobCharmDefinition("minecraft:magma_cube", ModItems.MOLTEN_CORE, "minecraft:magma_cube").setResetTargetInLivingUpdateEvent(true);
    static final MobCharmDefinition BLAZE = new MobCharmDefinition("minecraft:blaze", ModItems.MOLTEN_CORE, "minecraft:blaze");
    static final MobCharmDefinition GUARDIAN = new MobCharmDefinition("minecraft:guardian", ModItems.GUARDIAN_SPIKE, "minecraft:guardian");
    private final Set<String> applicableToEntities = new HashSet<String>();
    private boolean resetTargetInLivingUpdateEvent = false;
    private final String registryName;
    private final Item repairItem;
    private boolean dynamicallyCreated = false;

    public MobCharmDefinition(String registryName) {
        this(registryName, null, registryName);
        this.dynamicallyCreated = true;
    }

    public MobCharmDefinition(String registryName, @Nullable Item repairItem, String ... applicableTo) {
        this.registryName = registryName;
        this.repairItem = repairItem;
        Collections.addAll(this.applicableToEntities, applicableTo);
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public MobCharmDefinition setResetTargetInLivingUpdateEvent(boolean resetTargetInLivingUpdateEvent) {
        this.resetTargetInLivingUpdateEvent = resetTargetInLivingUpdateEvent;
        return this;
    }

    public boolean resetTargetInLivingUpdateEvent() {
        return this.resetTargetInLivingUpdateEvent;
    }

    public Set<String> getEntities() {
        return this.applicableToEntities;
    }

    public boolean isRepairItem(ItemStack item) {
        return this.repairItem != null ? item.func_77973_b() == this.repairItem : item.func_77973_b() == ModItems.MOB_CHARM_FRAGMENT && this.applicableToEntities.contains(MobCharmFragmentItem.getEntityRegistryName(item));
    }

    public boolean isDynamicallyCreated() {
        return this.dynamicallyCreated;
    }
}

