/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Rarity;
import net.minecraft.item.SwordItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import xreliquary.Reliquary;
import xreliquary.util.LanguageHelper;

public class MercyCrossItem
extends SwordItem {
    private static final String WEAPON_MODIFIER_NAME = "Weapon modifier";

    public MercyCrossItem() {
        super((IItemTier)ItemTier.GOLD, 3, -2.4f, new Item.Properties().func_200917_a(1).func_200918_c(64).func_200916_a(Reliquary.ITEM_GROUP));
        this.setRegistryName("xreliquary", "mercy_cross");
        MinecraftForge.EVENT_BUS.addListener(this::handleDamage);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.EPIC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack cross, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip", tooltip);
    }

    public float func_200894_d() {
        return 0.0f;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        if (slot == EquipmentSlotType.MAINHAND) {
            return ImmutableMultimap.builder().putAll(super.getAttributeModifiers(slot, stack)).put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, WEAPON_MODIFIER_NAME, 6.0, AttributeModifier.Operation.ADDITION)).put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, WEAPON_MODIFIER_NAME, (double)-2.4f, AttributeModifier.Operation.ADDITION)).build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    private void handleDamage(AttackEntityEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K || !(event.getTarget() instanceof LivingEntity)) {
            return;
        }
        if (event.getPlayer().func_184614_ca().func_77973_b() != this) {
            return;
        }
        LivingEntity target = (LivingEntity)event.getTarget();
        this.updateAttackDamageModifier(target, event.getPlayer());
    }

    private void updateAttackDamageModifier(LivingEntity target, PlayerEntity player) {
        double dmg = this.isUndead(target) ? 12.0 : 6.0;
        ModifiableAttributeInstance attackAttribute = player.func_110148_a(Attributes.field_233823_f_);
        if (attackAttribute != null && (attackAttribute.func_111127_a(field_111210_e) == null || attackAttribute.func_111127_a(field_111210_e).func_111164_d() != dmg)) {
            attackAttribute.func_188479_b(field_111210_e);
            attackAttribute.func_233767_b_(new AttributeModifier(field_111210_e, WEAPON_MODIFIER_NAME, dmg, AttributeModifier.Operation.ADDITION));
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity monster) {
        if (monster instanceof MobEntity && this.isUndead((LivingEntity)((MobEntity)monster))) {
            monster.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, monster.func_226277_ct_() + (double)(field_77697_d.nextFloat() - 0.5f), monster.func_226278_cu_() + (double)(field_77697_d.nextFloat() - 0.5f) + (double)(monster.func_213302_cg() / 2.0f), monster.func_226281_cx_() + (double)(field_77697_d.nextFloat() - 0.5f), 0.0, 0.0, 0.0);
        }
        return super.onLeftClickEntity(stack, player, monster);
    }

    private boolean isUndead(LivingEntity e) {
        return e.func_70668_bt() == CreatureAttribute.field_223223_b_;
    }
}

