/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import xreliquary.blocks.FertileLilyPadBlock;
import xreliquary.entities.EntityXRFakePlayer;
import xreliquary.init.ModCapabilities;
import xreliquary.items.ToggleableItem;
import xreliquary.items.util.FilteredBigItemStack;
import xreliquary.items.util.HarvestRodItemStackHandler;
import xreliquary.items.util.IHarvestRodCache;
import xreliquary.items.util.ILeftClickableItem;
import xreliquary.network.PacketCountSync;
import xreliquary.network.PacketHandler;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.ItemHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.RandHelper;
import xreliquary.util.XRFakePlayerFactory;

public class HarvestRodItem
extends ToggleableItem
implements ILeftClickableItem {
    public static final String BONE_MEAL_MODE = "bone_meal";
    private static final String PLANTABLE_MODE = "plantable";
    public static final String HOE_MODE = "hoe";
    private static final String MODE_NBT_TAG = "mode";
    private static final String PLANTABLE_INDEX_NBT_TAG = "plantable_index";
    private static final int AOE_START_COOLDOWN = 10;

    public HarvestRodItem() {
        super("harvest_rod", new Item.Properties().func_200917_a(1).setNoRepair());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack rod, @Nullable World world, List<ITextComponent> tooltip) {
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"charge", (Object)Integer.toString(this.getBoneMealCount(rod, true))), tooltip);
        for (int slot = 1; slot < this.getCountPlantable(rod, true); ++slot) {
            ItemStack plantable = this.getPlantableInSlot(rod, slot, true);
            LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip3", (ImmutableMap<String, String>)ImmutableMap.of((Object)PLANTABLE_MODE, (Object)plantable.func_77973_b().func_200295_i(plantable).getString(), (Object)"charge", (Object)Integer.toString(this.getPlantableQuantity(rod, slot, true))), tooltip);
        }
        if (this.isEnabled(rod)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.WHITE + new ItemStack((IItemProvider)Items.field_196106_bc).func_200301_q().toString())), tooltip);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, tooltip);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    private int getBonemealLimit() {
        return (Integer)Settings.COMMON.items.harvestRod.boneMealLimit.get();
    }

    private int getBonemealWorth() {
        return (Integer)Settings.COMMON.items.harvestRod.boneMealWorth.get();
    }

    public int getBonemealCost() {
        return (Integer)Settings.COMMON.items.harvestRod.boneMealCost.get();
    }

    public int getLuckRolls() {
        return (Integer)Settings.COMMON.items.harvestRod.boneMealLuckRolls.get();
    }

    public int getLuckPercent() {
        return (Integer)Settings.COMMON.items.harvestRod.boneMealLuckPercentChance.get();
    }

    private int getBreakRadius() {
        return (Integer)Settings.COMMON.items.harvestRod.aoeRadius.get();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilitySerializable<CompoundNBT>(){
            final HarvestRodItemStackHandler itemHandler = new HarvestRodItemStackHandler();

            public CompoundNBT serializeNBT() {
                return this.itemHandler.serializeNBT();
            }

            public void deserializeNBT(CompoundNBT tagCompound) {
                this.itemHandler.deserializeNBT(tagCompound);
            }

            public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
                return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, LazyOptional.of(() -> this.itemHandler));
            }
        };
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.field_72995_K) {
            return;
        }
        PlayerEntity player = null;
        if (entity instanceof PlayerEntity) {
            player = (PlayerEntity)entity;
        }
        if (player == null) {
            return;
        }
        if (this.isEnabled(stack)) {
            if (this.getBoneMealCount(stack) + this.getBonemealWorth() <= this.getBonemealLimit() && InventoryHelper.consumeItem(new ItemStack((IItemProvider)Items.field_196106_bc), player)) {
                this.setBoneMealCount(stack, this.getBoneMealCount(stack) + this.getBonemealWorth(), player);
            }
            this.consumePlantables(stack, player);
        }
    }

    private void consumePlantables(ItemStack harvestRod, PlayerEntity player) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
            ItemStack currentStack = (ItemStack)player.field_71071_by.field_70462_a.get(slot);
            if (!this.isPlantable(currentStack) || !this.incrementPlantable(harvestRod, currentStack, player)) continue;
            InventoryHelper.consumeItem(currentStack, player, 0, 1);
            break;
        }
    }

    private boolean isPlantable(ItemStack currentStack) {
        Item item = currentStack.func_77973_b();
        return item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof IPlantable;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        boolean brokenBlock = false;
        Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
        if (block instanceof IPlantable || block == Blocks.field_150440_ba || block == Blocks.field_150423_aK) {
            for (int xOff = -this.getBreakRadius(); xOff <= this.getBreakRadius(); ++xOff) {
                for (int yOff = -this.getBreakRadius(); yOff <= this.getBreakRadius(); ++yOff) {
                    for (int zOff = -this.getBreakRadius(); zOff <= this.getBreakRadius(); ++zOff) {
                        brokenBlock |= this.doHarvestBlockBreak(block, stack, pos, player, xOff, yOff, zOff);
                    }
                }
            }
        }
        return brokenBlock;
    }

    private boolean doHarvestBlockBreak(Block initialBlock, ItemStack stack, BlockPos pos, PlayerEntity player, int xOff, int yOff, int zOff) {
        pos = pos.func_177982_a(xOff, yOff, zOff);
        BlockState blockState = player.field_70170_p.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if ((initialBlock == Blocks.field_150440_ba || initialBlock == Blocks.field_150423_aK) && block != Blocks.field_150440_ba && block != Blocks.field_150423_aK) {
            return false;
        }
        if (!(block instanceof IPlantable) && block != Blocks.field_150440_ba && block != Blocks.field_150423_aK) {
            return false;
        }
        if (block instanceof FertileLilyPadBlock) {
            return false;
        }
        if (player.field_70170_p.field_72995_K) {
            for (int particles = 0; particles <= 8; ++particles) {
                player.field_70170_p.func_217378_a(player, 2001, pos, Block.func_196246_j((BlockState)blockState));
            }
        } else if (player.field_70170_p instanceof ServerWorld) {
            List drops = Block.func_220077_a((BlockState)blockState, (ServerWorld)((ServerWorld)player.field_70170_p), (BlockPos)pos, null, (Entity)player, (ItemStack)stack);
            for (ItemStack itemStack : drops) {
                float f = 0.7f;
                double d = (double)(field_77697_d.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(field_77697_d.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(field_77697_d.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                ItemEntity entityitem = new ItemEntity(player.field_70170_p, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, itemStack);
                entityitem.func_174867_a(10);
                player.field_70170_p.func_217376_c((Entity)entityitem);
            }
            player.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)blockState.func_177230_c()));
            player.func_71020_j(0.01f);
        }
        return true;
    }

    private void boneMealBlock(ItemStack stack, PlayerEntity player, World world, BlockPos pos, boolean updateNBT) {
        ItemStack fakeItemStack = new ItemStack((IItemProvider)Items.field_196106_bc);
        boolean usedRod = false;
        for (int repeatedUses = 0; repeatedUses <= this.getLuckRolls(); ++repeatedUses) {
            if (repeatedUses != 0 && world.field_73012_v.nextInt(100) > this.getLuckPercent() || !BoneMealItem.applyBonemeal((ItemStack)fakeItemStack, (World)world, (BlockPos)pos, (PlayerEntity)player)) continue;
            if (!usedRod) {
                usedRod = true;
            }
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.NEUTRAL, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.field_70170_p.field_73012_v) * 0.7f + 1.2f));
        }
        if (usedRod && !player.func_184812_l_()) {
            this.setBoneMealCount(stack, this.getBoneMealCount(stack) - this.getBonemealCost(), player, updateNBT);
        }
    }

    public int getBoneMealCount(ItemStack stack) {
        return this.getBoneMealCount(stack, false);
    }

    public int getBoneMealCount(ItemStack stack, boolean isClient) {
        if (isClient) {
            return NBTHelper.getContainedStackCount(stack, 0);
        }
        return this.getFromHandler(stack, HarvestRodItemStackHandler::getBoneMealCount).orElse(0);
    }

    public void setBoneMealCount(ItemStack harvestRod, int boneMealCount) {
        this.setBoneMealCount(harvestRod, boneMealCount, null, true);
    }

    private <T> Optional<T> getFromHandler(ItemStack harvestRod, Function<HarvestRodItemStackHandler, T> get) {
        return InventoryHelper.getFromHandler(harvestRod, get, HarvestRodItemStackHandler.class);
    }

    private void runOnHandler(ItemStack harvestRod, Consumer<HarvestRodItemStackHandler> run) {
        InventoryHelper.runOnItemHandler(harvestRod, run, HarvestRodItemStackHandler.class);
    }

    private void setBoneMealCount(ItemStack harvestRod, int boneMealCount, PlayerEntity player) {
        this.runOnHandler(harvestRod, h -> {
            h.setBoneMealCount(boneMealCount);
            this.updateContainedItemNBT(harvestRod, player, (short)0, ItemStack.field_190927_a, boneMealCount);
        });
    }

    private void setBoneMealCount(ItemStack harvestRod, int boneMealCount, @Nullable PlayerEntity player, boolean updateNBT) {
        this.runOnHandler(harvestRod, h -> {
            h.setBoneMealCount(boneMealCount);
            this.updateContainedItemNBT(harvestRod, player, (short)0, ItemStack.field_190927_a, boneMealCount, updateNBT);
        });
    }

    private boolean incrementPlantable(ItemStack harvestRod, ItemStack plantable, PlayerEntity player) {
        return this.getFromHandler(harvestRod, h -> {
            ItemStack plantableCopy = plantable.func_77946_l();
            plantableCopy.func_190920_e(1);
            return h.insertPlantable(plantableCopy).map(bigStackSlot -> {
                this.updateContainedItemNBT(harvestRod, player, bigStackSlot.shortValue(), plantableCopy, this.getPlantableQuantity(harvestRod, (int)bigStackSlot));
                return true;
            }).orElse(false);
        }).orElse(false);
    }

    private void updateContainedItemNBT(ItemStack harvestRod, PlayerEntity player, short slot, ItemStack stack, int count) {
        this.updateContainedItemNBT(harvestRod, player, slot, stack, count, true);
    }

    private void updateContainedItemNBT(ItemStack harvestRod, @Nullable PlayerEntity player, short slot, ItemStack stack, int count, boolean udpateNbt) {
        if (udpateNbt && player != null && player.func_184587_cr() && (player.func_184614_ca() == harvestRod || player.func_184592_cb() == harvestRod)) {
            Hand hand = player.func_184614_ca() == harvestRod ? Hand.MAIN_HAND : Hand.OFF_HAND;
            PacketHandler.sendToClient((ServerPlayerEntity)player, new PacketCountSync(hand, slot, stack, count));
        } else {
            NBTHelper.updateContainedStack(harvestRod, slot, stack, count);
        }
    }

    private void decrementPlantable(ItemStack harvestRod, byte slot, PlayerEntity player, boolean updateNBT) {
        this.getFromHandler(harvestRod, h -> h.getBigStack(slot).getAmount()).flatMap(amount -> this.setPlantableQuantity(harvestRod, slot, amount - 1)).ifPresent(plantable -> this.updateContainedItemNBT(harvestRod, player, slot, plantable.getFilterStack(), plantable.getAmount(), updateNBT));
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            return super.func_77659_a(world, player, hand);
        }
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Override
    void toggleEnabled(ItemStack stack) {
        super.toggleEnabled(stack);
        this.updateContainedStacks(stack);
    }

    public int func_77626_a(ItemStack stack) {
        return 300;
    }

    public void func_77615_a(ItemStack harvestRod, World world, LivingEntity entity, int timeLeft) {
        if (entity.field_70170_p.field_72995_K || !(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        BlockRayTraceResult result = HarvestRodItem.func_219968_a((World)player.field_70170_p, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            String mode;
            harvestRod.getCapability(ModCapabilities.HARVEST_ROD_CACHE, null).ifPresent(IHarvestRodCache::reset);
            BlockPos pos = result.func_216350_a();
            switch (mode = this.getMode(harvestRod)) {
                case "bone_meal": {
                    if (this.getBoneMealCount(harvestRod) < this.getBonemealCost() && !player.func_184812_l_()) break;
                    this.boneMealBlock(harvestRod, player, world, pos, true);
                    break;
                }
                case "plantable": {
                    if (this.getPlantableQuantity(harvestRod, this.getCurrentPlantableSlot(harvestRod)) <= 0 && !player.func_184812_l_()) break;
                    this.plantItem(harvestRod, player, pos, player.func_184600_cs(), true);
                    break;
                }
                case "hoe": {
                    this.hoeLand(world, pos);
                    break;
                }
            }
        } else {
            this.removeStackFromCurrent(harvestRod, player);
        }
    }

    private void hoeLand(World world, BlockPos pos) {
        ItemStack fakeHoe = new ItemStack((IItemProvider)Items.field_151017_I);
        EntityXRFakePlayer fakePlayer = XRFakePlayerFactory.get((ServerWorld)world);
        fakePlayer.func_184611_a(Hand.MAIN_HAND, fakeHoe);
        if (Items.field_151017_I.func_195939_a(ItemHelper.getItemUseContext(pos, (PlayerEntity)fakePlayer)) == ActionResultType.SUCCESS) {
            world.func_184133_a(null, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void removeStackFromCurrent(ItemStack stack, PlayerEntity player) {
        if (this.getMode(stack).equals(BONE_MEAL_MODE) && this.getBoneMealCount(stack) > 0) {
            ItemStack boneMealStack = new ItemStack((IItemProvider)Items.field_196106_bc);
            int numberToAdd = Math.min(boneMealStack.func_77976_d(), this.getBoneMealCount(stack));
            int numberAdded = InventoryHelper.getItemHandlerFrom(player).map(handler -> InventoryHelper.tryToAddToInventory(boneMealStack, handler, numberToAdd)).orElse(0);
            this.setBoneMealCount(stack, this.getBoneMealCount(stack) - numberAdded, player, true);
        } else if (this.getMode(stack).equals(PLANTABLE_MODE)) {
            byte plantableSlot = this.getCurrentPlantableSlot(stack);
            ItemStack plantableStack = this.getCurrentPlantable(stack);
            int plantableQuantity = this.getPlantableQuantity(stack, plantableSlot);
            int numberToAdd = Math.min(plantableStack.func_77976_d(), plantableQuantity);
            int numberAdded = InventoryHelper.getItemHandlerFrom(player).map(handler -> InventoryHelper.tryToAddToInventory(plantableStack, handler, numberToAdd)).orElse(0);
            int updatedPlantableQuantity = this.getPlantableQuantity(stack, plantableSlot) - numberAdded;
            this.setPlantableQuantity(stack, plantableSlot, updatedPlantableQuantity, player);
        }
    }

    private void shiftModeOnEmptyPlantable(ItemStack harvestRod, byte plantableSlot) {
        if (plantableSlot > 0) {
            this.setCurrentPlantableSlot(harvestRod, (byte)(plantableSlot - 1));
        }
        this.cycleMode(harvestRod);
    }

    private void plantItem(ItemStack harvestRod, PlayerEntity player, BlockPos pos, Hand hand, boolean updateNBT) {
        byte plantableSlot = this.getCurrentPlantableSlot(harvestRod);
        ItemStack fakePlantableStack = this.getCurrentPlantable(harvestRod).func_77946_l();
        fakePlantableStack.func_190920_e(1);
        EntityXRFakePlayer fakePlayer = XRFakePlayerFactory.get((ServerWorld)player.field_70170_p);
        fakePlayer.func_184611_a(hand, fakePlantableStack);
        if (fakePlantableStack.func_196084_a(ItemHelper.getItemUseContext(pos, (PlayerEntity)fakePlayer)) == ActionResultType.SUCCESS) {
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.field_70170_p.field_73012_v) * 0.7f + 1.2f));
            if (!player.func_184812_l_()) {
                this.decrementPlantable(harvestRod, plantableSlot, player, updateNBT);
            }
        }
    }

    private ItemStack getCurrentPlantable(ItemStack harvestRod) {
        return this.getCurrentPlantable(harvestRod, false);
    }

    public ItemStack getCurrentPlantable(ItemStack harvestRod, boolean isClient) {
        byte currentSlot = this.getCurrentPlantableSlot(harvestRod);
        if (isClient) {
            return NBTHelper.getContainedStack(harvestRod, currentSlot);
        }
        return this.getPlantableInSlot(harvestRod, currentSlot);
    }

    public ItemStack getPlantableInSlot(ItemStack harvestRod, int slot) {
        return this.getPlantableInSlot(harvestRod, slot, false);
    }

    private ItemStack getPlantableInSlot(ItemStack harvestRod, int slot, boolean isClient) {
        if (isClient) {
            return NBTHelper.getContainedStack(harvestRod, slot);
        }
        return this.getFromHandler(harvestRod, h -> h.getBigStack(slot).getFullStack()).orElse(ItemStack.field_190927_a);
    }

    public void onUsingTick(ItemStack harvestRod, LivingEntity entity, int count) {
        BlockRayTraceResult result;
        if (entity.field_70170_p.field_72995_K || !(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (this.isCoolDownOver(harvestRod, count) && (result = HarvestRodItem.func_219968_a((World)player.field_70170_p, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY)).func_216346_c() == RayTraceResult.Type.BLOCK) {
            World world = player.field_70170_p;
            harvestRod.getCapability(ModCapabilities.HARVEST_ROD_CACHE, null).ifPresent(cache -> this.doAction(harvestRod, player, world, (IHarvestRodCache)cache, result.func_216350_a()));
        }
    }

    private void doAction(ItemStack harvestRod, PlayerEntity player, World world, IHarvestRodCache cache, BlockPos pos) {
        switch (this.getMode(harvestRod)) {
            case "bone_meal": {
                if (this.getBoneMealCount(harvestRod) < this.getBonemealCost() && !player.func_184812_l_()) break;
                this.getNextBlockToBoneMeal(world, cache, pos, (Integer)Settings.COMMON.items.harvestRod.aoeRadius.get()).ifPresent(blockToBoneMeal -> this.boneMealBlock(harvestRod, player, world, (BlockPos)blockToBoneMeal, false));
                break;
            }
            case "plantable": {
                if (this.getPlantableQuantity(harvestRod, this.getCurrentPlantableSlot(harvestRod)) < 1 && !player.func_184812_l_()) break;
                this.getNextBlockToPlantOn(world, cache, pos, (Integer)Settings.COMMON.items.harvestRod.aoeRadius.get(), (IPlantable)((BlockItem)this.getCurrentPlantable(harvestRod).func_77973_b()).func_179223_d()).ifPresent(blockToPlantOn -> this.plantItem(harvestRod, player, (BlockPos)blockToPlantOn, player.func_184600_cs(), false));
                break;
            }
            case "hoe": {
                this.getNextBlockToHoe(world, cache, pos, (Integer)Settings.COMMON.items.harvestRod.aoeRadius.get()).ifPresent(blockToHoe -> this.hoeLand(world, (BlockPos)blockToHoe));
                break;
            }
        }
    }

    private Optional<BlockPos> getNextBlockToHoe(World world, IHarvestRodCache cache, BlockPos pos, int range) {
        if (cache.isQueueEmpty() || !pos.equals((Object)cache.getStartBlockPos())) {
            this.fillQueue(cache, pos, range, currentPos -> {
                BlockState blockState = world.func_180495_p(currentPos);
                Block block = blockState.func_177230_c();
                return world.func_175623_d(currentPos.func_177984_a()) && (block == Blocks.field_196658_i || block == Blocks.field_185774_da || block == Blocks.field_150346_d || block == Blocks.field_196660_k);
            });
        }
        return cache.getNextBlockInQueue();
    }

    private void fillQueue(IHarvestRodCache cache, BlockPos pos, int range, Predicate<BlockPos> isValidBlock) {
        cache.setStartBlockPos(pos);
        cache.clearBlockQueue();
        BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range)).forEach(currentPos -> {
            if (isValidBlock.test((BlockPos)currentPos)) {
                cache.addBlockToQueue(currentPos.func_185334_h());
            }
        });
    }

    private Optional<BlockPos> getNextBlockToPlantOn(World world, IHarvestRodCache cache, BlockPos pos, int range, IPlantable plantable) {
        if (cache.isQueueEmpty() || !pos.equals((Object)cache.getStartBlockPos())) {
            this.fillQueueToPlant(world, cache, pos, range, plantable);
        }
        return cache.getNextBlockInQueue();
    }

    private void fillQueueToPlant(World world, IHarvestRodCache cache, BlockPos pos, int range, IPlantable plantable) {
        boolean checkerboard = false;
        boolean bothOddOrEven = false;
        if (plantable == Blocks.field_150393_bb || plantable == Blocks.field_150394_bc) {
            checkerboard = true;
            boolean xEven = pos.func_177958_n() % 2 == 0;
            boolean zEven = pos.func_177952_p() % 2 == 0;
            bothOddOrEven = xEven == zEven;
        }
        boolean finalCheckerboard = checkerboard;
        boolean finalBothOddOrEven = bothOddOrEven;
        this.fillQueue(cache, pos, range, currentPos -> {
            BlockState blockState = world.func_180495_p(currentPos);
            return (!finalCheckerboard || finalBothOddOrEven == (currentPos.func_177958_n() % 2 == 0 == (currentPos.func_177952_p() % 2 == 0))) && blockState.func_177230_c().canSustainPlant(blockState, (IBlockReader)world, pos, Direction.UP, plantable) && world.func_175623_d(currentPos.func_177984_a());
        });
    }

    @Override
    public ActionResultType onLeftClickItem(ItemStack stack, LivingEntity entityLiving) {
        if (!entityLiving.func_225608_bj_()) {
            return ActionResultType.CONSUME;
        }
        if (entityLiving.field_70170_p.field_72995_K) {
            return ActionResultType.PASS;
        }
        this.cycleMode(stack);
        return ActionResultType.SUCCESS;
    }

    private boolean isCoolDownOver(ItemStack stack, int count) {
        return this.func_77626_a(stack) - count >= 10 && (this.func_77626_a(stack) - count) % (Integer)Settings.COMMON.items.harvestRod.aoeCooldown.get() == 0;
    }

    private Optional<BlockPos> getNextBlockToBoneMeal(World world, IHarvestRodCache cache, BlockPos pos, int range) {
        if (cache.isQueueEmpty() || !pos.equals((Object)cache.getStartBlockPos())) {
            this.fillQueue(cache, pos, range, currentPos -> {
                BlockState blockState = world.func_180495_p(currentPos);
                return blockState.func_177230_c() instanceof IGrowable && ((IGrowable)blockState.func_177230_c()).func_176473_a((IBlockReader)world, currentPos, blockState, world.field_72995_K);
            });
        }
        return cache.getNextBlockInQueue();
    }

    private void cycleMode(ItemStack harvestRod) {
        String currentMode = this.getMode(harvestRod);
        int plantableCount = this.getCountPlantable(harvestRod);
        switch (currentMode) {
            case "bone_meal": {
                if (plantableCount > 0) {
                    this.setMode(harvestRod, PLANTABLE_MODE);
                    this.setCurrentPlantableSlot(harvestRod, (byte)1);
                    break;
                }
                this.setMode(harvestRod, HOE_MODE);
                break;
            }
            case "plantable": {
                if (plantableCount > this.getCurrentPlantableSlot(harvestRod)) {
                    this.setCurrentPlantableSlot(harvestRod, (byte)(this.getCurrentPlantableSlot(harvestRod) + 1));
                    break;
                }
                this.setMode(harvestRod, HOE_MODE);
                break;
            }
            case "hoe": {
                this.setMode(harvestRod, BONE_MEAL_MODE);
                break;
            }
        }
    }

    public int getCountPlantable(ItemStack harvestRod) {
        return this.getCountPlantable(harvestRod, false);
    }

    private int getCountPlantable(ItemStack harvestRod, boolean isClient) {
        if (isClient) {
            return NBTHelper.getCountContainedStacks(harvestRod);
        }
        return this.getFromHandler(harvestRod, HarvestRodItemStackHandler::getCountPlantable).orElse(0);
    }

    public byte getCurrentPlantableSlot(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74771_c(PLANTABLE_INDEX_NBT_TAG) : (byte)-1;
    }

    private void setCurrentPlantableSlot(ItemStack stack, byte index) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74774_a(PLANTABLE_INDEX_NBT_TAG, index);
            this.updateContainedStacks(stack);
        }
    }

    private void setMode(ItemStack stack, String mode) {
        NBTHelper.putString(MODE_NBT_TAG, stack, mode);
        this.updateContainedStacks(stack);
    }

    public void updateContainedStacks(ItemStack stack) {
        NBTHelper.removeContainedStacks(stack);
        NBTHelper.updateContainedStack(stack, (short)0, ItemStack.field_190927_a, this.getBoneMealCount(stack));
        for (short slot = 1; slot < this.getCountPlantable(stack) + 1; slot = (short)(slot + 1)) {
            NBTHelper.updateContainedStack(stack, slot, this.getPlantableInSlot(stack, slot), this.getPlantableQuantity(stack, slot));
        }
    }

    public String getMode(ItemStack stack) {
        String mode = NBTHelper.getString(MODE_NBT_TAG, stack);
        return mode.equals("") ? BONE_MEAL_MODE : mode;
    }

    public int getPlantableQuantity(ItemStack harvestRod, int parentSlot) {
        return this.getPlantableQuantity(harvestRod, parentSlot, false);
    }

    public int getPlantableQuantity(ItemStack harvestRod, int slot, boolean isClient) {
        if (isClient) {
            return NBTHelper.getContainedStackCount(harvestRod, slot);
        }
        return this.getFromHandler(harvestRod, h -> h.getTotalAmount(slot)).orElse(0);
    }

    public Optional<FilteredBigItemStack> setPlantableQuantity(ItemStack harvestRod, byte plantableSlot, int quantity) {
        this.runOnHandler(harvestRod, h -> h.setTotalAmount(plantableSlot, quantity));
        if (quantity == 0) {
            this.shiftModeOnEmptyPlantable(harvestRod, plantableSlot);
            return Optional.empty();
        }
        return this.getFromHandler(harvestRod, h -> h.getBigStack(plantableSlot));
    }

    private void setPlantableQuantity(ItemStack harvestRod, byte plantableSlot, int quantity, PlayerEntity player) {
        this.setPlantableQuantity(harvestRod, plantableSlot, quantity).ifPresent(bigStack -> this.updateContainedItemNBT(harvestRod, player, plantableSlot, bigStack.getFilterStack(), bigStack.getAmount(), true));
    }
}

