/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xreliquary.items.IceMagusRodItem;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;

public class GlacialStaffItem
extends IceMagusRodItem {
    private static final String SNOWBALLS_TAG = "snowballs";
    private static final String BLOCK_LOCATIONS_TAG = "blockLocations";

    public GlacialStaffItem() {
        super("glacial_staff");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack staff, @Nullable World world, List<ITextComponent> tooltip) {
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"charge", (Object)Integer.toString(NBTHelper.getInt(SNOWBALLS_TAG, staff))), tooltip);
        if (this.isEnabled(staff)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.BLUE + Items.field_151126_ay.func_200295_i(new ItemStack((IItemProvider)Items.field_151126_ay)).toString())), tooltip);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, tooltip);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity e) {
        if (e instanceof LivingEntity && NBTHelper.getInt(SNOWBALLS_TAG, stack) >= this.getSnowballCost()) {
            LivingEntity livingBase = (LivingEntity)e;
            EffectInstance slow = new EffectInstance(Effects.field_76421_d, 30, 0);
            EffectInstance slownessEffect = livingBase.func_70660_b(Effects.field_76421_d);
            if (slownessEffect != null) {
                slow = new EffectInstance(Effects.field_76421_d, Math.min(slownessEffect.func_76459_b() + 30, 300), Math.min(slownessEffect.func_76458_c() + 1, 4));
            }
            ((LivingEntity)e).func_195064_c(slow);
            e.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), (float)slow.func_76458_c());
            NBTHelper.putInt(SNOWBALLS_TAG, stack, NBTHelper.getInt(SNOWBALLS_TAG, stack) - this.getSnowballCost());
        }
        return super.onLeftClickEntity(stack, player, e);
    }

    @Override
    public void func_77663_a(ItemStack staff, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(staff, world, entity, itemSlot, isSelected);
        PlayerEntity player = null;
        if (entity instanceof PlayerEntity) {
            player = (PlayerEntity)entity;
        }
        if (player == null) {
            return;
        }
        if (this.isEnabled(staff)) {
            this.freezeBlocks(staff, world, player);
        }
        this.meltBlocks(staff, world, player);
    }

    private void freezeBlocks(ItemStack staff, World world, PlayerEntity player) {
        int x = MathHelper.func_76128_c((double)player.func_226277_ct_());
        int y = MathHelper.func_76128_c((double)player.func_174813_aQ().field_72338_b) - 1;
        int z = MathHelper.func_76128_c((double)player.func_226281_cx_());
        for (int xOff = -2; xOff <= 2; ++xOff) {
            for (int zOff = -2; zOff <= 2; ++zOff) {
                if (Math.abs(xOff) == 2 && Math.abs(zOff) == 2) continue;
                this.doFreezeCheck(staff, x, y, z, world, xOff, zOff);
            }
        }
    }

    private void meltBlocks(ItemStack staff, World world, PlayerEntity player) {
        if (!world.field_72995_K) {
            for (BlockPos pos : this.getBlockLocations(staff)) {
                int xOff = Math.abs(MathHelper.func_76128_c((double)player.func_226277_ct_()) - pos.func_177958_n());
                int yOff = Math.abs(MathHelper.func_76128_c((double)player.func_226278_cu_()) - pos.func_177956_o());
                int zOff = Math.abs(MathHelper.func_76128_c((double)player.func_226281_cx_()) - pos.func_177952_p());
                if (xOff < 3 && yOff < 3 && zOff < 3 && (xOff != 2 || zOff != 2)) continue;
                this.doThawCheck(staff, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), world);
            }
        }
    }

    private BlockPos[] getBlockLocations(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        if (!tagCompound.func_74764_b(BLOCK_LOCATIONS_TAG)) {
            tagCompound.func_218657_a(BLOCK_LOCATIONS_TAG, (INBT)new ListNBT());
        }
        ListNBT tagList = tagCompound.func_150295_c(BLOCK_LOCATIONS_TAG, 10);
        BlockPos[] locations = new BlockPos[tagList.size()];
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbtLocation = (CompoundNBT)tagList.get(i);
            locations[i] = new BlockPos(nbtLocation.func_74762_e("x"), nbtLocation.func_74762_e("y"), nbtLocation.func_74762_e("z"));
        }
        return locations;
    }

    private void doFreezeCheck(ItemStack stack, int x, int y, int z, World world, int xOff, int zOff) {
        block3: {
            BlockState blockState;
            block2: {
                blockState = world.func_180495_p(new BlockPos(x += xOff, y, z += zOff));
                if (blockState.func_177230_c() != Blocks.field_150355_j || (Integer)blockState.func_177229_b((Property)FlowingFluidBlock.field_176367_b) != 0 || !world.func_175623_d(new BlockPos(x, y + 1, z))) break block2;
                this.addFrozenBlockToList(stack, x, y, z);
                world.func_175656_a(new BlockPos(x, y, z), Blocks.field_150403_cj.func_176223_P());
                for (int particleNum = world.field_73012_v.nextInt(3); particleNum < 2; ++particleNum) {
                    float xVel = world.field_73012_v.nextFloat();
                    float yVel = world.field_73012_v.nextFloat() + 0.5f;
                    float zVel = world.field_73012_v.nextFloat();
                    world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, (double)((float)x + xVel), (double)((float)y + yVel), (double)((float)z + zVel), 0.75, 0.75, 1.0);
                }
                break block3;
            }
            if (blockState.func_177230_c() != Blocks.field_150353_l || (Integer)blockState.func_177229_b((Property)FlowingFluidBlock.field_176367_b) != 0) break block3;
            this.addFrozenBlockToList(stack, x, y, z);
            world.func_175656_a(new BlockPos(x, y, z), Blocks.field_150343_Z.func_176223_P());
            for (int particleNum = world.field_73012_v.nextInt(3); particleNum < 2; ++particleNum) {
                float xVel = world.field_73012_v.nextFloat();
                float yVel = world.field_73012_v.nextFloat() + 0.5f;
                float zVel = world.field_73012_v.nextFloat();
                world.func_195594_a((IParticleData)(world.field_73012_v.nextInt(3) == 0 ? ParticleTypes.field_197594_E : ParticleTypes.field_197601_L), (double)((float)x + xVel), (double)((float)y + yVel), (double)((float)z + zVel), 0.0, 0.2, 0.0);
            }
        }
    }

    private void doThawCheck(ItemStack stack, int x, int y, int z, World world) {
        block4: {
            BlockState blockState;
            block3: {
                blockState = world.func_180495_p(new BlockPos(x, y, z));
                if (blockState != Blocks.field_150403_cj.func_176223_P()) break block3;
                if (!this.removeFrozenBlockFromList(stack, x, y, z)) break block4;
                world.func_175656_a(new BlockPos(x, y, z), Blocks.field_150355_j.func_176223_P());
                for (int particleNum = world.field_73012_v.nextInt(3); particleNum < 2; ++particleNum) {
                    float xVel = world.field_73012_v.nextFloat();
                    float yVel = world.field_73012_v.nextFloat() + 0.5f;
                    float zVel = world.field_73012_v.nextFloat();
                    world.func_195594_a((IParticleData)(world.field_73012_v.nextInt(3) == 0 ? ParticleTypes.field_197594_E : ParticleTypes.field_197601_L), (double)((float)x + xVel), (double)((float)y + yVel), (double)((float)z + zVel), 0.0, 0.2, 0.0);
                }
                break block4;
            }
            if (blockState == Blocks.field_150343_Z.func_176223_P() && this.removeFrozenBlockFromList(stack, x, y, z)) {
                world.func_175656_a(new BlockPos(x, y, z), Blocks.field_150353_l.func_176223_P());
                float red = 1.0f;
                float green = 0.0f;
                float blue = 0.0f;
                for (int particleNum = world.field_73012_v.nextInt(3); particleNum < 2; ++particleNum) {
                    float xVel = world.field_73012_v.nextFloat();
                    float yVel = world.field_73012_v.nextFloat() + 0.5f;
                    float zVel = world.field_73012_v.nextFloat();
                    world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, (double)((float)x + xVel), (double)((float)y + yVel), (double)((float)z + zVel), (double)red, (double)green, (double)blue);
                }
            }
        }
    }

    private void addFrozenBlockToList(ItemStack stack, int x, int y, int z) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        if (!tagCompound.func_74764_b(BLOCK_LOCATIONS_TAG)) {
            tagCompound.func_218657_a(BLOCK_LOCATIONS_TAG, (INBT)new ListNBT());
        }
        ListNBT tagList = tagCompound.func_150295_c(BLOCK_LOCATIONS_TAG, 10);
        CompoundNBT newTagData = new CompoundNBT();
        newTagData.func_74768_a("x", x);
        newTagData.func_74768_a("y", y);
        newTagData.func_74768_a("z", z);
        tagList.add((Object)newTagData);
        tagCompound.func_218657_a(BLOCK_LOCATIONS_TAG, (INBT)tagList);
        stack.func_77982_d(tagCompound);
    }

    private boolean removeFrozenBlockFromList(ItemStack stack, int x, int y, int z) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        if (!tagCompound.func_74764_b(BLOCK_LOCATIONS_TAG)) {
            tagCompound.func_218657_a(BLOCK_LOCATIONS_TAG, (INBT)new ListNBT());
        }
        ListNBT tagList = tagCompound.func_150295_c(BLOCK_LOCATIONS_TAG, 10);
        boolean removedBlock = false;
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tagItemData = tagList.func_150305_b(i);
            if (tagItemData.func_74762_e("x") != x || tagItemData.func_74762_e("y") != y || tagItemData.func_74762_e("z") != z) continue;
            tagItemData.func_74757_a("remove", true);
            removedBlock = true;
        }
        ListNBT newTagList = new ListNBT();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tagItemData = tagList.func_150305_b(i);
            if (tagItemData.func_74767_n("remove")) continue;
            CompoundNBT newTagData = new CompoundNBT();
            newTagData.func_74768_a("x", tagItemData.func_74762_e("x"));
            newTagData.func_74768_a("y", tagItemData.func_74762_e("y"));
            newTagData.func_74768_a("z", tagItemData.func_74762_e("z"));
            newTagList.add((Object)newTagData);
        }
        tagCompound.func_218657_a(BLOCK_LOCATIONS_TAG, (INBT)newTagList);
        stack.func_77982_d(tagCompound);
        return removedBlock;
    }
}

