/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItem;
import xreliquary.blocks.tile.PedestalTileEntity;
import xreliquary.init.ModFluids;
import xreliquary.init.ModItems;
import xreliquary.items.ItemBase;
import xreliquary.items.util.IBaubleItem;
import xreliquary.pedestal.PedestalRegistry;
import xreliquary.reference.Settings;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.RandHelper;
import xreliquary.util.XpHelper;

public class FortuneCoinItem
extends ItemBase
implements IPedestalActionItem,
IBaubleItem {
    private static final String SOUND_TIMER_TAG = "soundTimer";

    public FortuneCoinItem() {
        super("fortune_coin", new Item.Properties().func_200917_a(1));
    }

    @Override
    public void onEquipped(String identifier, LivingEntity player) {
        if (player.field_70170_p.field_72995_K) {
            player.func_184185_a(SoundEvents.field_187604_bf, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.field_70170_p.field_73012_v) * 0.7f + 2.2f));
        }
    }

    @Override
    public IBaubleItem.Type getBaubleType() {
        return IBaubleItem.Type.NECKLACE;
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity player) {
        this.func_77663_a(stack, player.field_70170_p, (Entity)player, 0, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip) {
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip2", tooltip);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.EPIC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isEnabled(stack);
    }

    private boolean isEnabled(ItemStack stack) {
        return NBTHelper.getBoolean("enabled", stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.field_72995_K) {
            return;
        }
        if (this.enabledAudio() && NBTHelper.getShort(SOUND_TIMER_TAG, stack) > 0) {
            if (NBTHelper.getShort(SOUND_TIMER_TAG, stack) % 2 == 0) {
                world.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * RandHelper.getRandomMinusOneToOne(world.field_73012_v) * 0.7f + 1.8f);
            }
            NBTHelper.putShort(SOUND_TIMER_TAG, stack, (short)(NBTHelper.getShort(SOUND_TIMER_TAG, stack) - 1));
        }
        if (!this.isEnabled(stack)) {
            return;
        }
        PlayerEntity player = null;
        if (entity instanceof PlayerEntity) {
            player = (PlayerEntity)entity;
        }
        if (player == null || player.func_175149_v()) {
            return;
        }
        this.scanForEntitiesInRange(world, player, this.getStandardPullDistance());
    }

    private void scanForEntitiesInRange(World world, PlayerEntity player, double d) {
        List<BlockPos> disablePositions = this.getDisablePositions(world, player.func_233580_cy_());
        List iList = world.func_217357_a(ItemEntity.class, new AxisAlignedBB(player.func_226277_ct_() - d, player.func_226278_cu_() - d, player.func_226281_cx_() - d, player.func_226277_ct_() + d, player.func_226278_cu_() + d, player.func_226281_cx_() + d));
        for (ItemEntity item : iList) {
            if (!this.canPickupItem(item, disablePositions) || !this.checkForRoom(item.func_92059_d(), player)) continue;
            item.func_174867_a(0);
            if (!((double)player.func_70032_d((Entity)item) >= 1.5)) continue;
            this.teleportEntityToPlayer((Entity)item, player);
            break;
        }
        List iList2 = world.func_217357_a(ExperienceOrbEntity.class, new AxisAlignedBB(player.func_226277_ct_() - d, player.func_226278_cu_() - d, player.func_226281_cx_() - d, player.func_226277_ct_() + d, player.func_226278_cu_() + d, player.func_226281_cx_() + d));
        for (ExperienceOrbEntity item : iList2) {
            if (player.field_71090_bL > 0) {
                player.field_71090_bL = 0;
            }
            if (!((double)player.func_70032_d((Entity)item) >= 1.5)) continue;
            this.teleportEntityToPlayer((Entity)item, player);
            break;
        }
    }

    private boolean canPickupItem(ItemEntity item, List<BlockPos> disablePositions) {
        return !item.getPersistentData().func_74767_n("PreventRemoteMovement") && !this.isInDisabledRange(item, disablePositions);
    }

    private boolean isInDisabledRange(ItemEntity item, List<BlockPos> disablePositions) {
        for (BlockPos disablePos : disablePositions) {
            if (Math.abs(item.func_233580_cy_().func_177958_n() - disablePos.func_177958_n()) >= 5 || Math.abs(item.func_233580_cy_().func_177956_o() - disablePos.func_177956_o()) >= 5 || Math.abs(item.func_233580_cy_().func_177952_p() - disablePos.func_177952_p()) >= 5) continue;
            return true;
        }
        return false;
    }

    private List<BlockPos> getDisablePositions(World world, BlockPos coinPos) {
        ArrayList<BlockPos> disablePositions = new ArrayList<BlockPos>();
        List<BlockPos> pedestalPositions = PedestalRegistry.getPositionsInRange(world.func_234923_W_().getRegistryName(), coinPos, 10);
        for (BlockPos pos : pedestalPositions) {
            ItemStack stack;
            PedestalTileEntity pedestal;
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof PedestalTileEntity) || !(pedestal = (PedestalTileEntity)te).switchedOn() || (stack = pedestal.func_70301_a(0)).func_190926_b() || stack.func_77973_b() != this || this.isEnabled(stack)) continue;
            disablePositions.add(pos);
        }
        return disablePositions;
    }

    private void teleportEntityToPlayer(Entity item, PlayerEntity player) {
        player.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, item.func_226277_ct_() + 0.5 + player.field_70170_p.field_73012_v.nextGaussian() / 8.0, item.func_226278_cu_() + 0.2, item.func_226281_cx_() + 0.5 + player.field_70170_p.field_73012_v.nextGaussian() / 8.0, 0.9, 0.9, 0.0);
        player.func_70040_Z();
        double x = player.func_226277_ct_() + player.func_70040_Z().field_72450_a * 0.2;
        double y = player.func_226278_cu_();
        double z = player.func_226281_cx_() + player.func_70040_Z().field_72449_c * 0.2;
        item.func_70107_b(x, y, z);
        if (this.enabledAudio()) {
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.field_70170_p.field_73012_v) * 0.7f + 1.8f));
        }
    }

    private boolean checkForRoom(ItemStack stackToPickup, PlayerEntity player) {
        int remaining = stackToPickup.func_190916_E();
        for (ItemStack inventoryStack : player.field_71071_by.field_70462_a) {
            if (inventoryStack.func_190926_b()) {
                return true;
            }
            if (inventoryStack.func_77973_b() == stackToPickup.func_77973_b() && inventoryStack.func_77952_i() == stackToPickup.func_77952_i()) {
                if (inventoryStack.func_190916_E() + remaining <= inventoryStack.func_77976_d()) {
                    return true;
                }
                remaining -= inventoryStack.func_77976_d() - inventoryStack.func_190916_E();
                continue;
            }
            if (inventoryStack.func_77973_b() != ModItems.VOID_TEAR || !ModItems.VOID_TEAR.isEnabled(inventoryStack) || !ModItems.VOID_TEAR.canAbsorbStack(stackToPickup, inventoryStack)) continue;
            return true;
        }
        return false;
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int count) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        this.scanForEntitiesInRange(player.field_70170_p, player, this.getLongRangePullDistance());
    }

    private double getLongRangePullDistance() {
        return ((Integer)Settings.COMMON.items.fortuneCoin.longRangePullDistance.get()).intValue();
    }

    private double getStandardPullDistance() {
        return ((Integer)Settings.COMMON.items.fortuneCoin.standardPullDistance.get()).intValue();
    }

    public int func_77626_a(ItemStack stack) {
        return 64;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            if (this.enabledAudio()) {
                NBTHelper.putShort(SOUND_TIMER_TAG, stack, (short)6);
            }
            this.toggle(stack);
        } else {
            player.func_184598_c(hand);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    private boolean enabledAudio() {
        return (Boolean)Settings.COMMON.items.fortuneCoin.enabledAudio.get();
    }

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        World world = pedestal.getTheWorld();
        if (world.field_72995_K) {
            return;
        }
        if (this.isEnabled(stack)) {
            BlockPos pos = pedestal.getBlockPos();
            double d = this.getStandardPullDistance();
            List<BlockPos> disablePositions = this.getDisablePositions(world, pos);
            List entities = world.func_217357_a(ItemEntity.class, new AxisAlignedBB((double)pos.func_177958_n() - d, (double)pos.func_177956_o() - d, (double)pos.func_177952_p() - d, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d, (double)pos.func_177952_p() + d));
            for (ItemEntity entityItem : entities) {
                if (!this.canPickupItem(entityItem, disablePositions)) continue;
                int numberAdded = pedestal.addToConnectedInventory(entityItem.func_92059_d().func_77946_l());
                if (numberAdded > 0) {
                    entityItem.func_92059_d().func_190920_e(entityItem.func_92059_d().func_190916_E() - numberAdded);
                    if (entityItem.func_92059_d().func_190916_E() > 0) continue;
                    entityItem.func_70106_y();
                    continue;
                }
                pedestal.setActionCoolDown(20);
            }
            List xpOrbs = world.func_217357_a(ExperienceOrbEntity.class, new AxisAlignedBB((double)pos.func_177958_n() - d, (double)pos.func_177956_o() - d, (double)pos.func_177952_p() - d, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d, (double)pos.func_177952_p() + d));
            for (ExperienceOrbEntity xpOrb : xpOrbs) {
                int amountToTransfer = XpHelper.experienceToLiquid(xpOrb.field_70530_e);
                int amountAdded = pedestal.fillConnectedTank(new FluidStack((Fluid)ModFluids.XP_JUICE_STILL.get(), amountToTransfer));
                if (amountAdded > 0) {
                    xpOrb.func_70106_y();
                    if (amountToTransfer <= amountAdded) continue;
                    world.func_217376_c((Entity)new ExperienceOrbEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), XpHelper.liquidToExperience(amountToTransfer - amountAdded)));
                    continue;
                }
                pedestal.setActionCoolDown(20);
            }
        }
    }

    @Override
    public void onRemoved(ItemStack stack, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, IPedestal pedestal) {
    }

    public void toggle(ItemStack stack) {
        NBTHelper.putBoolean("enabled", stack, !this.isEnabled(stack));
    }
}

