/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.init;

import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import xreliquary.Reliquary;
import xreliquary.blocks.AlkahestryAltarBlock;
import xreliquary.blocks.ApothecaryCauldronBlock;
import xreliquary.blocks.ApothecaryMortarBlock;
import xreliquary.blocks.BaseBlock;
import xreliquary.blocks.FertileLilyPadBlock;
import xreliquary.blocks.InterdictionTorchBlock;
import xreliquary.blocks.PassivePedestalBlock;
import xreliquary.blocks.PedestalBlock;
import xreliquary.blocks.WallInterdictionTorchBlock;
import xreliquary.blocks.WraithNodeBlock;
import xreliquary.blocks.tile.AlkahestryAltarTileEntity;
import xreliquary.blocks.tile.ApothecaryCauldronTileEntity;
import xreliquary.blocks.tile.ApothecaryMortarTileEntity;
import xreliquary.blocks.tile.PassivePedestalTileEntity;
import xreliquary.blocks.tile.PedestalTileEntity;
import xreliquary.items.block.BlockItemBase;
import xreliquary.items.block.FertileLilyPadItem;
import xreliquary.reference.Settings;
import xreliquary.util.InjectionHelper;
import xreliquary.util.LanguageHelper;

@Mod.EventBusSubscriber(modid="xreliquary", bus=Mod.EventBusSubscriber.Bus.MOD)
@ObjectHolder(value="xreliquary")
public class ModBlocks {
    public static final AlkahestryAltarBlock ALKAHESTRY_ALTAR = (AlkahestryAltarBlock)((Object)InjectionHelper.nullValue());
    public static final ApothecaryCauldronBlock APOTHECARY_CAULDRON = (ApothecaryCauldronBlock)((Object)InjectionHelper.nullValue());
    public static final BaseBlock APOTHECARY_MORTAR = (BaseBlock)((Object)InjectionHelper.nullValue());
    public static final FertileLilyPadBlock FERTILE_LILY_PAD = (FertileLilyPadBlock)((Object)InjectionHelper.nullValue());
    public static final InterdictionTorchBlock INTERDICTION_TORCH = (InterdictionTorchBlock)((Object)InjectionHelper.nullValue());
    public static final WallInterdictionTorchBlock WALL_INTERDICTION_TORCH = (WallInterdictionTorchBlock)((Object)InjectionHelper.nullValue());
    public static final WraithNodeBlock WRAITH_NODE = (WraithNodeBlock)((Object)InjectionHelper.nullValue());

    private ModBlocks() {
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new AlkahestryAltarBlock());
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePotions.get())) {
            registry.register((IForgeRegistryEntry)new ApothecaryCauldronBlock());
            registry.register((IForgeRegistryEntry)new ApothecaryMortarBlock());
        }
        registry.register((IForgeRegistryEntry)new FertileLilyPadBlock());
        registry.register((IForgeRegistryEntry)new InterdictionTorchBlock());
        registry.register((IForgeRegistryEntry)new WallInterdictionTorchBlock());
        registry.register((IForgeRegistryEntry)new WraithNodeBlock());
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePedestal.get())) {
            for (DyeColor dyecolor : DyeColor.values()) {
                registry.register((IForgeRegistryEntry)new PedestalBlock(dyecolor));
            }
        }
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePassivePedestal.get())) {
            for (DyeColor dyecolor : DyeColor.values()) {
                registry.register((IForgeRegistryEntry)new PassivePedestalBlock(dyecolor));
            }
        }
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        ModBlocks.registerTileEntity(event, "alkahestry_altar", AlkahestryAltarTileEntity::new, ALKAHESTRY_ALTAR);
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePedestal.get())) {
            ModBlocks.registerTileEntity(event, "pedestal", PedestalTileEntity::new, PedestalBlock.ALL_PEDESTAL_BLOCKS.toArray(new Block[0]));
        }
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePassivePedestal.get())) {
            ModBlocks.registerTileEntity(event, "passive_pedestal", PassivePedestalTileEntity::new, PassivePedestalBlock.ALL_PEDESTAL_BLOCKS.toArray(new Block[0]));
        }
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePotions.get())) {
            ModBlocks.registerTileEntity(event, "apothecary_cauldron", ApothecaryCauldronTileEntity::new, APOTHECARY_CAULDRON);
            ModBlocks.registerTileEntity(event, "apothecary_mortar", ApothecaryMortarTileEntity::new, APOTHECARY_MORTAR);
        }
    }

    private static void registerTileEntity(RegistryEvent.Register<TileEntityType<?>> event, String tileRegistryName, Supplier<? extends TileEntity> tileFactory, Block ... validBlocks) {
        event.getRegistry().register(TileEntityType.Builder.func_223042_a(tileFactory, (Block[])validBlocks).func_206865_a(null).setRegistryName("xreliquary", tileRegistryName));
    }

    @SubscribeEvent
    public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ModBlocks.registerItemBlock((IForgeRegistry<Item>)registry, ALKAHESTRY_ALTAR, "alkahestry_altar");
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePotions.get())) {
            ModBlocks.registerItemBlock((IForgeRegistry<Item>)registry, APOTHECARY_CAULDRON, "apothecary_cauldron");
            ModBlocks.registerItemBlock((IForgeRegistry<Item>)registry, APOTHECARY_MORTAR, "apothecary_mortar");
        }
        ModBlocks.registerItemBlock((IForgeRegistry<Item>)registry, (Block)FERTILE_LILY_PAD, new FertileLilyPadItem(), "fertile_lily_pad");
        ModBlocks.registerItemBlock((IForgeRegistry<Item>)registry, (Block)INTERDICTION_TORCH, (BlockItem)new WallOrFloorItem((Block)INTERDICTION_TORCH, (Block)WALL_INTERDICTION_TORCH, new Item.Properties().func_200916_a(Reliquary.ITEM_GROUP)){

            public ITextComponent func_200295_i(ItemStack stack) {
                return new StringTextComponent(LanguageHelper.getLocalization(this.func_77667_c(stack), new Object[0]));
            }
        }, "interdiction_torch");
        ModBlocks.registerItemBlock((IForgeRegistry<Item>)registry, WRAITH_NODE, "wraith_node");
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePedestal.get())) {
            PedestalBlock.ALL_PEDESTAL_BLOCKS.forEach(b -> ModBlocks.registerItemBlock((IForgeRegistry<Item>)registry, b, new BlockItemBase((Block)b, new Item.Properties()){

                public ITextComponent func_200295_i(ItemStack stack) {
                    return new TranslationTextComponent("block.xreliquary.pedestal");
                }
            }, "pedestal"));
        }
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePassivePedestal.get())) {
            PassivePedestalBlock.ALL_PEDESTAL_BLOCKS.forEach(b -> ModBlocks.registerItemBlock((IForgeRegistry<Item>)registry, b, new BlockItemBase((Block)b, new Item.Properties()){

                public ITextComponent func_200295_i(ItemStack stack) {
                    return new TranslationTextComponent("block.xreliquary.passive_pedestal");
                }
            }, "passive_pedestal"));
        }
    }

    private static void registerItemBlock(IForgeRegistry<Item> registry, Block block, String jeiDescriptionKey) {
        ModBlocks.registerItemBlock(registry, block, new BlockItemBase(block, new Item.Properties()), jeiDescriptionKey);
    }

    private static void registerItemBlock(IForgeRegistry<Item> registry, Block block, BlockItem itemBlock, String jeiDescriptionKey) {
        registry.register(itemBlock.setRegistryName(block.getRegistryName()));
        Reliquary.proxy.registerJEI(block, jeiDescriptionKey);
    }
}

