/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities.shot;

import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import xreliquary.entities.shot.ShotEntityBase;
import xreliquary.init.ModEntities;
import xreliquary.reference.ClientReference;

public class BlazeShotEntity
extends ShotEntityBase {
    public BlazeShotEntity(EntityType<BlazeShotEntity> entityType, World world) {
        super(entityType, world);
    }

    public BlazeShotEntity(World world, PlayerEntity player, Hand hand) {
        super(ModEntities.BLAZE_SHOT, world, player, hand);
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0 && this.ticksInAir < 9) {
            Vector3d motion = this.func_213322_ci();
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.lowGauss(motion.func_82615_a()), this.lowGauss(motion.func_82617_b()), this.lowGauss(motion.func_82616_c()));
        }
    }

    @Override
    void doFiringEffects() {
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197608_a, this.func_226277_ct_() + this.smallGauss(0.1), this.func_226278_cu_() + this.smallGauss(0.1), this.func_226281_cx_() + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.spawnMotionBasedParticle((IParticleData)ParticleTypes.field_197631_x);
    }

    @Override
    protected DamageSource getDamageSource() {
        return super.getDamageSource().func_76361_j();
    }

    @Override
    protected void func_70227_a(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entityHit = ((EntityRayTraceResult)result).func_216348_a();
            if (entityHit == this.shootingEntity || !(entityHit instanceof LivingEntity)) {
                return;
            }
            this.onImpact((LivingEntity)entityHit);
        } else if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            if (this.shootingEntity == null) {
                return;
            }
            BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
            this.groundImpact(blockResult.func_216354_b());
            BlockPos fireSpawnPos = blockResult.func_216350_a().func_177972_a(blockResult.func_216354_b());
            if (this.shootingEntity.func_175151_a(fireSpawnPos, blockResult.func_216354_b(), new ItemStack((IItemProvider)Items.field_151033_d)) && this.field_70170_p.func_175623_d(fireSpawnPos)) {
                this.field_70170_p.func_175656_a(fireSpawnPos, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    @Override
    protected void onImpact(LivingEntity entityLiving) {
        entityLiving.func_70015_d(40);
        super.onImpact(entityLiving);
    }

    @Override
    void spawnHitParticles(int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.spawnMotionBasedParticle((IParticleData)ParticleTypes.field_197631_x);
        }
    }

    @Override
    protected void groundImpact(Direction sideHit) {
        this.func_70106_y();
    }

    @Override
    int getRicochetMax() {
        return 0;
    }

    @Override
    int getDamageOfShot(LivingEntity mop) {
        return mop.func_230279_az_() ? 2 : 10 + this.d12();
    }

    @Override
    void doBurstEffect(Direction sideHit) {
        Vector3d motion = this.func_213322_ci();
        double motionX = motion.func_82615_a();
        double motionY = motion.func_82617_b();
        double motionZ = motion.func_82616_c();
        block8: for (int particles = 0; particles < 40; ++particles) {
            switch (sideHit) {
                case DOWN: {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.smallGauss(0.1) + motionX / 4.0, -this.posGauss(0.2), this.smallGauss(0.2) + motionZ / 4.0);
                    continue block8;
                }
                case UP: {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.smallGauss(0.1) + motionX / 4.0, this.posGauss(0.2), this.smallGauss(0.2) + motionZ / 4.0);
                    continue block8;
                }
                case NORTH: {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.smallGauss(0.1) + motionX / 4.0, this.smallGauss(0.1) + motionY / 4.0, -this.posGauss(0.2));
                    continue block8;
                }
                case SOUTH: {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.smallGauss(0.1) + motionX / 4.0, this.smallGauss(0.1) + motionY / 4.0, this.posGauss(0.2));
                    continue block8;
                }
                case WEST: {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), -this.posGauss(0.2), this.smallGauss(0.1) + motionY / 4.0, this.smallGauss(0.1) + motionZ / 4.0);
                    continue block8;
                }
                case EAST: {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.posGauss(0.2), this.smallGauss(0.1) + motionY / 4.0, this.smallGauss(0.1) + motionZ / 4.0);
                }
            }
        }
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.BLAZE;
    }
}

