/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xreliquary.init.ModEntities;
import xreliquary.init.ModItems;
import xreliquary.reference.Settings;
import xreliquary.util.LogHelper;

public class LyssaBobberEntity
extends ProjectileEntity
implements IEntityAdditionalSpawnData {
    private final Random field_234596_b_ = new Random();
    private boolean field_234597_c_;
    private int field_234598_d_;
    private static final DataParameter<Integer> DATA_HOOKED_ENTITY = EntityDataManager.func_187226_a(FishingBobberEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_234599_f_ = EntityDataManager.func_187226_a(FishingBobberEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int ticksInGround;
    private int ticksCatchable;
    private int ticksCaughtDelay;
    private int ticksCatchableDelay;
    private float fishApproachAngle;
    private boolean field_234595_aq_ = true;
    private Entity caughtEntity;
    private State currentState = State.FLYING;
    private int luck;
    private int lureSpeed;
    private static final Field HANDS_CHANCES = ObfuscationReflectionHelper.findField(MobEntity.class, (String)"field_82174_bp");
    private static final Field ARMOR_CHANCES = ObfuscationReflectionHelper.findField(MobEntity.class, (String)"field_184655_bs");

    public LyssaBobberEntity(EntityType<LyssaBobberEntity> entityType, World world) {
        super(entityType, world);
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
    }

    public LyssaBobberEntity(World world, PlayerEntity fishingPlayer, int lureSpeed, int luck) {
        super(ModEntities.LYSSA_HOOK, world);
        this.field_70158_ak = true;
        this.func_212361_a((Entity)fishingPlayer);
        this.luck = Math.max(0, luck);
        this.lureSpeed = Math.max(0, lureSpeed);
        this.shoot(fishingPlayer);
        this.speedUp();
    }

    private void shoot(PlayerEntity fishingPlayer) {
        float f = fishingPlayer.field_70125_A;
        float f1 = fishingPlayer.field_70177_z;
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        double d0 = fishingPlayer.func_226277_ct_() - (double)f3 * 0.3;
        double d1 = fishingPlayer.func_226278_cu_() + (double)fishingPlayer.func_70047_e();
        double d2 = fishingPlayer.func_226281_cx_() - (double)f2 * 0.3;
        this.func_70012_b(d0, d1, d2, f1, f);
        Vector3d vec3d = new Vector3d((double)(-f3), (double)MathHelper.func_76131_a((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3d.func_72433_c();
        vec3d = vec3d.func_216372_d(0.6 / d3 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045);
        this.func_213317_d(vec3d);
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)MathHelper.func_76133_a((double)this.func_195048_a(vec3d))) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DATA_HOOKED_ENTITY, (Object)0);
        this.func_184212_Q().func_187214_a(field_234599_f_, (Object)false);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (DATA_HOOKED_ENTITY.equals(key)) {
            int i = (Integer)this.func_184212_Q().func_187225_a(DATA_HOOKED_ENTITY);
            Entity entity = this.caughtEntity = i > 0 ? this.field_70170_p.func_73045_a(i - 1) : null;
        }
        if (field_234599_f_.equals(key)) {
            this.field_234597_c_ = (Boolean)this.func_184212_Q().func_187225_a(field_234599_f_);
            if (this.field_234597_c_) {
                this.func_213293_j(this.func_213322_ci().field_72450_a, -0.4f * MathHelper.func_151240_a((Random)this.field_234596_b_, (float)0.6f, (float)1.0f), this.func_213322_ci().field_72449_c);
            }
        }
        super.func_184206_a(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    private void tickOriginal() {
        this.field_234596_b_.setSeed(this.func_110124_au().getLeastSignificantBits() ^ this.field_70170_p.func_82737_E());
        super.func_70071_h_();
        PlayerEntity playerentity = this.getFishingPlayer();
        if (playerentity == null) {
            this.func_70106_y();
        } else if (this.field_70170_p.field_72995_K || !this.shouldStopFishing(playerentity)) {
            boolean flag;
            if (this.field_70122_E) {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.func_70106_y();
                    return;
                }
            } else {
                this.ticksInGround = 0;
            }
            float f = 0.0f;
            BlockPos blockpos = this.func_233580_cy_();
            FluidState fluidstate = this.field_70170_p.func_204610_c(blockpos);
            if (fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) {
                f = fluidstate.func_215679_a((IBlockReader)this.field_70170_p, blockpos);
            }
            boolean bl = flag = f > 0.0f;
            if (this.currentState == State.FLYING) {
                if (this.caughtEntity != null) {
                    this.func_213317_d(Vector3d.field_186680_a);
                    this.currentState = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (flag) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.3, 0.2, 0.3));
                    this.currentState = State.BOBBING;
                    return;
                }
                this.checkCollision();
            } else {
                if (this.currentState == State.HOOKED_IN_ENTITY) {
                    if (this.caughtEntity != null) {
                        if (this.caughtEntity.field_70128_L) {
                            this.caughtEntity = null;
                            this.currentState = State.FLYING;
                        } else {
                            this.func_70107_b(this.caughtEntity.func_226277_ct_(), this.caughtEntity.func_226283_e_(0.8), this.caughtEntity.func_226281_cx_());
                        }
                    }
                    return;
                }
                if (this.currentState == State.BOBBING) {
                    Vector3d vector3d = this.func_213322_ci();
                    double d0 = this.func_226278_cu_() + vector3d.field_72448_b - (double)blockpos.func_177956_o() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.func_213293_j(vector3d.field_72450_a * 0.9, vector3d.field_72448_b - d0 * (double)this.field_70146_Z.nextFloat() * 0.2, vector3d.field_72449_c * 0.9);
                    if (this.ticksCatchable <= 0 && this.ticksCatchableDelay <= 0) {
                        this.field_234595_aq_ = true;
                    } else {
                        boolean bl2 = this.field_234595_aq_ = this.field_234595_aq_ && this.field_234598_d_ < 10 && this.func_234603_b_(blockpos);
                    }
                    if (flag) {
                        this.field_234598_d_ = Math.max(0, this.field_234598_d_ - 1);
                        if (this.field_234597_c_) {
                            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.1 * (double)this.field_234596_b_.nextFloat() * (double)this.field_234596_b_.nextFloat(), 0.0));
                        }
                        if (!this.field_70170_p.field_72995_K) {
                            this.catchingFish(blockpos);
                        }
                    } else {
                        this.field_234598_d_ = Math.min(10, this.field_234598_d_ + 1);
                    }
                }
            }
            if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.03, 0.0));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_234617_x_();
            if (this.currentState == State.FLYING && (this.field_70122_E || this.field_70123_F)) {
                this.func_213317_d(Vector3d.field_186680_a);
            }
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.92));
            this.func_226264_Z_();
        }
    }

    @Nullable
    public PlayerEntity getFishingPlayer() {
        Entity entity = this.func_234616_v_();
        return entity instanceof PlayerEntity ? (PlayerEntity)entity : null;
    }

    private boolean func_234603_b_(BlockPos p_234603_1_) {
        WaterType waterType = WaterType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            WaterType fishingbobberentity$watertype1 = this.func_234602_a_(p_234603_1_.func_177982_a(-2, i, -2), p_234603_1_.func_177982_a(2, i, 2));
            switch (fishingbobberentity$watertype1) {
                case INVALID: {
                    return false;
                }
                case ABOVE_WATER: {
                    if (waterType != WaterType.INVALID) break;
                    return false;
                }
                case INSIDE_WATER: {
                    if (waterType != WaterType.ABOVE_WATER) break;
                    return false;
                }
            }
            waterType = fishingbobberentity$watertype1;
        }
        return true;
    }

    private WaterType func_234602_a_(BlockPos p_234602_1_, BlockPos p_234602_2_) {
        return BlockPos.func_218281_b((BlockPos)p_234602_1_, (BlockPos)p_234602_2_).map(this::func_234604_c_).reduce((p_234601_0_, p_234601_1_) -> p_234601_0_ == p_234601_1_ ? p_234601_0_ : WaterType.INVALID).orElse(WaterType.INVALID);
    }

    private WaterType func_234604_c_(BlockPos p_234604_1_) {
        BlockState blockstate = this.field_70170_p.func_180495_p(p_234604_1_);
        if (!blockstate.func_196958_f() && !blockstate.func_203425_a(Blocks.field_196651_dG)) {
            FluidState fluidstate = blockstate.func_204520_s();
            return fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && fluidstate.func_206889_d() && blockstate.func_196952_d((IBlockReader)this.field_70170_p, p_234604_1_).func_197766_b() ? WaterType.INSIDE_WATER : WaterType.INVALID;
        }
        return WaterType.ABOVE_WATER;
    }

    private void updateRotation() {
        Vector3d vec3d = this.func_213322_ci();
        float f = MathHelper.func_76133_a((double)this.func_195048_a(vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
    }

    private void checkCollision() {
        RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, this::func_230298_a_);
        this.func_70227_a(raytraceresult);
    }

    protected boolean func_230298_a_(Entity p_230298_1_) {
        return super.func_230298_a_(p_230298_1_) || p_230298_1_.func_70089_S() && p_230298_1_ instanceof ItemEntity;
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        super.func_213868_a(p_213868_1_);
        if (!this.field_70170_p.field_72995_K) {
            this.caughtEntity = p_213868_1_.func_216348_a();
            this.setHookedEntity();
        }
    }

    protected void func_230299_a_(BlockRayTraceResult p_230299_1_) {
        super.func_230299_a_(p_230299_1_);
        this.func_213317_d(this.func_213322_ci().func_72432_b().func_186678_a(p_230299_1_.func_237486_a_((Entity)this)));
    }

    private void setHookedEntity() {
        this.func_184212_Q().func_187227_b(DATA_HOOKED_ENTITY, (Object)(this.caughtEntity.func_145782_y() + 1));
    }

    private void catchingFish(BlockPos p_190621_1_) {
        ServerWorld serverworld = (ServerWorld)this.field_70170_p;
        int i = 1;
        BlockPos blockpos = p_190621_1_.func_177984_a();
        if (this.field_70146_Z.nextFloat() < 0.25f && this.field_70170_p.func_175727_C(blockpos)) {
            ++i;
        }
        if (this.field_70146_Z.nextFloat() < 0.5f && !this.field_70170_p.func_226660_f_(blockpos)) {
            --i;
        }
        if (this.ticksCatchable > 0) {
            --this.ticksCatchable;
            if (this.ticksCatchable <= 0) {
                this.ticksCaughtDelay = 0;
                this.ticksCatchableDelay = 0;
                this.func_184212_Q().func_187227_b(field_234599_f_, (Object)false);
            }
        } else if (this.ticksCatchableDelay > 0) {
            this.ticksCatchableDelay -= i;
            if (this.ticksCatchableDelay > 0) {
                this.fishApproachAngle = (float)((double)this.fishApproachAngle + this.field_70146_Z.nextGaussian() * 4.0);
                float f = this.fishApproachAngle * ((float)Math.PI / 180);
                float f1 = MathHelper.func_76126_a((float)f);
                float f2 = MathHelper.func_76134_b((float)f);
                double d0 = this.func_226277_ct_() + (double)(f1 * (float)this.ticksCatchableDelay * 0.1f);
                double d1 = (float)MathHelper.func_76128_c((double)this.func_226278_cu_()) + 1.0f;
                double d2 = this.func_226281_cx_() + (double)(f2 * (float)this.ticksCatchableDelay * 0.1f);
                BlockState blockstate = serverworld.func_180495_p(new BlockPos(d0, d1 - 1.0, d2));
                if (serverworld.func_180495_p(new BlockPos((int)d0, (int)d1 - 1, (int)d2)).func_185904_a() == Material.field_151586_h) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        serverworld.func_195598_a((IParticleData)ParticleTypes.field_197612_e, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    serverworld.func_195598_a((IParticleData)ParticleTypes.field_197630_w, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    serverworld.func_195598_a((IParticleData)ParticleTypes.field_197630_w, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                double d3 = this.func_226278_cu_() + 0.5;
                serverworld.func_195598_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_(), d3, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), (double)this.func_213311_cf(), 0.0, (double)this.func_213311_cf(), (double)0.2f);
                serverworld.func_195598_a((IParticleData)ParticleTypes.field_197630_w, this.func_226277_ct_(), d3, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), (double)this.func_213311_cf(), 0.0, (double)this.func_213311_cf(), (double)0.2f);
                this.ticksCatchable = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)40);
                this.func_184212_Q().func_187227_b(field_234599_f_, (Object)true);
            }
        } else if (this.ticksCaughtDelay > 0) {
            this.ticksCaughtDelay -= i;
            float f5 = 0.15f;
            if (this.ticksCaughtDelay < 20) {
                f5 = (float)((double)f5 + (double)(20 - this.ticksCaughtDelay) * 0.05);
            } else if (this.ticksCaughtDelay < 40) {
                f5 = (float)((double)f5 + (double)(40 - this.ticksCaughtDelay) * 0.02);
            } else if (this.ticksCaughtDelay < 60) {
                f5 = (float)((double)f5 + (double)(60 - this.ticksCaughtDelay) * 0.01);
            }
            if (this.field_70146_Z.nextFloat() < f5) {
                float f6 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)25.0f, (float)60.0f);
                double d4 = this.func_226277_ct_() + (double)(MathHelper.func_76126_a((float)f6) * f7 * 0.1f);
                double d5 = (float)MathHelper.func_76128_c((double)this.func_226278_cu_()) + 1.0f;
                double d6 = this.func_226281_cx_() + (double)(MathHelper.func_76134_b((float)f6) * f7 * 0.1f);
                BlockState blockstate1 = serverworld.func_180495_p(new BlockPos(d4, d5 - 1.0, d6));
                if (serverworld.func_180495_p(new BlockPos(d4, d5 - 1.0, d6)).func_185904_a() == Material.field_151586_h) {
                    serverworld.func_195598_a((IParticleData)ParticleTypes.field_218422_X, d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.ticksCaughtDelay <= 0) {
                this.fishApproachAngle = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f);
                this.ticksCatchableDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)80);
            }
        } else {
            this.ticksCaughtDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)100, (int)600);
            this.ticksCaughtDelay -= this.lureSpeed * 20 * 5;
        }
    }

    public void func_213281_b(CompoundNBT compound) {
    }

    public void func_70037_a(CompoundNBT compound) {
    }

    private int handleHookRetractionOriginal(ItemStack stack) {
        PlayerEntity playerentity = this.getFishingPlayer();
        if (!this.field_70170_p.field_72995_K && playerentity != null) {
            int i = 0;
            if (this.caughtEntity != null) {
                this.bringInHookedEntity();
                this.field_70170_p.func_72960_a((Entity)this, (byte)31);
                i = this.caughtEntity instanceof ItemEntity ? 3 : 5;
            } else if (this.ticksCatchable > 0) {
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)this.func_213303_ch()).func_216015_a(LootParameters.field_216289_i, (Object)stack).func_216015_a(LootParameters.field_216281_a, (Object)this).func_216023_a(this.field_70146_Z).func_186469_a((float)this.luck + playerentity.func_184817_da());
                lootcontext$builder.func_216015_a(LootParameters.field_216284_d, (Object)this.func_234616_v_()).func_216015_a(LootParameters.field_216281_a, (Object)this);
                LootTable loottable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_186387_al);
                List list = loottable.func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216262_c));
                for (ItemStack itemstack : list) {
                    ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), itemstack);
                    double d0 = playerentity.func_226277_ct_() - this.func_226277_ct_();
                    double d1 = playerentity.func_226278_cu_() - this.func_226278_cu_();
                    double d2 = playerentity.func_226281_cx_() - this.func_226281_cx_();
                    double d3 = 0.1;
                    itementity.func_213293_j(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    this.field_70170_p.func_217376_c((Entity)itementity);
                    playerentity.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(playerentity.field_70170_p, playerentity.func_226277_ct_(), playerentity.func_226278_cu_() + 0.5, playerentity.func_226281_cx_() + 0.5, this.field_70146_Z.nextInt(6) + 1));
                    if (!itemstack.func_77973_b().func_206844_a((ITag)ItemTags.field_206964_G)) continue;
                    playerentity.func_195067_a(Stats.field_188071_E, 1);
                }
                i = 1;
            }
            if (this.field_70122_E) {
                i = 2;
            }
            this.func_70106_y();
            return i;
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 31 && this.field_70170_p.field_72995_K && this.caughtEntity instanceof PlayerEntity && ((PlayerEntity)this.caughtEntity).func_175144_cb()) {
            this.bringInHookedEntity();
        }
        super.func_70103_a(id);
    }

    private void bringInHookedEntityOriginal() {
        Entity entity = this.func_234616_v_();
        if (entity != null) {
            Vector3d vector3d = new Vector3d(entity.func_226277_ct_() - this.func_226277_ct_(), entity.func_226278_cu_() - this.func_226278_cu_(), entity.func_226281_cx_() - this.func_226281_cx_()).func_186678_a(0.1);
            this.caughtEntity.func_213317_d(this.caughtEntity.func_213322_ci().func_178787_e(vector3d));
        }
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        PlayerEntity playerentity = this.getFishingPlayer();
        if (playerentity != null) {
            playerentity.field_71104_cf = null;
        }
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        PlayerEntity fishingPlayer = this.getFishingPlayer();
        buffer.writeInt(fishingPlayer != null ? fishingPlayer.func_145782_y() : 0);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        int entityId = additionalData.readInt();
        if (entityId != 0) {
            this.func_212361_a(this.field_70170_p.func_73045_a(entityId));
        }
    }

    private Optional<PlayerEntity> getFishingPlayerOptional() {
        return Optional.ofNullable(this.getFishingPlayer());
    }

    private void speedUp() {
        if (this.func_213322_ci().func_82617_b() >= 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(2.0, 2.0, 2.0));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 16384.0;
    }

    public void func_70071_h_() {
        this.tickOriginal();
        this.pullItemEntitiesTowardsHook();
    }

    private boolean shouldStopFishing(PlayerEntity fishingPlayer) {
        boolean flag1;
        ItemStack itemstack = fishingPlayer.func_184614_ca();
        ItemStack itemstack1 = fishingPlayer.func_184592_cb();
        boolean flag = itemstack.func_77973_b() == ModItems.ROD_OF_LYSSA;
        boolean bl = flag1 = itemstack1.func_77973_b() == ModItems.ROD_OF_LYSSA;
        if (fishingPlayer.func_70089_S() && (flag || flag1) && this.func_70068_e((Entity)fishingPlayer) <= 10240.0) {
            return false;
        }
        this.func_70106_y();
        return true;
    }

    private void pullItemEntitiesTowardsHook() {
        if (this.func_70089_S() && this.caughtEntity == null) {
            float f = 0.0f;
            BlockPos blockpos = this.func_233580_cy_();
            FluidState fluidState = this.field_70170_p.func_204610_c(blockpos);
            if (fluidState.func_206884_a((ITag)FluidTags.field_206959_a)) {
                f = fluidState.func_215679_a((IBlockReader)this.field_70170_p, blockpos);
            }
            if (f <= 0.0f) {
                List list = this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(3.0));
                for (Entity e : list) {
                    Vector3d pullVector = new Vector3d(this.func_226277_ct_() - e.func_226277_ct_(), this.func_226278_cu_() - e.func_226278_cu_(), this.func_226281_cx_() - e.func_226281_cx_()).func_72432_b();
                    e.func_213317_d(pullVector.func_216372_d(0.4, 0.4, 0.4));
                }
            }
        }
    }

    private void bringInHookedEntity() {
        this.bringInHookedEntityOriginal();
        if (this.caughtEntity instanceof ItemEntity) {
            this.caughtEntity.func_213317_d(this.caughtEntity.func_213322_ci().func_216372_d(4.0, 4.0, 4.0));
        } else if (this.caughtEntity instanceof LivingEntity) {
            this.caughtEntity.func_213317_d(this.caughtEntity.func_213322_ci().func_216372_d(1.0, 1.5, 1.0));
        }
    }

    public void handleHookRetraction(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.caughtEntity != null && this.getFishingPlayerOptional().map(Entity::func_213453_ef).orElse(false).booleanValue() && this.canStealFromEntity()) {
                this.stealFromLivingEntity();
                this.func_70106_y();
            } else {
                this.handleHookRetractionOriginal(stack);
            }
            this.pullItemEntitiesWithHook();
        }
    }

    private boolean canStealFromEntity() {
        return this.caughtEntity instanceof LivingEntity && ((Boolean)Settings.COMMON.items.rodOfLyssa.stealFromPlayers.get() != false || !(this.caughtEntity instanceof PlayerEntity));
    }

    private void pullItemEntitiesWithHook() {
        List pullingItemsList = this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_72314_b(1.0, 1.0, 1.0));
        this.getFishingPlayerOptional().ifPresent(p -> {
            for (ItemEntity e : pullingItemsList) {
                double d1 = p.func_226277_ct_() - this.func_226277_ct_();
                double d3 = p.func_226278_cu_() - this.func_226278_cu_();
                double d5 = p.func_226281_cx_() - this.func_226281_cx_();
                double d7 = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3 + d5 * d5));
                double d9 = 0.1;
                e.func_213293_j(d1 * d9, d3 * d9 + (double)MathHelper.func_76133_a((double)d7) * 0.08, d5 * d9);
            }
        });
    }

    private void stealFromLivingEntity() {
        Optional<PlayerEntity> p;
        LivingEntity livingEntity = (LivingEntity)this.caughtEntity;
        EquipmentSlotType slotBeingStolenFrom = EquipmentSlotType.values()[this.field_70170_p.field_73012_v.nextInt(EquipmentSlotType.values().length)];
        ItemStack stolenStack = livingEntity.func_184582_a(slotBeingStolenFrom);
        if (stolenStack.func_190926_b() && Boolean.TRUE.equals(Settings.COMMON.items.rodOfLyssa.stealFromVacantSlots.get())) {
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                stolenStack = livingEntity.func_184582_a(slot);
                if (stolenStack.func_190926_b() || !this.canDropFromSlot(livingEntity, slot)) continue;
                slotBeingStolenFrom = slot;
                break;
            }
        }
        if (!(p = this.getFishingPlayerOptional()).isPresent()) {
            return;
        }
        PlayerEntity fishingPlayer = p.get();
        float failProbabilityFactor = Boolean.TRUE.equals(Settings.COMMON.items.rodOfLyssa.useLeveledFailureRate.get()) ? 1.0f / ((float)Math.sqrt(Math.max(1, Math.min(fishingPlayer.field_71068_ca, (Integer)Settings.COMMON.items.rodOfLyssa.levelCapForLeveledFormula.get()))) * 2.0f) : (float)((Integer)Settings.COMMON.items.rodOfLyssa.flatStealFailurePercentRate.get()).intValue() / 100.0f;
        if ((this.field_70146_Z.nextFloat() <= failProbabilityFactor || stolenStack.func_190926_b() && ((Boolean)Settings.COMMON.items.rodOfLyssa.failStealFromVacantSlots.get()).booleanValue()) && Boolean.TRUE.equals(Settings.COMMON.items.rodOfLyssa.angerOnStealFailure.get())) {
            livingEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)fishingPlayer), 0.0f);
        }
        if (!stolenStack.func_190926_b()) {
            int randomItemDamage = this.field_70170_p.field_73012_v.nextInt(3);
            stolenStack.func_222118_a(randomItemDamage, livingEntity, e -> {});
            ItemEntity entityitem = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stolenStack);
            entityitem.func_174867_a(5);
            double d1 = fishingPlayer.func_226277_ct_() - this.func_226277_ct_();
            double d3 = fishingPlayer.func_226278_cu_() - this.func_226278_cu_();
            double d5 = fishingPlayer.func_226281_cx_() - this.func_226281_cx_();
            double d7 = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3 + d5 * d5));
            double d9 = 0.1;
            entityitem.func_213293_j(d1 * d9, d3 * d9 + (double)MathHelper.func_76133_a((double)d7) * 0.08, d5 * d9);
            this.field_70170_p.func_217376_c((Entity)entityitem);
            livingEntity.func_184201_a(slotBeingStolenFrom, ItemStack.field_190927_a);
        }
    }

    private boolean canDropFromSlot(LivingEntity entity, EquipmentSlotType slot) {
        if (!(entity instanceof MobEntity)) {
            return true;
        }
        MobEntity livingEntity = (MobEntity)entity;
        try {
            if (slot.func_188453_a() == EquipmentSlotType.Group.HAND) {
                return ((float[])HANDS_CHANCES.get(livingEntity))[slot.func_188454_b()] > -1.0f;
            }
            return ((float[])ARMOR_CHANCES.get(livingEntity))[slot.func_188454_b()] > -1.0f;
        }
        catch (IllegalAccessException e) {
            LogHelper.error(e);
            return false;
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    static enum WaterType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }

    private static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

