/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xreliquary.init.ModEntities;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class EnderStaffProjectileEntity
extends ThrowableEntity
implements IRendersAsItem,
IEntityAdditionalSpawnData {
    private boolean normalGravity = false;

    public EnderStaffProjectileEntity(EntityType<EnderStaffProjectileEntity> entityType, World world) {
        super(entityType, world);
    }

    public EnderStaffProjectileEntity(World world, PlayerEntity entityPlayer, boolean shortRange) {
        super(ModEntities.ENDER_STAFF_PROJECTILE, (LivingEntity)entityPlayer, world);
        this.normalGravity = shortRange;
    }

    protected float func_70185_h() {
        if (this.normalGravity) {
            return super.func_70185_h();
        }
        return 0.005f;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 4 == this.field_70170_p.field_73012_v.nextInt(5)) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 1.0);
        }
        if (this.func_70090_H()) {
            this.onThrowableCollision((RayTraceResult)new BlockRayTraceResult(this.func_213303_ch(), Direction.UP, this.func_233580_cy_(), true));
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        this.onThrowableCollision(result);
    }

    private void onThrowableCollision(RayTraceResult result) {
        Entity thrower = this.func_234616_v_();
        if (!(thrower instanceof PlayerEntity) || (int)this.func_226278_cu_() <= 0) {
            this.func_70106_y();
            return;
        }
        for (int i = 0; i < 32; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226277_ct_(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * 2.0, this.func_226281_cx_(), this.field_70146_Z.nextGaussian(), 0.0, this.field_70146_Z.nextGaussian());
        }
        if (!this.field_70170_p.field_72995_K) {
            thrower.field_70143_R = 0.0f;
            int x = (int)Math.round(this.func_226277_ct_());
            int y = (int)Math.round(this.func_226278_cu_());
            int z = (int)Math.round(this.func_226281_cx_());
            if (result.func_216346_c() != RayTraceResult.Type.MISS) {
                BlockPos pos;
                if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    Entity entityHit = ((EntityRayTraceResult)result).func_216348_a();
                    entityHit.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)thrower), 0.0f);
                    pos = entityHit.func_233580_cy_();
                } else {
                    BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
                    pos = blockResult.func_216350_a().func_177972_a(blockResult.func_216354_b());
                }
                y = pos.func_177956_o();
                x = pos.func_177958_n();
                z = pos.func_177952_p();
            }
            thrower.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            thrower.func_70634_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f));
        }
        this.func_70106_y();
    }

    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)Items.field_151079_bi);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeBoolean(this.normalGravity);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.normalGravity = additionalData.readBoolean();
    }
}

