/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting;

import java.util.Map;
import java.util.Optional;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import xreliquary.init.ModItems;
import xreliquary.items.MobCharmFragmentItem;

public class FragmentRecipeHelper {
    public static final Item FALL_BACK_SPAWN_EGG = Items.field_196163_cv;

    private FragmentRecipeHelper() {
    }

    public static boolean hasOnlyOneFragmentType(CraftingInventory inv) {
        String regName = null;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack slotStack = inv.func_70301_a(slot);
            if (slotStack.func_77973_b() != ModItems.MOB_CHARM_FRAGMENT) continue;
            if (regName == null) {
                regName = MobCharmFragmentItem.getEntityRegistryName(slotStack);
                continue;
            }
            if (regName.equals(MobCharmFragmentItem.getEntityRegistryName(slotStack))) continue;
            return false;
        }
        return true;
    }

    public static Optional<String> getRegistryName(CraftingInventory inv) {
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack slotStack = inv.func_70301_a(slot);
            if (slotStack.func_77973_b() != ModItems.MOB_CHARM_FRAGMENT) continue;
            return Optional.of(MobCharmFragmentItem.getEntityRegistryName(slotStack));
        }
        return Optional.empty();
    }

    public static ItemStack getSpawnEggStack(String regName) {
        Map spawnEggs = (Map)ObfuscationReflectionHelper.getPrivateValue(SpawnEggItem.class, null, (String)"field_195987_b");
        if (spawnEggs == null) {
            return new ItemStack((IItemProvider)FALL_BACK_SPAWN_EGG);
        }
        SpawnEggItem spawnEggItem = (SpawnEggItem)spawnEggs.get(ForgeRegistries.ENTITIES.getValue(new ResourceLocation(regName)));
        return new ItemStack((IItemProvider)(spawnEggItem == null ? FALL_BACK_SPAWN_EGG : spawnEggItem));
    }
}

