/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.compat.jei.descriptions;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import xreliquary.compat.jei.descriptions.DescriptionEntry;

public class JEIDescriptionRegistry {
    private static final Set<DescriptionEntry> descriptionEntries = new HashSet<DescriptionEntry>();

    private JEIDescriptionRegistry() {
    }

    public static Set<DescriptionEntry> getEntries() {
        return descriptionEntries;
    }

    public static void register(Supplier<List<ItemStack>> itemStacks, String ... names) {
        descriptionEntries.add(new DescriptionEntry(itemStacks, JEIDescriptionRegistry.getTranslationKeys(names)));
    }

    private static String[] getTranslationKeys(String ... names) {
        String[] keys = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            keys[i] = String.format("jei.%s.description.%s", "xreliquary", names[i].replace('/', '.'));
        }
        return keys;
    }

    public static void register(ItemStack stack, String name) {
        JEIDescriptionRegistry.register(() -> Collections.singletonList(stack), name);
    }

    public static void register(Item item, String name) {
        if (item.func_77640_w() != null) {
            JEIDescriptionRegistry.register(new ItemStack((IItemProvider)item), name);
        }
    }
}

