/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks.tile;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItem;
import xreliquary.api.IPedestalRedstoneItem;
import xreliquary.api.IPedestalRedstoneItemWrapper;
import xreliquary.blocks.PedestalBlock;
import xreliquary.blocks.tile.PassivePedestalTileEntity;
import xreliquary.blocks.tile.PedestalFluidHandler;
import xreliquary.items.util.FilteredItemStackHandler;
import xreliquary.pedestal.PedestalRegistry;
import xreliquary.util.InjectionHelper;
import xreliquary.util.InventoryHelper;
import xreliquary.util.StackHelper;
import xreliquary.util.WorldHelper;
import xreliquary.util.XRFakePlayerFactory;

public class PedestalTileEntity
extends PassivePedestalTileEntity
implements IPedestal,
ITickableTileEntity {
    @ObjectHolder(value="xreliquary:pedestal")
    public static final TileEntityType<PedestalTileEntity> TYPE = (TileEntityType)InjectionHelper.nullValue();
    private boolean tickable = false;
    private int actionCooldown = 0;
    @Nullable
    private IPedestalActionItem actionItem = null;
    @Nullable
    private IPedestalRedstoneItem redstoneItem = null;
    @Nullable
    private IItemHandler itemHandler = null;
    private ItemStack fluidContainer = ItemStack.field_190927_a;
    private boolean switchedOn = false;
    private final List<Long> onSwitches = new ArrayList<Long>();
    private boolean enabledInitialized = false;
    private boolean powered = false;
    private PedestalFluidHandler pedestalFluidHandler = null;
    private Object itemData = null;

    public PedestalTileEntity() {
        super(TYPE);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.switchedOn = tag.func_74767_n("SwitchedOn");
        this.powered = tag.func_74767_n("Powered");
        ListNBT onLocations = tag.func_150295_c("OnSwitches", 4);
        this.onSwitches.clear();
        for (INBT onLocation : onLocations) {
            this.onSwitches.add(((LongNBT)onLocation).func_150291_c());
        }
        this.updateSpecialItems();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("SwitchedOn", this.switchedOn);
        compound.func_74757_a("Powered", this.powered);
        ListNBT onLocations = new ListNBT();
        for (Long onSwitch : this.onSwitches) {
            onLocations.add((Object)LongNBT.func_229698_a_((long)onSwitch));
        }
        compound.func_218657_a("OnSwitches", (INBT)onLocations);
        return compound;
    }

    public void func_70296_d() {
        if (this.itemHandler instanceof FilteredItemStackHandler) {
            FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)this.itemHandler;
            filteredHandler.markDirty();
        }
        super.func_70296_d();
    }

    public void onChunkUnloaded() {
        if (!this.field_145850_b.field_72995_K) {
            PedestalRegistry.unregisterPosition(this.field_145850_b.func_234923_W_().getRegistryName(), this.field_174879_c);
        }
        super.onChunkUnloaded();
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            PedestalRegistry.registerPosition(this.field_145850_b.func_234923_W_().getRegistryName(), this.field_174879_c);
        }
        super.onLoad();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.pedestalFluidHandler == null) {
                this.pedestalFluidHandler = new PedestalFluidHandler(this);
            }
            return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.pedestalFluidHandler));
        }
        return super.getCapability(cap, side);
    }

    private void executeOnActionItem(Consumer<IPedestalActionItem> execute) {
        if (this.actionItem == null) {
            return;
        }
        execute.accept(this.actionItem);
    }

    private void executeOnRedstoneItem(Consumer<IPedestalRedstoneItem> execute) {
        if (this.redstoneItem == null) {
            return;
        }
        execute.accept(this.redstoneItem);
    }

    private void updateSpecialItems() {
        this.resetSpecialItems();
        if (this.item.func_190926_b()) {
            return;
        }
        this.item.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(ih -> {
            this.itemHandler = ih;
        });
        if (this.item.func_77973_b() instanceof IPedestalActionItem) {
            this.tickable = true;
            this.actionItem = (IPedestalActionItem)this.item.func_77973_b();
        } else if (this.item.func_77973_b() instanceof IPedestalRedstoneItem) {
            this.redstoneItem = (IPedestalRedstoneItem)this.item.func_77973_b();
        } else {
            PedestalRegistry.getItemWrapper(this.item).ifPresent(wrapper -> {
                if (wrapper instanceof IPedestalActionItem) {
                    this.tickable = true;
                    this.actionItem = (IPedestalActionItem)((Object)wrapper);
                }
                if (wrapper instanceof IPedestalRedstoneItemWrapper) {
                    this.redstoneItem = (IPedestalRedstoneItem)((Object)wrapper);
                }
            });
        }
        this.item.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).ifPresent(fh -> {
            this.fluidContainer = this.item;
        });
        this.item.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).ifPresent(fh -> {
            this.fluidContainer = this.item;
        });
        this.actionCooldown = 0;
    }

    private void resetSpecialItems() {
        this.tickable = false;
        this.fluidContainer = ItemStack.field_190927_a;
        this.actionItem = null;
        this.redstoneItem = null;
        this.itemHandler = null;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.enabledInitialized) {
            this.enabledInitialized = true;
            this.neighborUpdate();
        }
        if (this.tickable && this.isEnabled()) {
            if (this.actionCooldown > 0) {
                --this.actionCooldown;
            } else {
                this.executeOnActionItem(ai -> ai.update(this.item, this));
            }
        }
    }

    public void neighborUpdate() {
        if (this.powered != this.field_145850_b.func_175640_z(this.field_174879_c)) {
            this.powered = this.field_145850_b.func_175640_z(this.field_174879_c);
            if (this.powered) {
                this.switchOn(BlockPos.field_177992_a);
            } else {
                this.switchOff(BlockPos.field_177992_a);
            }
        }
        this.updateRedstone();
    }

    public void updateRedstone() {
        this.executeOnRedstoneItem(ri -> ri.updateRedstone(this.item, this));
    }

    @Override
    public World getTheWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return this.func_174877_v();
    }

    @Override
    public int addToConnectedInventory(ItemStack stack) {
        int finalNumberAdded;
        Direction side;
        LazyOptional<IItemHandler> inventory;
        int numberAdded = 0;
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        for (int i = 0; i < n && (numberAdded += (inventory = InventoryHelper.getInventoryAtPos(this.field_145850_b, this.field_174879_c.func_177971_a((side = directionArray[i]).func_176730_m()), side.func_176734_d())).map(arg_0 -> PedestalTileEntity.lambda$addToConnectedInventory$7(stack, finalNumberAdded = numberAdded, arg_0)).orElse(0).intValue()) < stack.func_190916_E(); ++i) {
        }
        return numberAdded;
    }

    @Override
    public int fillConnectedTank(FluidStack fluidStack, IFluidHandler.FluidAction action) {
        List<IFluidHandler> adjacentTanks = this.getAdjacentTanks();
        int fluidFilled = 0;
        FluidStack copy = fluidStack.copy();
        for (IFluidHandler tank : adjacentTanks) {
            if (tank.fill(copy, IFluidHandler.FluidAction.SIMULATE) != copy.getAmount()) continue;
            if ((fluidFilled += tank.fill(copy, action)) >= fluidStack.getAmount()) break;
            copy.setAmount(fluidStack.getAmount() - fluidFilled);
        }
        return fluidFilled;
    }

    @Override
    public int fillConnectedTank(FluidStack fluidStack) {
        return this.fillConnectedTank(fluidStack, IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public void setActionCoolDown(int coolDownTicks) {
        this.actionCooldown = coolDownTicks;
    }

    @Override
    @Nullable
    public FakePlayer getFakePlayer() {
        if (this.field_145850_b.field_72995_K) {
            return null;
        }
        ServerWorld world = (ServerWorld)this.field_145850_b;
        return XRFakePlayerFactory.get(world);
    }

    @Override
    public void destroyItem() {
        this.setItem(ItemStack.field_190927_a);
    }

    @Override
    public void setItem(ItemStack stack) {
        this.removeSpecialItems();
        this.item = stack;
        this.updateItemsAndBlock();
    }

    @Override
    public List<BlockPos> getPedestalsInRange(int range) {
        return PedestalRegistry.getPositionsInRange(this.field_145850_b.func_234923_W_().getRegistryName(), this.field_174879_c, range);
    }

    @Override
    public void switchOn(BlockPos switchedOnFrom) {
        if (switchedOnFrom != BlockPos.field_177992_a && !this.onSwitches.contains(switchedOnFrom.func_218275_a())) {
            this.onSwitches.add(switchedOnFrom.func_218275_a());
        }
        this.setEnabled(true);
        BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
    }

    @Override
    public void switchOff(BlockPos switchedOffFrom) {
        if (switchedOffFrom != BlockPos.field_177992_a) {
            this.onSwitches.remove(switchedOffFrom.func_218275_a());
        }
        if (!this.switchedOn && !this.powered && this.onSwitches.isEmpty()) {
            this.setEnabled(false);
        }
        BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
    }

    @Override
    public Optional<Object> getItemData() {
        return Optional.ofNullable(this.itemData);
    }

    @Override
    public void setItemData(@Nullable Object data) {
        this.itemData = data;
    }

    @Override
    public boolean switchedOn() {
        return this.switchedOn;
    }

    private void setEnabled(boolean switchedOn) {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof PedestalBlock) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)PedestalBlock.ENABLED, (Comparable)Boolean.valueOf(switchedOn)));
            if (!switchedOn) {
                this.executeOnActionItem(ai -> ai.stop(this.item, this));
            }
        }
        this.func_70296_d();
    }

    private List<IFluidHandler> getAdjacentTanks() {
        ArrayList<IFluidHandler> adjacentTanks = new ArrayList<IFluidHandler>();
        for (Direction side : Direction.values()) {
            BlockPos tankPos = this.func_174877_v().func_177971_a(side.func_176730_m());
            Direction tankDirection = side.func_176734_d();
            this.addIfTank(adjacentTanks, tankPos, tankDirection);
        }
        return adjacentTanks;
    }

    private void addIfTank(List<IFluidHandler> adjacentTanks, BlockPos tankPos, Direction tankDirection) {
        WorldHelper.getTile((IBlockReader)this.field_145850_b, tankPos).ifPresent(te -> te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, tankDirection).ifPresent(adjacentTanks::add));
    }

    public void removeSpecialItems() {
        this.executeOnRedstoneItem(ri -> ri.onRemoved(this.item, this));
        this.executeOnActionItem(ai -> ai.onRemoved(this.item, this));
    }

    @Override
    public void removeAndSpawnItem() {
        this.removeSpecialItems();
        this.resetSpecialItems();
        super.removeAndSpawnItem();
    }

    @Override
    public int func_70302_i_() {
        return this.applyToItemHandler(IItemHandler::getSlots).orElse(0) + 1;
    }

    private <T> Optional<T> applyToItemHandler(Function<IItemHandler, T> function) {
        return this.itemHandler != null ? Optional.of(function.apply(this.itemHandler)) : Optional.empty();
    }

    private void runOnItemHandler(Consumer<IItemHandler> consumer) {
        if (this.itemHandler != null) {
            consumer.accept(this.itemHandler);
        }
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        if (slot == 0) {
            return this.item;
        }
        return this.applyToItemHandler(ih -> ih.getStackInSlot(this.getInternalItemHandlerSlot(slot))).orElse(ItemStack.field_190927_a);
    }

    private int getInternalItemHandlerSlot(int slot) {
        return slot - 1;
    }

    @Override
    public ItemStack func_70298_a(int slot, int count) {
        if (slot == 0) {
            return this.decrStack(count);
        }
        return this.applyToItemHandler(ih -> ih.extractItem(this.getInternalItemHandlerSlot(slot), count, false)).orElse(ItemStack.field_190927_a);
    }

    private ItemStack decrStack(int count) {
        if (!this.item.func_190926_b()) {
            ItemStack stack;
            if (this.item.func_190916_E() > count) {
                stack = this.item.func_77979_a(count);
            } else {
                stack = this.item;
                this.removeSpecialItems();
                this.item = ItemStack.field_190927_a;
                this.updateItemsAndBlock();
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private void updateItemsAndBlock() {
        this.updateSpecialItems();
        this.updateRedstone();
        BlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), blockState, blockState, 3);
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        if (slot == 0) {
            ItemStack stack = this.item;
            this.removeSpecialItems();
            this.item = ItemStack.field_190927_a;
            this.updateItemsAndBlock();
            return stack;
        }
        return this.applyToItemHandler(ih -> {
            int s = this.getInternalItemHandlerSlot(slot);
            ItemStack stack = ih.getStackInSlot(s);
            return ih.extractItem(s, stack.func_190916_E(), false);
        }).orElse(ItemStack.field_190927_a);
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        if (slot == 0) {
            this.setItem(stack);
            return;
        }
        this.runOnItemHandler(ih -> this.setItemHandlerSlotContents(slot, stack, (IItemHandler)ih));
    }

    private void setItemHandlerSlotContents(int slot, ItemStack stack, IItemHandler ih) {
        int adjustedSlot = this.getInternalItemHandlerSlot(slot);
        ItemStack stackInSlot = ih.getStackInSlot(adjustedSlot);
        if (!(stackInSlot.func_190926_b() || stack.func_190926_b() || StackHelper.isItemAndNbtEqual(stack, stackInSlot))) {
            return;
        }
        if (!stackInSlot.func_190926_b() && (stack.func_190926_b() || stack.func_190916_E() < stackInSlot.func_190916_E())) {
            int amount = stackInSlot.func_190916_E() - (stack.func_190926_b() ? 0 : stack.func_190916_E());
            ih.extractItem(adjustedSlot, amount, false);
        } else if (!stack.func_190926_b() && (stackInSlot.func_190926_b() || stack.func_190916_E() > stackInSlot.func_190916_E())) {
            stack.func_190918_g(stackInSlot.func_190926_b() ? 0 : stackInSlot.func_190916_E());
            ih.insertItem(adjustedSlot, stack, false);
        }
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        if (super.func_94041_b(index, stack)) {
            return true;
        }
        return this.applyToItemHandler(ih -> {
            ItemStack returnedStack = ih.insertItem(this.getInternalItemHandlerSlot(index), stack, true);
            return returnedStack.func_190926_b() || returnedStack.func_190916_E() != stack.func_190916_E();
        }).orElse(false);
    }

    public void toggleSwitch() {
        boolean bl = this.switchedOn = !this.switchedOn;
        if (this.switchedOn) {
            this.switchOn(BlockPos.field_177992_a);
        } else {
            this.switchOff(BlockPos.field_177992_a);
        }
        this.updateRedstone();
    }

    ItemStack getFluidContainer() {
        return this.fluidContainer;
    }

    public boolean isEnabled() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)PedestalBlock.ENABLED);
    }

    private static /* synthetic */ Integer lambda$addToConnectedInventory$7(ItemStack stack, int finalNumberAdded, IItemHandler handler) {
        return InventoryHelper.tryToAddToInventory(stack, handler, stack.func_190916_E() - finalNumberAdded);
    }
}

