/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xreliquary.blocks.PassivePedestalBlock;
import xreliquary.blocks.tile.PedestalTileEntity;
import xreliquary.pedestal.PedestalRegistry;
import xreliquary.util.WorldHelper;

public class PedestalBlock
extends PassivePedestalBlock {
    public static final BooleanProperty ENABLED = BooleanProperty.func_177716_a((String)"enabled");
    public static final Set<Block> ALL_PEDESTAL_BLOCKS = new HashSet<Block>();

    public PedestalBlock(DyeColor dyeColor) {
        super("pedestals/" + dyeColor.func_176762_d() + "_" + "pedestal");
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
        ALL_PEDESTAL_BLOCKS.add(this);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ENABLED});
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        List<BlockPos> pedestalPositions = PedestalRegistry.getPositionsInRange(world.func_234923_W_().getRegistryName(), pos, 160);
        for (BlockPos pedestalPosition : pedestalPositions) {
            WorldHelper.getTile((IBlockReader)world, pedestalPosition, PedestalTileEntity.class).ifPresent(PedestalTileEntity::updateRedstone);
        }
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PedestalTileEntity();
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        ((PedestalTileEntity)worldIn.func_175625_s(pos)).neighborUpdate();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (Boolean.TRUE.equals(state.func_177229_b((Property)ENABLED)) && rand.nextInt(3) == 1) {
            Direction enumfacing = (Direction)state.func_177229_b((Property)FACING);
            double xMiddle = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 0.25 + rand.nextDouble() * 4.0 / 16.0;
            double zMiddle = (double)pos.func_177952_p() + 0.5;
            double sideOffset = 0.27;
            double randomOffset = rand.nextDouble() * 0.3 - 0.15;
            switch (enumfacing) {
                case WEST: {
                    world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, xMiddle + sideOffset, y, zMiddle + randomOffset, 0.0, 0.0, 0.0);
                    break;
                }
                case EAST: {
                    world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, xMiddle - sideOffset, y, zMiddle + randomOffset, 0.0, 0.0, 0.0);
                    break;
                }
                case NORTH: {
                    world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, xMiddle + randomOffset, y, zMiddle + sideOffset, 0.0, 0.0, 0.0);
                    break;
                }
                default: {
                    world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, xMiddle + randomOffset, y, zMiddle - sideOffset, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return !heldItem.func_190926_b() || player.func_213453_ef() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
        }
        return WorldHelper.getTile((IBlockReader)world, pos, PedestalTileEntity.class).map(pedestal -> {
            if (heldItem.func_190926_b() && !player.func_213453_ef() && hand == Hand.MAIN_HAND && hit.func_216354_b() == ((Direction)state.func_177229_b((Property)FACING)).func_176734_d() && this.switchClicked(hit.func_216354_b(), hit.func_216347_e().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()))) {
                pedestal.toggleSwitch();
                return ActionResultType.SUCCESS;
            }
            return super.func_225533_a_(state, world, pos, player, hand, hit);
        }).orElse(ActionResultType.FAIL);
    }

    private boolean switchClicked(Direction side, Vector3d hitVec) {
        double xOff = hitVec.func_82615_a();
        double yOff = hitVec.func_82617_b();
        double zOff = hitVec.func_82616_c();
        if (yOff < 0.3 || yOff > 0.65) {
            return false;
        }
        return side.func_176740_k() == Direction.Axis.Z && xOff >= 0.35 && xOff <= 0.65 || side.func_176740_k() == Direction.Axis.X && zOff >= 0.35 && zOff <= 0.65;
    }

    @Override
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() == this) {
            return;
        }
        PedestalRegistry.unregisterPosition(world.func_234923_W_().getRegistryName(), pos);
        WorldHelper.getTile((IBlockReader)world, pos, PedestalTileEntity.class).ifPresent(PedestalTileEntity::removeAndSpawnItem);
        super.func_196243_a(state, world, pos, newState, isMoving);
    }
}

