/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import xreliquary.blocks.BaseBlock;
import xreliquary.blocks.tile.AlkahestryAltarTileEntity;
import xreliquary.items.AlkahestryTomeItem;
import xreliquary.reference.Settings;
import xreliquary.util.NBTHelper;

public class AlkahestryAltarBlock
extends BaseBlock {
    private static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");
    private static final String REDSTONE_TAG = "redstone";

    public AlkahestryAltarBlock() {
        super("alkahestry_altar", AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(1.5f, 5.0f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ACTIVE});
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return Boolean.TRUE.equals(state.func_177229_b((Property)ACTIVE)) ? this.getAltarActiveLightLevel() : 0;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new AlkahestryAltarTileEntity();
    }

    private int getAltarActiveLightLevel() {
        return (Integer)Settings.COMMON.blocks.altar.outputLightLevelWhileActive.get();
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (Boolean.FALSE.equals(state.func_177229_b((Property)ACTIVE)) || world.func_72820_D() >= 12000L || !world.func_175710_j(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p())) || rand.nextInt(3) != 0) {
            return;
        }
        world.func_195594_a((IParticleData)ParticleTypes.field_197625_r, (double)pos.func_177958_n() + 0.5 + rand.nextGaussian() / 8.0, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + 0.5 + rand.nextGaussian() / 8.0, 0.9, 0.9, 0.0);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (Boolean.TRUE.equals(state.func_177229_b((Property)ACTIVE))) {
            return ActionResultType.CONSUME;
        }
        AlkahestryAltarTileEntity altar = (AlkahestryAltarTileEntity)world.func_175625_s(pos);
        if (altar == null || heldItem.func_190926_b()) {
            return ActionResultType.SUCCESS;
        }
        if (heldItem.func_77973_b() == Items.field_151137_ax) {
            int slot = this.getSlotWithRedstoneDust(player);
            if (slot == -1) {
                return ActionResultType.SUCCESS;
            }
            world.func_184133_a(null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.3f, 0.5f + 0.5f * (float)altar.getRedstoneCount() + (float)(world.field_73012_v.nextGaussian() / 8.0));
            for (int particles = world.field_73012_v.nextInt(3); particles < 3 + altar.getRedstoneCount() * 4 + altar.getRedstoneCount(); ++particles) {
                world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, (double)pos.func_177958_n() + 0.5 + world.field_73012_v.nextGaussian() / 5.0, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5 + world.field_73012_v.nextGaussian() / 5.0, 1.0, 0.0, 0.0);
            }
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            player.field_71071_by.func_70298_a(slot, 1);
            altar.addRedstone();
        } else if (heldItem.func_77973_b() instanceof AlkahestryTomeItem && NBTHelper.getInt(REDSTONE_TAG, heldItem) > 0) {
            world.func_184133_a(null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.3f, 0.5f + 0.5f * (float)altar.getRedstoneCount() + (float)(world.field_73012_v.nextGaussian() / 8.0));
            for (int particles = world.field_73012_v.nextInt(3); particles < 3 + altar.getRedstoneCount() * 4 + altar.getRedstoneCount(); ++particles) {
                world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, (double)pos.func_177958_n() + 0.5 + world.field_73012_v.nextGaussian() / 5.0, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5 + world.field_73012_v.nextGaussian() / 5.0, 1.0, 0.0, 0.0);
            }
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            NBTHelper.putInt(REDSTONE_TAG, heldItem, NBTHelper.getInt(REDSTONE_TAG, heldItem) - 1);
            altar.addRedstone();
        }
        return ActionResultType.CONSUME;
    }

    private int getSlotWithRedstoneDust(PlayerEntity player) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
            if (((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_190926_b() || ((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_77973_b() != Items.field_151137_ax) continue;
            return slot;
        }
        return -1;
    }

    public static void updateAltarBlockState(boolean active, World world, BlockPos pos) {
        world.func_175656_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(active)));
        AlkahestryAltarTileEntity te = (AlkahestryAltarTileEntity)world.func_175625_s(pos);
        if (te != null) {
            if (active) {
                te.startCycle();
            } else {
                te.stopCycle();
            }
        }
    }
}

