/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.gui;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.gui.ManualScreen;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class GuiButtonManualLink
extends Button {
    public String localized;
    @Nullable
    public ManualInstance.ManualLink link;
    ManualScreen gui;
    public List<GuiButtonManualLink> otherParts = ImmutableList.of();

    public GuiButtonManualLink(ManualScreen gui, int x, int y, int w, int h, @Nullable ManualInstance.ManualLink link, String localized) {
        super(x, y, w, h, StringTextComponent.field_240750_d_, btn -> {
            if (link != null) {
                link.changePage(gui, true);
            }
        });
        this.gui = gui;
        this.link = link;
        this.localized = localized;
        if (gui.manual.improveReadability()) {
            this.localized = TextFormatting.BOLD + localized;
        }
    }

    public void func_230430_a_(MatrixStack transform, int mx, int my, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        boolean bl = this.field_230692_n_ = mx >= this.field_230690_l_ && my >= this.field_230691_m_ && mx < this.field_230690_l_ + this.field_230688_j_ && my < this.field_230691_m_ + this.field_230689_k_;
        if (this.field_230692_n_) {
            this.drawHovered(transform, mc, true, mx, my);
            for (GuiButtonManualLink btn : this.otherParts) {
                if (btn == this) continue;
                btn.drawHovered(transform, mc, false, mx, my);
            }
        }
    }

    private void drawHovered(MatrixStack transform, Minecraft mc, boolean mouse, int mx, int my) {
        FontRenderer font = this.gui.manual.fontRenderer();
        font.func_238421_b_(transform, this.localized, (float)this.field_230690_l_, (float)this.field_230691_m_, this.gui.manual.getHighlightColour());
        String tooltip = this.link != null ? this.gui.manual.formatLink(this.link) : "Invalid link";
        this.gui.renderToolTip(transform, (List<? extends IReorderingProcessor>)ImmutableList.of((Object)IReorderingProcessor.func_242239_a((String)tooltip, (Style)Style.field_240709_b_)), mx + 8, my + 4, font);
    }
}

