/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.client.models.ModelPowerpack;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public class PowerpackItem
extends IEBaseItem
implements EnergyHelper.IIEEnergyItem {
    public PowerpackItem() {
        super("powerpack");
    }

    @Nullable
    public EquipmentSlotType getEquipmentSlot(ItemStack stack) {
        return EquipmentSlotType.CHEST;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return "immersiveengineering:textures/models/powerpack.png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public BipedModel getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, BipedModel _default) {
        return ModelPowerpack.getModel();
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        String stored = this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack);
        list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.energyStored", new Object[]{stored}));
    }

    public void onArmorTick(ItemStack itemStack, World world, PlayerEntity player) {
        int energy = this.getEnergyStored(itemStack);
        if (energy > 0) {
            int pre = energy;
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                if (!EnergyHelper.isFluxReceiver((ICapabilityProvider)player.func_184582_a(slot)) || player.func_184582_a(slot).func_77973_b() instanceof PowerpackItem) continue;
                energy -= EnergyHelper.insertFlux((ICapabilityProvider)player.func_184582_a(slot), Math.min(energy, 256), false);
            }
            if (pre != energy) {
                EnergyHelper.extractFlux((ICapabilityProvider)itemStack, pre - energy, false);
            }
        }
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return 100000;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundNBT nbt) {
        if (!stack.func_190926_b()) {
            return new ICapabilityProvider(){
                final LazyOptional<EnergyHelper.ItemEnergyStorage> energyStorage;
                {
                    this.energyStorage = CapabilityUtils.constantOptional(new EnergyHelper.ItemEnergyStorage(stack));
                }

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
                    return capability == CapabilityEnergy.ENERGY ? this.energyStorage.cast() : LazyOptional.empty();
                }
            };
        }
        return super.initCapabilities(stack, nbt);
    }
}

