/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.fluids.IEItemFluidHandler;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class JerrycanItem
extends IEBaseItem {
    private final int jerrycanMaxMB = 10000;

    public JerrycanItem() {
        super("jerrycan", new Item.Properties().func_200917_a(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY != null) {
            Optional fsCap = FluidUtil.getFluidContained((ItemStack)stack);
            fsCap.ifPresent(fs -> list.add(IEItemFluidHandler.fluidItemInfoFlavor(fs, 10000)));
        }
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        ItemStack stack = ctx.func_195996_i();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null || !tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent()) {
            FluidStack fs = (FluidStack)FluidUtil.getFluidContained((ItemStack)stack).orElseThrow(RuntimeException::new);
            if (Utils.placeFluidBlock(world, pos.func_177972_a(ctx.func_196000_l()), fs)) {
                ItemNBTHelper.setFluidStack(stack, "Fluid", fs);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return ItemNBTHelper.hasKey(stack, "jerrycanDrain") || FluidUtil.getFluidContained((ItemStack)stack) != null;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "jerrycanDrain")) {
            ItemStack ret = stack.func_77946_l();
            IFluidHandler handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)ret).orElseThrow(RuntimeException::new);
            handler.drain(ItemNBTHelper.getInt(ret, "jerrycanDrain"), IFluidHandler.FluidAction.EXECUTE);
            ItemNBTHelper.remove(ret, "jerrycanDrain");
            return ret;
        }
        if (FluidUtil.getFluidContained((ItemStack)stack).isPresent()) {
            ItemStack ret = stack.func_77946_l();
            IFluidHandler handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)ret).orElseThrow(RuntimeException::new);
            handler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            return ret;
        }
        return stack;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        if (!stack.func_190926_b()) {
            return new FluidHandlerItemStack(stack, 10000);
        }
        return null;
    }
}

