/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.IEProjectileEntity;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class RailgunShotEntity
extends IEProjectileEntity {
    public static final EntityType<RailgunShotEntity> TYPE = EntityType.Builder.func_220322_a(RailgunShotEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).func_206830_a("immersiveengineering:railgun_shot");
    private ItemStack ammo = ItemStack.field_190927_a;
    private static final DataParameter<ItemStack> dataMarker_ammo;
    private RailgunHandler.IRailgunProjectile ammoProperties;

    public RailgunShotEntity(EntityType<RailgunShotEntity> type, World world) {
        super(type, world);
        this.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
    }

    public RailgunShotEntity(World world, double x, double y, double z, double ax, double ay, double az, ItemStack ammo) {
        super(TYPE, world, x, y, z);
        this.ammo = ammo;
        this.setAmmoSynced();
        this.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
    }

    public RailgunShotEntity(World world, LivingEntity living, double ax, double ay, double az, ItemStack ammo) {
        super(TYPE, world, living, ax, ay, az);
        this.ammo = ammo;
        this.setAmmoSynced();
        this.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(dataMarker_ammo, (Object)ItemStack.field_190927_a);
    }

    @Override
    @Nonnull
    protected ItemStack func_184550_j() {
        return this.ammo;
    }

    public void setAmmoSynced() {
        if (!this.getAmmo().func_190926_b()) {
            this.field_70180_af.func_187227_b(dataMarker_ammo, (Object)this.getAmmo());
        }
    }

    public ItemStack getAmmoSynced() {
        return (ItemStack)this.field_70180_af.func_187225_a(dataMarker_ammo);
    }

    public ItemStack getAmmo() {
        return this.ammo;
    }

    public RailgunHandler.IRailgunProjectile getProjectileProperties() {
        if (this.ammoProperties == null && !this.ammo.func_190926_b()) {
            this.ammoProperties = RailgunHandler.getProjectile(this.ammo);
        }
        return this.ammoProperties;
    }

    @Override
    public double getGravity() {
        return 0.005 * (this.getProjectileProperties() != null ? this.getProjectileProperties().getGravity() : 1.0);
    }

    @Override
    public int getMaxTicksInGround() {
        return 500;
    }

    public void func_70030_z() {
        if (this.getAmmo().func_190926_b() && this.field_70170_p.field_72995_K) {
            this.ammo = this.getAmmoSynced();
        }
        super.func_70030_z();
    }

    @Override
    public void func_70227_a(RayTraceResult mop) {
        RailgunHandler.IRailgunProjectile projectileProperties;
        if (!this.field_70170_p.field_72995_K && !this.getAmmo().func_190926_b() && (projectileProperties = this.getProjectileProperties()) != null) {
            double breakRoll;
            Entity shooter = this.func_234616_v_();
            UUID shooterUuid = this.getShooterUUID();
            if (mop instanceof EntityRayTraceResult) {
                Entity hit = ((EntityRayTraceResult)mop).func_216348_a();
                double damage = projectileProperties.getDamage(this.field_70170_p, hit, shooterUuid, (Entity)this);
                hit.func_70097_a(IEDamageSources.causeRailgunDamage(this, shooter), (float)(damage * (Double)IEServerConfig.TOOLS.railgun_damage.get()));
            } else if (mop instanceof BlockRayTraceResult && (breakRoll = this.field_70146_Z.nextDouble()) <= this.getProjectileProperties().getBreakChance(shooterUuid, this.ammo)) {
                this.func_70106_y();
            }
            projectileProperties.onHitTarget(this.field_70170_p, mop, shooterUuid, (Entity)this);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        if (!this.ammo.func_190926_b()) {
            nbt.func_218657_a("ammo", (INBT)this.ammo.func_77955_b(new CompoundNBT()));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.ammo = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("ammo"));
    }

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    static {
        TYPE.setRegistryName("immersiveengineering", "railgun_shot");
        dataMarker_ammo = EntityDataManager.func_187226_a(RailgunShotEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    }
}

