/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.data.resources;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.blocks.EnumMetals;
import blusunrize.immersiveengineering.common.data.DataGenUtils;
import blusunrize.immersiveengineering.common.data.Recipes;
import blusunrize.immersiveengineering.common.data.resources.SecondaryOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraftforge.common.crafting.conditions.ICondition;

public enum RecipeMetals {
    IRON("iron", true, true, new SecondaryOutput(IETags.getDust("nickel"), 0.1f)),
    GOLD("gold", true, true, new SecondaryOutput[0]),
    COPPER("copper", true, true, new SecondaryOutput(IETags.getDust("gold"), 0.1f)),
    ALUMINUM("aluminum", true, true, new SecondaryOutput[0]),
    LEAD("lead", true, true, new SecondaryOutput(IETags.getDust("silver"), 0.1f)),
    SILVER("silver", true, true, new SecondaryOutput(IETags.getDust("lead"), 0.1f)),
    NICKEL("nickel", true, true, new SecondaryOutput(IETags.getDust("platinum"), 0.1f)),
    URANIUM("uranium", true, true, new SecondaryOutput(IETags.getDust("lead"), 0.1f)),
    CONSTANTAN("constantan", true, new AlloyProperties(2, new IngredientWithSize((ITag<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot), new IngredientWithSize((ITag<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.NICKEL).ingot))),
    ELECTRUM("electrum", true, new AlloyProperties(2, new IngredientWithSize((ITag<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.GOLD).ingot), new IngredientWithSize((ITag<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.SILVER).ingot))),
    STEEL("steel", true, false, new SecondaryOutput[0]),
    TIN("tin", false, true, new SecondaryOutput[0]),
    ZINC("zinc", false, true, new SecondaryOutput[0]),
    PLATINUM("platinum", false, true, new SecondaryOutput(IETags.getDust("nickel"), 0.1f)),
    TUNGSTEN("tungsten", false, true, new SecondaryOutput[0]),
    OSMIUM("osmium", false, true, new SecondaryOutput[0]),
    COBALT("cobalt", false, true, new SecondaryOutput[0]),
    ARDITE("ardite", false, true, new SecondaryOutput[0]),
    BRONZE("bronze", false, new AlloyProperties(4, new IngredientWithSize((ITag<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot, 3), new IngredientWithSize((ITag<Item>)DataGenUtils.createItemWrapper(IETags.getIngot("tin")))).addConditions(Recipes.getTagCondition(IETags.getIngot("tin")))),
    BRASS("brass", false, new AlloyProperties(4, new IngredientWithSize((ITag<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot, 3), new IngredientWithSize((ITag<Item>)DataGenUtils.createItemWrapper(IETags.getIngot("zinc")))).addConditions(Recipes.getTagCondition(IETags.getIngot("zinc")))),
    INVAR("invar", false, new AlloyProperties(3, new IngredientWithSize((ITag<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.IRON).ingot, 2), new IngredientWithSize((ITag<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.NICKEL).ingot))),
    MANYULLYN("manyullyn", false, new AlloyProperties(1, new IngredientWithSize((ITag<Item>)DataGenUtils.createItemWrapper(IETags.getIngot("cobalt"))), new IngredientWithSize((ITag<Item>)DataGenUtils.createItemWrapper(IETags.getIngot("ardite")))).addConditions(Recipes.getTagCondition(IETags.getIngot("cobalt"))).addConditions(Recipes.getTagCondition(IETags.getIngot("ardite"))));

    private final String name;
    private final boolean isNative;
    private final ITag.INamedTag<Item> ingot;
    private final ITag.INamedTag<Item> dust;
    private final ITag.INamedTag<Item> ore;
    private final AlloyProperties alloyProperties;
    private final SecondaryOutput[] secondaryOutputs;

    private RecipeMetals(String name, boolean isNative, boolean hasOre, AlloyProperties alloyProperties, SecondaryOutput ... secondaryOutputs) {
        this.name = name;
        this.ingot = DataGenUtils.createItemWrapper(IETags.getIngot(name));
        this.dust = DataGenUtils.createItemWrapper(IETags.getDust(name));
        this.isNative = isNative;
        this.ore = !hasOre ? null : DataGenUtils.createItemWrapper(IETags.getOre(name));
        this.alloyProperties = alloyProperties;
        this.secondaryOutputs = secondaryOutputs;
    }

    private RecipeMetals(String name, boolean isNative, boolean hasOre, SecondaryOutput ... secondaryOutputs) {
        this(name, isNative, hasOre, (AlloyProperties)null, secondaryOutputs);
    }

    private RecipeMetals(String name, boolean isNative, AlloyProperties alloyProperties) {
        this(name, isNative, false, alloyProperties, new SecondaryOutput[0]);
    }

    public String getName() {
        return this.name;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public ITag.INamedTag<Item> getIngot() {
        return this.ingot;
    }

    public ITag.INamedTag<Item> getDust() {
        return this.dust;
    }

    public ITag.INamedTag<Item> getOre() {
        return this.ore;
    }

    public AlloyProperties getAlloyProperties() {
        return this.alloyProperties;
    }

    public SecondaryOutput[] getSecondaryOutputs() {
        return this.secondaryOutputs;
    }

    public static class AlloyProperties {
        private final int outputSize;
        private final IngredientWithSize[] alloyIngredients;
        private final List<ICondition> conditions = new ArrayList<ICondition>();

        AlloyProperties(int outputSize, IngredientWithSize ... alloyIngredients) {
            this.outputSize = outputSize;
            this.alloyIngredients = alloyIngredients;
        }

        public AlloyProperties addConditions(ICondition ... conditions) {
            Collections.addAll(this.conditions, conditions);
            return this;
        }

        public int getOutputSize() {
            return this.outputSize;
        }

        public IngredientWithSize[] getAlloyIngredients() {
            return this.alloyIngredients;
        }

        public List<ICondition> getConditions() {
            return this.conditions;
        }

        public boolean isSimple() {
            return this.alloyIngredients.length == 2;
        }
    }
}

