/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.data.recipebuilder;

import blusunrize.immersiveengineering.common.data.recipebuilder.WrappedFinishedRecipe;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class RevolverAssemblyRecipeBuilder
extends ShapedRecipeBuilder {
    private int[] nbtCopyTargetSlot = null;

    public RevolverAssemblyRecipeBuilder(IItemProvider result, int count) {
        super(result, count);
    }

    public static RevolverAssemblyRecipeBuilder builder(IItemProvider result, int count) {
        return new RevolverAssemblyRecipeBuilder(result, count);
    }

    public static RevolverAssemblyRecipeBuilder builder(IItemProvider result) {
        return new RevolverAssemblyRecipeBuilder(result, 1);
    }

    public RevolverAssemblyRecipeBuilder setNBTCopyTargetRecipe(int ... slot) {
        this.nbtCopyTargetSlot = slot;
        return this;
    }

    public void func_200467_a(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        Consumer<IFinishedRecipe> dummyConsumer = iFinishedRecipe -> {
            RevolverResult result = new RevolverResult((IFinishedRecipe)iFinishedRecipe, this.nbtCopyTargetSlot);
            consumerIn.accept(result);
        };
        super.func_200467_a(dummyConsumer, id);
    }

    public static class RevolverResult
    extends WrappedFinishedRecipe {
        final int[] nbtCopyTargetSlot;

        public RevolverResult(IFinishedRecipe base, int[] nbtCopyTargetSlot) {
            super(base, RecipeSerializers.REVOLVER_ASSEMBLY_SERIALIZER);
            this.nbtCopyTargetSlot = nbtCopyTargetSlot;
        }

        @Override
        public void func_218610_a(@Nonnull JsonObject json) {
            super.func_218610_a(json);
            if (this.nbtCopyTargetSlot != null) {
                if (this.nbtCopyTargetSlot.length > 1) {
                    JsonArray jsonarray = new JsonArray();
                    for (int slot : this.nbtCopyTargetSlot) {
                        jsonarray.add((Number)slot);
                    }
                    json.add("copy_nbt", (JsonElement)jsonarray);
                } else {
                    json.addProperty("copy_nbt", (Number)this.nbtCopyTargetSlot[0]);
                }
            }
        }
    }
}

