/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.data;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.client.models.ModelConfigurableSides;
import blusunrize.immersiveengineering.client.models.ModelConveyor;
import blusunrize.immersiveengineering.client.models.connection.ConnectionLoader;
import blusunrize.immersiveengineering.client.models.connection.FeedthroughLoader;
import blusunrize.immersiveengineering.client.models.multilayer.MultiLayerLoader;
import blusunrize.immersiveengineering.client.models.obj.IEOBJLoader;
import blusunrize.immersiveengineering.client.models.split.SplitModelLoader;
import blusunrize.immersiveengineering.common.blocks.EnumMetals;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.cloth.StripCurtainBlock;
import blusunrize.immersiveengineering.common.blocks.generic.WallmountBlock;
import blusunrize.immersiveengineering.common.blocks.metal.MetalLadderBlock;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.plant.EnumHempGrowth;
import blusunrize.immersiveengineering.common.blocks.plant.HempBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.ModWorkbenchTileEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.SawdustBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.TreatedWoodStyles;
import blusunrize.immersiveengineering.common.data.DataGenUtils;
import blusunrize.immersiveengineering.common.data.IEDataGenerator;
import blusunrize.immersiveengineering.common.data.LoadedModels;
import blusunrize.immersiveengineering.common.data.models.LoadedModelBuilder;
import blusunrize.immersiveengineering.common.util.DirectionUtils;
import blusunrize.immersiveengineering.common.util.fluids.IEFluid;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.DyeColor;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.commons.lang3.tuple.Pair;

public class BlockStates
extends BlockStateProvider {
    private static final ResourceLocation ALU_FENCE_TEXTURE = IEDataGenerator.rl("block/metal/storage_aluminum");
    private static final ResourceLocation STEEL_FENCE_TEXTURE = IEDataGenerator.rl("block/metal/storage_steel");
    private static final ResourceLocation TREATED_FENCE_TEXTURE = IEDataGenerator.rl("block/wooden_decoration/treated_wood_horizontal");
    private final ConfiguredModel EMPTY_MODEL;
    private final LoadedModels loadedModels;
    final Map<Block, ModelFile> itemModels = new HashMap<Block, ModelFile>();
    private final ExistingFileHelper existingFileHelper;
    public ModelFile blastFurnaceOff;
    public ModelFile blastFurnaceOn;
    public ModelFile cokeOvenOff;
    public ModelFile cokeOvenOn;
    public ModelFile alloySmelterOff;
    public ModelFile alloySmelterOn;
    private static final Collector<Vector3i, JsonArray, JsonArray> POSITIONS_TO_JSON = Collector.of(JsonArray::new, (arr, vec) -> {
        JsonArray posJson = new JsonArray();
        posJson.add((Number)vec.func_177958_n());
        posJson.add((Number)vec.func_177956_o());
        posJson.add((Number)vec.func_177952_p());
        arr.add((JsonElement)posJson);
    }, (a, b) -> {
        JsonArray arr = new JsonArray();
        arr.addAll(a);
        arr.addAll(b);
        return arr;
    }, new Collector.Characteristics[0]);
    private static final List<Vector3i> COLUMN_TWO = ImmutableList.of((Object)BlockPos.field_177992_a, (Object)BlockPos.field_177992_a.func_177984_a());
    private static final List<Vector3i> COLUMN_THREE = ImmutableList.of((Object)BlockPos.field_177992_a, (Object)BlockPos.field_177992_a.func_177984_a(), (Object)BlockPos.field_177992_a.func_177981_b(2));
    private static final List<Vector3i> CUBE_THREE = BlockPos.func_218287_a((int)-1, (int)-1, (int)-1, (int)1, (int)1, (int)1).map(BlockPos::func_185334_h).collect(Collectors.toList());
    private static final List<Vector3i> CUBE_TWO = BlockPos.func_218287_a((int)0, (int)0, (int)-1, (int)1, (int)1, (int)0).map(BlockPos::func_185334_h).collect(Collectors.toList());
    Map<String, Map<Map<String, ResourceLocation>, Integer>> nameCache = new HashMap<String, Map<Map<String, ResourceLocation>, Integer>>();

    public BlockStates(DataGenerator gen, ExistingFileHelper exHelper, LoadedModels loaded) {
        super(gen, "immersiveengineering", exHelper);
        this.loadedModels = loaded;
        this.existingFileHelper = exHelper;
        this.EMPTY_MODEL = new ConfiguredModel((ModelFile)new ModelFile.ExistingModelFile(this.modLoc("block/ie_empty"), this.existingFileHelper));
    }

    private String name(Block b) {
        return b.getRegistryName().func_110623_a();
    }

    public void simpleBlockItem(Block b, ModelFile model) {
        this.simpleBlockItem(b, new ConfiguredModel(model));
    }

    private void simpleBlockItem(Block b, ConfiguredModel model) {
        this.simpleBlock(b, new ConfiguredModel[]{model});
        this.itemModels.put(b, model.model);
    }

    private void cubeSideVertical(Block b, ResourceLocation side, ResourceLocation vertical) {
        this.simpleBlockItem(b, (ModelFile)this.models().cubeBottomTop(this.name(b), side, vertical, vertical));
    }

    private void cubeAll(Block b, ResourceLocation texture) {
        this.simpleBlockItem(b, (ModelFile)this.models().cubeAll(this.name(b), texture));
    }

    private void scaffold(Block b, ResourceLocation others, ResourceLocation top) {
        this.simpleBlockItem(b, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(b), this.modLoc("block/ie_scaffolding"))).texture("side", others)).texture("bottom", others)).texture("top", top));
    }

    private void slabFor(Block b, ResourceLocation texture) {
        this.slabFor(b, texture, texture, texture);
    }

    private void slabFor(Block b, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        this.slab(IEBlocks.toSlab.get(b), side, top, bottom);
    }

    private void slab(SlabBlock b, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        ModelBuilder mainModel = this.models().slab(this.name((Block)b) + "_bottom", side, bottom, top);
        this.slabBlock(b, (ModelFile)mainModel, (ModelFile)this.models().slabTop(this.name((Block)b) + "_top", side, bottom, top), (ModelFile)this.models().cubeBottomTop(this.name((Block)b) + "_double", side, bottom, top));
        this.itemModels.put((Block)b, (ModelFile)mainModel);
    }

    private void stairs(StairsBlock b, ResourceLocation texture) {
        this.stairs(b, texture, texture, texture);
    }

    private void stairs(StairsBlock b, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        String baseName = this.name((Block)b);
        ModelBuilder stairs = this.models().stairs(baseName, side, bottom, top);
        ModelBuilder stairsInner = this.models().stairsInner(baseName + "_inner", side, bottom, top);
        ModelBuilder stairsOuter = this.models().stairsOuter(baseName + "_outer", side, bottom, top);
        this.stairsBlock(b, (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
        this.itemModels.put((Block)b, (ModelFile)stairs);
    }

    private ResourceLocation forgeLoc(String path) {
        return new ResourceLocation("forge", path);
    }

    private ResourceLocation addModelsPrefix(ResourceLocation in) {
        return new ResourceLocation(in.func_110624_b(), "models/" + in.func_110623_a());
    }

    private void postBlock(Block b, ResourceLocation texture) {
        ResourceLocation model = IEDataGenerator.rl("block/wooden_device/wooden_post.obj.ie");
        ImmutableList.Builder parts = ImmutableList.builder();
        parts.add((Object)new Vector3i(0, 0, 0)).add((Object)new Vector3i(0, 1, 0)).add((Object)new Vector3i(0, 2, 0)).add((Object)new Vector3i(0, 3, 0));
        for (Direction d : DirectionUtils.BY_HORIZONTAL_INDEX) {
            parts.add((Object)new BlockPos(0, 3, 0).func_177972_a(d));
        }
        LoadedModelBuilder builder = this.splitModel(this.name(b), IEOBJLoader.LOADER_NAME, model, texture.toString(), parts.build().stream(), true);
        builder.texture("texture", texture);
        this.getVariantBuilder(b).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)builder)});
    }

    private ModelFile cubeTwo(String name, ResourceLocation top, ResourceLocation bottom, ResourceLocation side, ResourceLocation front) {
        return ((LoadedModelBuilder)((LoadedModelBuilder)((LoadedModelBuilder)this.splitModel(name, this.forgeLoc("obj"), IEDataGenerator.rl("block/stone_multiblocks/cube_two.obj"), side.toString(), CUBE_TWO.stream(), false).texture("side", side)).texture("top", top)).texture("bottom", bottom)).texture("front", front);
    }

    private ModelFile cubeThree(String name, ResourceLocation def, ResourceLocation front) {
        return ((LoadedModelBuilder)this.splitModel(name, this.forgeLoc("obj"), IEDataGenerator.rl("block/stone_multiblocks/cube_three.obj"), def.toString(), CUBE_THREE.stream(), false).texture("side", def)).texture("front", front);
    }

    private ModelFile obj(String loc) {
        Preconditions.checkArgument((boolean)loc.endsWith(".obj"));
        return this.obj(loc.substring(0, loc.length() - 4), this.modLoc(loc));
    }

    private ModelFile obj(String name, ResourceLocation model) {
        return this.obj(name, model, (Map<String, ResourceLocation>)ImmutableMap.of());
    }

    private ModelFile obj(String name, ResourceLocation model, Map<String, ResourceLocation> textures) {
        this.assertModelExists(model);
        LoadedModelBuilder ret = this.loadedModels.withExistingParent(name, this.mcLoc("block")).loader(this.forgeLoc("obj")).additional("detectCullableFaces", false).additional("model", this.addModelsPrefix(model)).additional("flip-v", true);
        String particleTex = DataGenUtils.getTextureFromObj(model, this.existingFileHelper);
        if (particleTex.charAt(0) == '#') {
            particleTex = textures.get(particleTex.substring(1)).toString();
        }
        ret.texture("particle", particleTex);
        for (Map.Entry<String, ResourceLocation> e : textures.entrySet()) {
            ret.texture(e.getKey(), e.getValue());
        }
        return ret;
    }

    private LoadedModelBuilder splitOBJ(String loc, TemplateMultiblock mb) {
        return this.splitOBJ(loc, mb, false);
    }

    private LoadedModelBuilder splitOBJ(String loc, TemplateMultiblock mb, boolean mirror) {
        UnaryOperator transform = UnaryOperator.identity();
        if (mirror) {
            Vector3i size = mb.getSize(null);
            transform = p -> new BlockPos(size.func_177958_n() - p.func_177958_n() - 1, p.func_177956_o(), p.func_177952_p());
        }
        return this.splitOBJ(loc, mb, transform);
    }

    private LoadedModelBuilder splitOBJ(String loc, TemplateMultiblock mb, UnaryOperator<BlockPos> transform) {
        Preconditions.checkArgument((boolean)loc.endsWith(".obj"));
        return this.splitOBJ(loc.substring(0, loc.length() - 4), this.modLoc(loc), mb, transform);
    }

    private LoadedModelBuilder splitOBJ(String loc, List<Vector3i> parts) {
        Preconditions.checkArgument((boolean)loc.endsWith(".obj"));
        ResourceLocation modelLoc = this.modLoc(loc);
        return this.splitModel(loc.substring(0, loc.length() - 4), this.forgeLoc("obj"), modelLoc, DataGenUtils.getTextureFromObj(modelLoc, this.existingFileHelper), parts.stream(), false);
    }

    private LoadedModelBuilder splitOBJ(String name, ResourceLocation model, TemplateMultiblock multiblock, UnaryOperator<BlockPos> transform) {
        BlockPos offset = multiblock.getMasterFromOriginOffset();
        Stream<Vector3i> partsStream = multiblock.getStructure(null).stream().filter(info -> !info.field_186243_b.func_196958_f()).map(info -> info.field_186242_a).map(transform).map(arg_0 -> BlockStates.lambda$splitOBJ$5((Vector3i)offset, arg_0));
        return this.splitModel(name, this.forgeLoc("obj"), model, DataGenUtils.getTextureFromObj(model, this.existingFileHelper), partsStream, false);
    }

    private LoadedModelBuilder splitModel(String name, ResourceLocation loader, ResourceLocation model, String particleTexture, Stream<Vector3i> parts, boolean dynamic) {
        this.assertModelExists(model);
        LoadedModelBuilder ret = (LoadedModelBuilder)this.loadedModels.withExistingParent(name, this.mcLoc("block")).loader(SplitModelLoader.LOCATION).additional("base_loader", loader).additional("dynamic", dynamic).additional("detectCullableFaces", false).additional("model", this.addModelsPrefix(model)).additional("flip-v", true).texture("particle", particleTexture);
        JsonArray partsJson = parts.sorted().collect(POSITIONS_TO_JSON);
        ret.additional("split_parts", (JsonElement)partsJson);
        return ret;
    }

    private LoadedModelBuilder splitIEOBJ(String loc, TemplateMultiblock mb, boolean mirror) {
        UnaryOperator transform = UnaryOperator.identity();
        if (mirror) {
            Vector3i size = mb.getSize(null);
            transform = p -> new BlockPos(size.func_177958_n() - p.func_177958_n() - 1, p.func_177956_o(), p.func_177952_p());
        }
        BlockPos offset = mb.getMasterFromOriginOffset();
        Stream<Vector3i> partsStream = mb.getStructure(null).stream().filter(info -> !info.field_186243_b.func_196958_f()).map(info -> info.field_186242_a).map(transform).map(arg_0 -> BlockStates.lambda$splitIEOBJ$9((Vector3i)offset, arg_0));
        return this.splitIEOBJ(loc, partsStream.collect(Collectors.toList()));
    }

    private LoadedModelBuilder splitIEOBJ(String model, List<Vector3i> parts) {
        Preconditions.checkArgument((boolean)model.endsWith(".obj.ie"));
        String name = model.substring(0, model.length() - 7);
        ResourceLocation modelLoc = this.modLoc(model);
        return this.splitModel(name, IEOBJLoader.LOADER_NAME, modelLoc, DataGenUtils.getTextureFromObj(modelLoc, this.existingFileHelper), parts.stream(), true);
    }

    private LoadedModelBuilder ieObj(String loc) {
        Preconditions.checkArgument((boolean)loc.endsWith(".obj.ie"));
        return this.ieObj(loc.substring(0, loc.length() - 7), this.modLoc(loc));
    }

    private LoadedModelBuilder ieObj(String name, ResourceLocation model) {
        return (LoadedModelBuilder)this.loadedModels.withExistingParent(name, this.mcLoc("block")).loader(this.modLoc("ie_obj")).additional("model", this.addModelsPrefix(model)).additional("flip-v", true).texture("particle", DataGenUtils.getTextureFromObj(model, this.existingFileHelper));
    }

    protected void registerStatesAndModels() {
        for (EnumMetals enumMetals : EnumMetals.values()) {
            String name = enumMetals.tagName();
            if (!enumMetals.isVanillaMetal()) {
                BlockModelBuilder storageModel;
                if (enumMetals.shouldAddOre()) {
                    this.cubeAll(IEBlocks.Metals.ores.get((Object)enumMetals), this.modLoc("block/metal/ore_" + name));
                }
                ResourceLocation resourceLocation = this.modLoc("block/metal/storage_" + name);
                Block storage = IEBlocks.Metals.storage.get((Object)enumMetals);
                String storageName = this.name(storage);
                if (enumMetals == EnumMetals.URANIUM) {
                    ResourceLocation side = this.modLoc("block/metal/storage_" + name + "_side");
                    ResourceLocation top = this.modLoc("block/metal/storage_" + name + "_top");
                    storageModel = (BlockModelBuilder)this.models().cubeBottomTop(storageName, side, top, top);
                    this.slabFor(storage, side, top, top);
                } else {
                    storageModel = (BlockModelBuilder)this.models().cubeAll(storageName, resourceLocation);
                    this.slabFor(storage, resourceLocation);
                }
                this.simpleBlockItem(storage, (ModelFile)storageModel);
            }
            ResourceLocation resourceLocation = this.modLoc("block/metal/sheetmetal_" + name);
            this.cubeAll(IEBlocks.Metals.sheetmetal.get((Object)enumMetals), resourceLocation);
            this.slabFor(IEBlocks.Metals.sheetmetal.get((Object)enumMetals), resourceLocation);
        }
        for (EnumMetals enumMetals : DyeColor.values()) {
            ResourceLocation sheetmetalName = this.modLoc("block/metal/sheetmetal_" + enumMetals.func_176762_d());
            this.cubeAll(IEBlocks.MetalDecoration.coloredSheetmetal.get((Object)enumMetals), sheetmetalName);
            this.slabFor(IEBlocks.MetalDecoration.coloredSheetmetal.get((Object)enumMetals), sheetmetalName);
        }
        this.fenceBlock(IEBlocks.WoodenDecoration.treatedFence, TREATED_FENCE_TEXTURE);
        this.fenceBlock(IEBlocks.MetalDecoration.steelFence, STEEL_FENCE_TEXTURE);
        this.fenceBlock(IEBlocks.MetalDecoration.aluFence, ALU_FENCE_TEXTURE);
        this.cubeAll(IEBlocks.StoneDecoration.cokebrick, IEDataGenerator.rl("block/stone_decoration/cokebrick"));
        this.cubeAll(IEBlocks.StoneDecoration.blastbrick, IEDataGenerator.rl("block/stone_decoration/blastbrick"));
        this.cubeAll(IEBlocks.StoneDecoration.blastbrickReinforced, IEDataGenerator.rl("block/stone_decoration/blastbrick_reinforced"));
        this.cubeAll(IEBlocks.StoneDecoration.coke, IEDataGenerator.rl("block/stone_decoration/coke"));
        this.cubeAll(IEBlocks.StoneDecoration.concrete, IEDataGenerator.rl("block/stone_decoration/concrete"));
        this.cubeAll(IEBlocks.StoneDecoration.concreteLeaded, IEDataGenerator.rl("block/stone_decoration/concrete_leaded"));
        this.cubeAll(IEBlocks.StoneDecoration.concreteTile, IEDataGenerator.rl("block/stone_decoration/concrete_tile"));
        this.cubeAll(IEBlocks.StoneDecoration.hempcrete, IEDataGenerator.rl("block/stone_decoration/hempcrete"));
        this.cubeAll(IEBlocks.StoneDecoration.insulatingGlass, IEDataGenerator.rl("block/stone_decoration/insulating_glass"));
        this.cubeAll(IEBlocks.StoneDecoration.alloybrick, IEDataGenerator.rl("block/stone_decoration/alloybrick"));
        for (Enum enum_ : TreatedWoodStyles.values()) {
            this.cubeAll(IEBlocks.WoodenDecoration.treatedWood.get(enum_), IEDataGenerator.rl("block/wooden_decoration/treated_wood_" + enum_.name().toLowerCase(Locale.ENGLISH)));
        }
        this.cubeSideVertical(IEBlocks.MetalDecoration.lvCoil, IEDataGenerator.rl("block/metal_decoration/coil_lv_side"), IEDataGenerator.rl("block/metal_decoration/coil_lv_top"));
        this.cubeSideVertical(IEBlocks.MetalDecoration.mvCoil, IEDataGenerator.rl("block/metal_decoration/coil_mv_side"), IEDataGenerator.rl("block/metal_decoration/coil_mv_top"));
        this.cubeSideVertical(IEBlocks.MetalDecoration.hvCoil, IEDataGenerator.rl("block/metal_decoration/coil_hv_side"), IEDataGenerator.rl("block/metal_decoration/coil_hv_top"));
        this.cubeAll(IEBlocks.MetalDecoration.engineeringRS, IEDataGenerator.rl("block/metal_decoration/redstone_engineering"));
        this.cubeAll(IEBlocks.MetalDecoration.engineeringHeavy, IEDataGenerator.rl("block/metal_decoration/heavy_engineering"));
        this.cubeAll(IEBlocks.MetalDecoration.engineeringLight, IEDataGenerator.rl("block/metal_decoration/light_engineering"));
        this.cubeAll(IEBlocks.MetalDecoration.generator, IEDataGenerator.rl("block/metal_decoration/generator"));
        this.cubeAll(IEBlocks.MetalDecoration.radiator, IEDataGenerator.rl("block/metal_decoration/radiator"));
        this.scaffold(IEBlocks.WoodenDecoration.treatedScaffolding, IEDataGenerator.rl("block/wooden_decoration/scaffolding"), IEDataGenerator.rl("block/wooden_decoration/scaffolding_top"));
        ResourceLocation aluSide = IEDataGenerator.rl("block/metal_decoration/aluminum_scaffolding");
        ResourceLocation steelSide = IEDataGenerator.rl("block/metal_decoration/steel_scaffolding");
        for (MetalScaffoldingType metalScaffoldingType : MetalScaffoldingType.values()) {
            String suffix = "_" + metalScaffoldingType.name().toLowerCase(Locale.ENGLISH);
            ResourceLocation aluTop = IEDataGenerator.rl("block/metal_decoration/aluminum_scaffolding_top" + suffix);
            ResourceLocation steelTop = IEDataGenerator.rl("block/metal_decoration/steel_scaffolding_top" + suffix);
            this.scaffold(IEBlocks.MetalDecoration.aluScaffolding.get((Object)metalScaffoldingType), aluSide, aluTop);
            this.scaffold(IEBlocks.MetalDecoration.steelScaffolding.get((Object)metalScaffoldingType), steelSide, steelTop);
            this.slabFor(IEBlocks.MetalDecoration.aluScaffolding.get((Object)metalScaffoldingType), aluSide, aluTop, aluSide);
            this.slabFor(IEBlocks.MetalDecoration.steelScaffolding.get((Object)metalScaffoldingType), steelSide, steelTop, steelSide);
            this.stairs(IEBlocks.MetalDecoration.aluScaffoldingStair.get((Object)metalScaffoldingType), aluSide, aluTop, aluSide);
            this.stairs(IEBlocks.MetalDecoration.steelScaffoldingStair.get((Object)metalScaffoldingType), steelSide, steelTop, steelSide);
        }
        this.slabFor(IEBlocks.StoneDecoration.cokebrick, IEDataGenerator.rl("block/stone_decoration/cokebrick"));
        this.slabFor(IEBlocks.StoneDecoration.blastbrick, IEDataGenerator.rl("block/stone_decoration/blastbrick"));
        this.slabFor(IEBlocks.StoneDecoration.blastbrickReinforced, IEDataGenerator.rl("block/stone_decoration/blastbrick_reinforced"));
        this.slabFor(IEBlocks.StoneDecoration.coke, IEDataGenerator.rl("block/stone_decoration/coke"));
        this.slabFor(IEBlocks.StoneDecoration.concrete, IEDataGenerator.rl("block/stone_decoration/concrete"));
        this.slabFor(IEBlocks.StoneDecoration.concreteTile, IEDataGenerator.rl("block/stone_decoration/concrete_tile"));
        this.slabFor(IEBlocks.StoneDecoration.concreteLeaded, IEDataGenerator.rl("block/stone_decoration/concrete_leaded"));
        this.slabFor(IEBlocks.StoneDecoration.hempcrete, IEDataGenerator.rl("block/stone_decoration/hempcrete"));
        this.slabFor(IEBlocks.StoneDecoration.insulatingGlass, IEDataGenerator.rl("block/stone_decoration/insulating_glass"));
        this.slabFor(IEBlocks.StoneDecoration.alloybrick, IEDataGenerator.rl("block/stone_decoration/alloybrick"));
        for (Enum enum_ : TreatedWoodStyles.values()) {
            this.slabFor(IEBlocks.WoodenDecoration.treatedWood.get(enum_), IEDataGenerator.rl("block/wooden_decoration/treated_wood_" + enum_.name().toLowerCase(Locale.ENGLISH)));
        }
        this.stairs(IEBlocks.StoneDecoration.hempcreteStairs, IEDataGenerator.rl("block/stone_decoration/hempcrete"));
        this.stairs(IEBlocks.StoneDecoration.concreteStairs[0], IEDataGenerator.rl("block/stone_decoration/concrete"));
        this.stairs(IEBlocks.StoneDecoration.concreteStairs[1], IEDataGenerator.rl("block/stone_decoration/concrete_tile"));
        this.stairs(IEBlocks.StoneDecoration.concreteStairs[2], IEDataGenerator.rl("block/stone_decoration/concrete_leaded"));
        for (Enum enum_ : TreatedWoodStyles.values()) {
            this.stairs(IEBlocks.WoodenDecoration.treatedStairs.get(enum_), IEDataGenerator.rl("block/wooden_decoration/treated_wood_" + enum_.name().toLowerCase(Locale.ENGLISH)));
        }
        this.postBlock(IEBlocks.WoodenDecoration.treatedPost, IEDataGenerator.rl("block/wooden_decoration/post"));
        this.postBlock(IEBlocks.MetalDecoration.steelPost, IEDataGenerator.rl("block/metal_decoration/steel_post"));
        this.postBlock(IEBlocks.MetalDecoration.aluPost, IEDataGenerator.rl("block/metal_decoration/aluminum_post"));
        this.createStoneMultiblocks();
        this.createMetalMultiblocks();
        this.createConnectors();
        this.simpleBlock(IEBlocks.Multiblocks.bucketWheel, new ConfiguredModel[]{this.EMPTY_MODEL});
        this.simpleBlock(IEBlocks.MetalDevices.fluidPipe, (ModelFile)this.ieObj("block/metal_device/fluid_pipe.obj.ie"));
        this.createMultiblock(IEBlocks.MetalDevices.cloche, (ModelFile)this.splitIEOBJ("block/metal_device/cloche.obj.ie", COLUMN_THREE));
        this.turret(IEBlocks.MetalDevices.turretChem, (ModelFile)this.ieObj("block/metal_device/chem_turret.obj.ie"));
        this.turret(IEBlocks.MetalDevices.turretGun, (ModelFile)this.ieObj("block/metal_device/gun_turret.obj.ie"));
        this.createMultiblock(IEBlocks.MetalDevices.teslaCoil, (ModelFile)this.splitOBJ("block/metal_device/teslacoil.obj", (List<Vector3i>)ImmutableList.of((Object)BlockPos.field_177992_a, (Object)new BlockPos(0, 0, -1))), null, (EnumProperty<Direction>)IEProperties.FACING_ALL, null, 180);
        for (Map.Entry entry : IEBlocks.MetalDevices.chutes.entrySet()) {
            ModelBuilder model = ((LoadedModelBuilder)this.ieObj("block/metal_device/chute_" + ((EnumMetals)((Object)entry.getKey())).tagName(), IEDataGenerator.rl("block/metal_device/chute.obj.ie")).texture("texture", IEDataGenerator.rl("block/metal/sheetmetal_" + ((EnumMetals)((Object)entry.getKey())).tagName()))).texture("particle", IEDataGenerator.rl("block/metal/sheetmetal_" + ((EnumMetals)((Object)entry.getKey())).tagName()));
            this.simpleBlock((Block)entry.getValue(), (ModelFile)model);
        }
        this.simpleBlock(IEBlocks.Misc.fakeLight, new ConfiguredModel[]{this.EMPTY_MODEL});
        this.createMultistateSingleModel(IEBlocks.WoodenDevices.windmill, this.EMPTY_MODEL);
        this.createMultistateSingleModel(IEBlocks.WoodenDevices.watermill, this.EMPTY_MODEL);
        this.createMultistateSingleModel(IEBlocks.MetalDecoration.lantern, new ConfiguredModel((ModelFile)this.ieObj("block/lantern.obj.ie")));
        ModelFile noneModel = this.createMetalLadder("metal_ladder", null, null);
        ModelFile modelFile = this.createMetalLadder("metal_ladder_alu", IEDataGenerator.rl("block/metal_decoration/aluminum_scaffolding_open"), IEDataGenerator.rl("block/metal_decoration/aluminum_scaffolding"));
        ModelFile steelModel = this.createMetalLadder("metal_ladder_steel", IEDataGenerator.rl("block/metal_decoration/steel_scaffolding_open"), IEDataGenerator.rl("block/metal_decoration/steel_scaffolding"));
        Block block = IEBlocks.MetalDecoration.metalLadder.get((Object)MetalLadderBlock.CoverType.STEEL);
        Block alu = IEBlocks.MetalDecoration.metalLadder.get((Object)MetalLadderBlock.CoverType.ALU);
        Block none = IEBlocks.MetalDecoration.metalLadder.get((Object)MetalLadderBlock.CoverType.NONE);
        this.createDirectionalBlock(none, (Property<Direction>)IEProperties.FACING_HORIZONTAL, noneModel);
        this.createDirectionalBlock(alu, (Property<Direction>)IEProperties.FACING_HORIZONTAL, modelFile);
        this.createDirectionalBlock(block, (Property<Direction>)IEProperties.FACING_HORIZONTAL, steelModel);
        this.itemModels.put(alu, modelFile);
        this.itemModels.put(block, steelModel);
        this.createWallmount(IEBlocks.WoodenDevices.treatedWallmount, IEDataGenerator.rl("block/wooden_device/wallmount"));
        ModelBuilder turntableModel = this.models().cubeBottomTop("turntable", this.modLoc("block/wooden_device/turntable"), this.modLoc("block/wooden_device/turntable_bottom"), this.modLoc("block/wooden_device/turntable_top"));
        this.createRotatedBlock(IEBlocks.WoodenDevices.turntable, arg_0 -> BlockStates.lambda$registerStatesAndModels$10((ModelFile)turntableModel, arg_0), (Property<Direction>)IEProperties.FACING_ALL, (List<Property<?>>)ImmutableList.of(), -90, 0);
        this.itemModels.put(IEBlocks.WoodenDevices.turntable, (ModelFile)turntableModel);
        this.createWallmount(IEBlocks.MetalDecoration.aluWallmount, IEDataGenerator.rl("block/metal_decoration/aluminum_wallmount"));
        this.createWallmount(IEBlocks.MetalDecoration.steelWallmount, IEDataGenerator.rl("block/metal_decoration/steel_wallmount"));
        LoadedModelBuilder steelModel2 = ((LoadedModelBuilder)((LoadedModelBuilder)this.ieObj("block/slope.obj.ie").texture("texture", this.modLoc("block/metal_decoration/steel_scaffolding"))).texture("particle", this.modLoc("block/metal_decoration/steel_scaffolding"))).transforms(this.modLoc("item/block"));
        LoadedModelBuilder loadedModelBuilder = ((LoadedModelBuilder)((LoadedModelBuilder)this.ieObj("slope_alu", this.modLoc("block/slope.obj.ie")).texture("texture", this.modLoc("block/metal_decoration/aluminum_scaffolding"))).texture("particle", this.modLoc("block/metal_decoration/aluminum_scaffolding"))).transforms(this.modLoc("item/block"));
        this.createMultistateSingleModel(IEBlocks.MetalDecoration.slopeSteel, new ConfiguredModel((ModelFile)steelModel2));
        this.itemModels.put(IEBlocks.MetalDecoration.slopeSteel, (ModelFile)steelModel2);
        this.createMultistateSingleModel(IEBlocks.MetalDecoration.slopeAlu, new ConfiguredModel((ModelFile)loadedModelBuilder));
        this.itemModels.put(IEBlocks.MetalDecoration.slopeAlu, (ModelFile)loadedModelBuilder);
        this.createRotatedBlock(IEBlocks.StoneDecoration.coresample, map -> this.obj("block/coresample.obj"), (Property<Direction>)IEProperties.FACING_HORIZONTAL, (List<Property<?>>)ImmutableList.of());
        ResourceLocation concreteTexture = IEDataGenerator.rl("block/stone_decoration/concrete");
        this.simpleBlockItem(IEBlocks.StoneDecoration.concreteSheet, (ModelFile)this.models().carpet("concrete_sheet", concreteTexture));
        this.simpleBlockItem(IEBlocks.StoneDecoration.concreteQuarter, this.quarter("concrete_quarter", concreteTexture));
        this.simpleBlockItem(IEBlocks.StoneDecoration.concreteThreeQuarter, this.threeQuarter("concrete_three_quarter", concreteTexture));
        this.simpleBlock(IEBlocks.StoneDecoration.concreteSprayed, this.obj("block/sprayed_concrete.obj"));
        this.createRotatedBlock(IEBlocks.WoodenDevices.craftingTable, state -> this.obj("block/wooden_device/craftingtable.obj"), (Property<Direction>)IEProperties.FACING_HORIZONTAL, (List<Property<?>>)ImmutableList.of());
        this.cubeAll(IEBlocks.WoodenDevices.crate, this.modLoc("block/wooden_device/crate"));
        this.cubeAll(IEBlocks.WoodenDevices.reinforcedCrate, this.modLoc("block/wooden_device/reinforced_crate"));
        ModelBuilder modelBuilder = this.models().cubeBottomTop("gunpowder_barrel", IEDataGenerator.rl("block/wooden_device/gunpowder_barrel"), IEDataGenerator.rl("block/wooden_device/barrel_up_none"), IEDataGenerator.rl("block/wooden_device/gunpowder_barrel_top"));
        this.createMultistateSingleModel(IEBlocks.WoodenDevices.gunpowderBarrel, new ConfiguredModel((ModelFile)modelBuilder));
        this.itemModels.put(IEBlocks.WoodenDevices.gunpowderBarrel, (ModelFile)modelBuilder);
        this.simpleBlockItem(IEBlocks.WoodenDevices.sorter, this.createRouterModel(IEDataGenerator.rl("block/wooden_device/sorter"), "router"));
        ModelBuilder modelBuilder2 = this.models().cubeBottomTop("item_batcher", this.modLoc("block/wooden_device/item_batcher"), this.modLoc("block/wooden_device/item_batcher_in"), this.modLoc("block/wooden_device/item_batcher_out"));
        this.createRotatedBlock(IEBlocks.WoodenDevices.itemBatcher, arg_0 -> BlockStates.lambda$registerStatesAndModels$13((ModelFile)modelBuilder2, arg_0), (Property<Direction>)IEProperties.FACING_ALL, (List<Property<?>>)ImmutableList.of(), -90, 0);
        this.itemModels.put(IEBlocks.WoodenDevices.itemBatcher, (ModelFile)modelBuilder2);
        this.simpleBlockItem(IEBlocks.WoodenDevices.fluidSorter, this.createRouterModel(IEDataGenerator.rl("block/wooden_device/fluid_sorter"), "fluid_router"));
        this.simpleBlockItem(IEBlocks.WoodenDevices.woodenBarrel, (ModelFile)this.loadedModels.getBuilder("wooden_devices/barrel").loader(ModelConfigurableSides.Loader.NAME).additional("type", "vertical").additional("base_name", this.modLoc("block/wooden_device/barrel")));
        this.createRotatedBlock(IEBlocks.Cloth.curtain, state -> new ModelFile.ExistingModelFile(IEDataGenerator.rl(state.getSetStates().get(StripCurtainBlock.CEILING_ATTACHED) == Boolean.FALSE ? "block/stripcurtain" : "block/stripcurtain_middle"), this.existingFileHelper), (Property<Direction>)IEProperties.FACING_HORIZONTAL, (List<Property<?>>)ImmutableList.of((Object)StripCurtainBlock.CEILING_ATTACHED));
        this.cubeAll(IEBlocks.Cloth.cushion, this.modLoc("block/cushion"));
        this.createMultistateSingleModel(IEBlocks.Cloth.shaderBanner, this.EMPTY_MODEL);
        this.createMultistateSingleModel(IEBlocks.Cloth.shaderBannerWall, this.EMPTY_MODEL);
        this.simpleBlockItem(IEBlocks.MetalDevices.barrel, (ModelFile)this.loadedModels.getBuilder("metal_devices/barrel").loader(ModelConfigurableSides.Loader.NAME).additional("type", "vertical").additional("base_name", this.modLoc("block/metal_device/barrel")));
        for (Map.Entry cap : ImmutableMap.of((Object)IEBlocks.MetalDevices.capacitorCreative, (Object)"creative", (Object)IEBlocks.MetalDevices.capacitorLV, (Object)"lv", (Object)IEBlocks.MetalDevices.capacitorMV, (Object)"mv", (Object)IEBlocks.MetalDevices.capacitorHV, (Object)"hv").entrySet()) {
            LoadedModelBuilder loadedModelBuilder2 = this.loadedModels.getBuilder("block/metal_device/capacitor_" + (String)cap.getValue()).loader(ModelConfigurableSides.Loader.NAME).additional("type", "side_top_bottom").additional("base_name", this.modLoc("block/metal_device/capacitor_" + (String)cap.getValue()));
            this.simpleBlockItem((Block)cap.getKey(), (ModelFile)loadedModelBuilder2);
        }
        LoadedModelBuilder loadedModelBuilder3 = this.loadedModels.getBuilder("block/metal_device/fluid_placer").loader(ModelConfigurableSides.Loader.NAME).additional("type", "all_same_texture").additional("base_name", this.modLoc("block/metal_device/fluid_placer"));
        this.simpleBlockItem(IEBlocks.MetalDevices.fluidPlacer, (ModelFile)loadedModelBuilder3);
        this.createMultiblock(IEBlocks.MetalDevices.blastFurnacePreheater, (ModelFile)this.splitOBJ("block/metal_device/blastfurnace_preheater.obj", COLUMN_THREE));
        ModelBuilder modelBuilder3 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("furnace_heater_on", IEDataGenerator.rl("block/ie_six_sides_overlay_all_but_one"))).texture("block_all", IEDataGenerator.rl("block/metal_device/furnace_heater_active"))).texture("block_north", IEDataGenerator.rl("block/metal_device/furnace_heater_socket"))).texture("overlay_all", IEDataGenerator.rl("block/metal_device/furnace_heater_active_overlay"));
        ModelBuilder furnaceHeaterOff = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("furnace_heater_off", IEDataGenerator.rl("block/ie_six_sides_overlay_all_but_one"))).texture("block_all", IEDataGenerator.rl("block/metal_device/furnace_heater"))).texture("block_north", IEDataGenerator.rl("block/metal_device/furnace_heater_socket"))).texture("overlay_all", IEDataGenerator.rl("block/metal_device/furnace_heater_overlay"));
        this.createRotatedBlock(IEBlocks.MetalDevices.furnaceHeater, arg_0 -> BlockStates.lambda$registerStatesAndModels$15((ModelFile)modelBuilder3, (ModelFile)furnaceHeaterOff, arg_0), (Property<Direction>)IEProperties.FACING_ALL, (List<Property<?>>)ImmutableList.of((Object)((Object)IEProperties.ACTIVE)), 180, 0);
        this.itemModels.put(IEBlocks.MetalDevices.furnaceHeater, (ModelFile)furnaceHeaterOff);
        this.createPump();
        ModelBuilder modelBuilder4 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("kinetic_dynamo", this.mcLoc("block/cube"))).texture("down", this.modLoc("block/metal_device/dynamo_top"))).texture("south", this.modLoc("block/metal_device/dynamo_top"))).texture("up", this.modLoc("block/metal_device/dynamo_top"))).texture("north", this.modLoc("block/metal_device/dynamo_front"))).texture("west", this.modLoc("block/metal_device/dynamo_side"))).texture("east", this.modLoc("block/metal_device/dynamo_side"));
        this.createRotatedBlock(IEBlocks.MetalDevices.dynamo, arg_0 -> BlockStates.lambda$registerStatesAndModels$16((ModelFile)modelBuilder4, arg_0), (Property<Direction>)IEProperties.FACING_HORIZONTAL, (List<Property<?>>)ImmutableList.of());
        this.itemModels.put(IEBlocks.MetalDevices.dynamo, (ModelFile)modelBuilder4);
        this.simpleBlockItem(IEBlocks.MetalDevices.thermoelectricGen, new ConfiguredModel((ModelFile)this.models().cubeBottomTop("thermoelectric_generator", this.modLoc("block/metal_device/thermoelectric_gen_side"), this.modLoc("block/metal_device/thermoelectric_gen_bottom"), this.modLoc("block/metal_device/thermoelectric_gen_top"))));
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("loader", this.forgeLoc("obj").toString());
        jsonObject.addProperty("detectCullableFaces", Boolean.valueOf(false));
        jsonObject.addProperty("flip-v", Boolean.valueOf(true));
        jsonObject.addProperty("model", this.modLoc("models/block/metal_device/charging_station.obj").toString());
        JsonObject translucent = new JsonObject();
        translucent.addProperty("loader", this.forgeLoc("obj").toString());
        translucent.addProperty("detectCullableFaces", Boolean.valueOf(false));
        translucent.addProperty("flip-v", Boolean.valueOf(true));
        translucent.addProperty("model", this.modLoc("models/block/metal_device/charging_station_glass.obj").toString());
        ModelBuilder modelBuilder5 = this.loadedModels.getBuilder("metal_device/charging_station").loader(MultiLayerLoader.LOCATION).additional("solid", (JsonElement)jsonObject).additional("translucent", (JsonElement)translucent).transforms(this.modLoc("item/block")).texture("particle", DataGenUtils.getTextureFromObj(this.modLoc("block/metal_device/charging_station.obj"), this.existingFileHelper));
        this.createRotatedBlock(IEBlocks.MetalDevices.chargingStation, arg_0 -> BlockStates.lambda$registerStatesAndModels$17((ModelFile)modelBuilder5, arg_0), (Property<Direction>)IEProperties.FACING_HORIZONTAL, (List<Property<?>>)ImmutableList.of());
        this.itemModels.put(IEBlocks.MetalDevices.chargingStation, (ModelFile)modelBuilder5);
        for (Block b : IEBlocks.MetalDevices.CONVEYORS.values()) {
            this.createMultistateSingleModel(b, new ConfiguredModel((ModelFile)this.loadedModels.getBuilder("metal_device/conveyor").loader(ModelConveyor.ConveyorLoader.LOCATION)));
        }
        this.createHemp();
        this.simpleBlock(IEBlocks.Misc.pottedHemp, (ModelFile)((BlockModelBuilder)this.models().withExistingParent("potted_hemp", this.mcLoc("block/flower_pot_cross"))).texture("plant", new ResourceLocation("immersiveengineering", "block/hemp/potted")));
        this.createSawdust();
        for (IEFluid f : IEFluid.IE_FLUIDS) {
            ResourceLocation resourceLocation = f.getAttributes().getStillTexture();
            ModelBuilder model2 = ((BlockModelBuilder)this.models().getBuilder("block/fluid/" + f.getRegistryName().func_110623_a())).texture("particle", resourceLocation);
            this.getVariantBuilder((Block)f.block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model2)});
        }
        this.createRotatedBlock(IEBlocks.MetalDevices.toolbox, state -> this.obj("block/toolbox.obj"), (Property<Direction>)IEProperties.FACING_HORIZONTAL, (List<Property<?>>)ImmutableList.of());
        this.loadedModels.backupModels();
    }

    public void turret(Block b, ModelFile masterModel) {
        this.createRotatedBlock(b, s -> {
            if (s.getSetStates().get((Object)IEProperties.MULTIBLOCKSLAVE) == Boolean.TRUE) {
                return this.EMPTY_MODEL.model;
            }
            return masterModel;
        }, (Property<Direction>)IEProperties.FACING_HORIZONTAL, (List<Property<?>>)ImmutableList.of((Object)((Object)IEProperties.MULTIBLOCKSLAVE)));
    }

    public void fenceBlock(FenceBlock b, ResourceLocation texture) {
        super.fenceBlock(b, texture);
        this.itemModels.put((Block)b, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(b.getRegistryName().func_110623_a() + "_inventory", this.mcLoc("block/fence_inventory"))).texture("texture", texture));
    }

    private ModelFile retexture(String name, ResourceLocation baseModel, ImmutableMap<String, ResourceLocation> textures) {
        LoadedModelBuilder ret = this.loadedModels.getBuilder(name).loader(this.guessLoader(baseModel).get());
        for (Map.Entry e : textures.entrySet()) {
            ret.texture((String)e.getKey(), (ResourceLocation)e.getValue());
        }
        return ret;
    }

    private void createConnectors() {
        this.createConnector(IEBlocks.MetalDevices.floodlight, IEDataGenerator.rl("block/metal_device/floodlight.obj.ie"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228645_f_(), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.getEnergyConnector("LV", false), IEDataGenerator.rl("block/connector/connector_lv.obj"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of((Object)"texture", (Object)this.modLoc("block/connector/connector_lv")), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.getEnergyConnector("LV", true), IEDataGenerator.rl("block/connector/connector_lv.obj"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of((Object)"texture", (Object)this.modLoc("block/connector/relay_lv")), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.getEnergyConnector("MV", false), IEDataGenerator.rl("block/connector/connector_mv.obj"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of((Object)"texture", (Object)this.modLoc("block/connector/connector_mv")), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.getEnergyConnector("MV", true), IEDataGenerator.rl("block/connector/connector_mv.obj"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of((Object)"texture", (Object)this.modLoc("block/connector/relay_mv")), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.getEnergyConnector("HV", false), IEDataGenerator.rl("block/connector/connector_hv.obj"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.getEnergyConnector("HV", true), IEDataGenerator.rl("block/connector/relay_hv.obj"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228645_f_());
        this.createConnector(IEBlocks.Connectors.connectorStructural, IEDataGenerator.rl("block/connector/connector_structural.obj.ie"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.connectorRedstone, IEDataGenerator.rl("block/connector/connector_redstone.obj.ie"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.connectorProbe, IEDataGenerator.rl("block/connector/connector_probe.obj.ie"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228643_e_(), RenderType.func_228645_f_());
        this.createConnector(IEBlocks.Connectors.connectorBundled, IEDataGenerator.rl("block/connector/connector_bundled.obj"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228643_e_());
        this.createConnector(IEBlocks.Connectors.feedthrough, FeedthroughLoader.LOCATION, (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228661_n_().toArray(new RenderType[0]));
        this.createConnector(IEBlocks.MetalDevices.electricLantern, (VariantBlockStateBuilder.PartialBlockstate state) -> IEDataGenerator.rl("block/metal_device/e_lantern.obj"), (VariantBlockStateBuilder.PartialBlockstate state) -> {
            if (state.getSetStates().get((Object)IEProperties.ACTIVE) == Boolean.FALSE) {
                return ImmutableMap.of((Object)"texture", (Object)this.modLoc("block/metal_device/electric_lantern"));
            }
            return ImmutableMap.of((Object)"texture", (Object)this.modLoc("block/metal_device/electric_lantern_on"));
        }, (List<Property<?>>)ImmutableList.of((Object)((Object)IEProperties.ACTIVE)), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.redstoneBreaker, IEDataGenerator.rl("block/connector/redstone_breaker.obj.ie"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.breakerswitch, (VariantBlockStateBuilder.PartialBlockstate map) -> {
            if (map.getSetStates().get((Object)IEProperties.ACTIVE) == Boolean.FALSE) {
                return IEDataGenerator.rl("block/connector/breaker_switch_off.obj.ie");
            }
            return IEDataGenerator.rl("block/connector/breaker_switch_on.obj.ie");
        }, (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), (List<Property<?>>)ImmutableList.of((Object)((Object)IEProperties.ACTIVE)), RenderType.func_228639_c_());
        this.transformerModel("block/connector/transformer_mv", IEBlocks.Connectors.transformer);
        this.transformerModel("block/connector/transformer_hv", IEBlocks.Connectors.transformerHV);
        this.createConnector(IEBlocks.Connectors.postTransformer, IEDataGenerator.rl("block/connector/transformer_post.obj"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228639_c_());
        ResourceLocation ctModel = IEDataGenerator.rl("block/connector/e_meter.obj");
        this.createConnectorWithCustomModel(IEBlocks.Connectors.currentTransformer, map -> Pair.of((Object)ctModel, (Object)this.split(this.forGuessedLoader(ctModel), (List<Vector3i>)ImmutableList.of((Object)BlockPos.field_177992_a, (Object)new BlockPos(0, -1, 0)))), s -> ImmutableMap.of((Object)"particle", (Object)new ResourceLocation(DataGenUtils.getTextureFromObj(ctModel, this.existingFileHelper))), (List<Property<?>>)ImmutableList.of((Object)((Object)IEProperties.MULTIBLOCKSLAVE)), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.MetalDevices.razorWire, IEDataGenerator.rl("block/razor_wire.obj.ie"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Cloth.balloon, (VariantBlockStateBuilder.PartialBlockstate map) -> IEDataGenerator.rl("block/balloon.obj.ie"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), (List<Property<?>>)ImmutableList.of(), RenderType.func_228645_f_());
    }

    private void transformerModel(String baseName, Block transformer) {
        ResourceLocation leftModel = IEDataGenerator.rl(baseName + "_left.obj");
        ResourceLocation rightModel = IEDataGenerator.rl(baseName + "_right.obj");
        this.createConnectorWithCustomModel(transformer, state -> {
            ResourceLocation modelLoc = state.getSetStates().get((Object)IEProperties.MIRRORED) == Boolean.FALSE ? leftModel : rightModel;
            JsonObject baseModel = this.forGuessedLoader(modelLoc);
            return Pair.of((Object)modelLoc, (Object)this.split(baseModel, COLUMN_THREE));
        }, s -> ImmutableMap.of((Object)"particle", (Object)new ResourceLocation(DataGenUtils.getTextureFromObj(leftModel, this.existingFileHelper))), (List<Property<?>>)ImmutableList.of((Object)((Object)IEProperties.MULTIBLOCKSLAVE), (Object)((Object)IEProperties.MIRRORED)), RenderType.func_228639_c_());
    }

    private JsonObject split(JsonObject baseModel, List<Vector3i> parts) {
        JsonObject splitModel = new JsonObject();
        for (Map.Entry e : baseModel.entrySet()) {
            if ("loader".equals(e.getKey())) {
                splitModel.add("base_loader", (JsonElement)e.getValue());
                continue;
            }
            splitModel.add((String)e.getKey(), (JsonElement)e.getValue());
        }
        splitModel.addProperty("loader", SplitModelLoader.LOCATION.toString());
        splitModel.add("split_parts", (JsonElement)parts.stream().sorted().collect(POSITIONS_TO_JSON));
        splitModel.addProperty("dynamic", Boolean.valueOf(false));
        return splitModel;
    }

    private void createMetalMultiblocks() {
        this.createMultiblock(IEBlocks.Multiblocks.sawmill, (ModelFile)this.splitOBJ("block/metal_multiblock/sawmill.obj", IEMultiblocks.SAWMILL), (ModelFile)this.splitOBJ("block/metal_multiblock/sawmill_mirrored.obj", (TemplateMultiblock)IEMultiblocks.SAWMILL, true));
        this.createMultiblock(IEBlocks.Multiblocks.excavator, (ModelFile)this.splitOBJ("block/metal_multiblock/excavator.obj", IEMultiblocks.EXCAVATOR), (ModelFile)this.splitOBJ("block/metal_multiblock/excavator_mirrored.obj", (TemplateMultiblock)IEMultiblocks.EXCAVATOR, true));
        this.createMultiblock(IEBlocks.Multiblocks.crusher, (ModelFile)this.splitOBJ("block/metal_multiblock/crusher_mirrored.obj", IEMultiblocks.CRUSHER), (ModelFile)this.splitOBJ("block/metal_multiblock/crusher.obj", (TemplateMultiblock)IEMultiblocks.CRUSHER, true));
        this.createMultiblock(IEBlocks.Multiblocks.metalPress, (ModelFile)this.splitOBJ("block/metal_multiblock/metal_press.obj", (TemplateMultiblock)IEMultiblocks.METAL_PRESS, p -> new BlockPos(p.func_177952_p() + 1, p.func_177956_o(), p.func_177958_n() - 1)));
        this.createMultiblock(IEBlocks.Multiblocks.assembler, (ModelFile)this.splitOBJ("block/metal_multiblock/assembler.obj", IEMultiblocks.ASSEMBLER));
        this.createMultiblock(IEBlocks.Multiblocks.arcFurnace, (ModelFile)this.splitOBJ("block/metal_multiblock/arc_furnace.obj", IEMultiblocks.ARC_FURNACE), (ModelFile)this.splitOBJ("block/metal_multiblock/arc_furnace_mirrored.obj", (TemplateMultiblock)IEMultiblocks.ARC_FURNACE, true));
        this.createMultiblock(IEBlocks.Multiblocks.blastFurnaceAdv, (ModelFile)this.splitOBJ("block/blastfurnace_advanced.obj", IEMultiblocks.ADVANCED_BLAST_FURNACE));
        this.createMultiblock(IEBlocks.Multiblocks.silo, (ModelFile)this.splitOBJ("block/metal_multiblock/silo.obj", IEMultiblocks.SILO));
        this.createMultiblock(IEBlocks.Multiblocks.tank, (ModelFile)this.splitOBJ("block/metal_multiblock/tank.obj", IEMultiblocks.SHEETMETAL_TANK));
        this.createMultiblock(IEBlocks.Multiblocks.bottlingMachine, (ModelFile)this.splitIEOBJ("block/metal_multiblock/bottling_machine.obj.ie", IEMultiblocks.BOTTLING_MACHINE, false), (ModelFile)this.splitIEOBJ("block/metal_multiblock/bottling_machine_mirrored.obj.ie", IEMultiblocks.BOTTLING_MACHINE, true));
        this.createMultiblock(IEBlocks.Multiblocks.fermenter, (ModelFile)this.splitOBJ("block/metal_multiblock/fermenter.obj", IEMultiblocks.FERMENTER), (ModelFile)this.splitOBJ("block/metal_multiblock/fermenter_mirrored.obj", (TemplateMultiblock)IEMultiblocks.FERMENTER, true));
        this.createMultiblock(IEBlocks.Multiblocks.squeezer, (ModelFile)this.splitOBJ("block/metal_multiblock/squeezer.obj", IEMultiblocks.SQUEEZER), (ModelFile)this.splitOBJ("block/metal_multiblock/squeezer_mirrored.obj", (TemplateMultiblock)IEMultiblocks.SQUEEZER, true));
        this.createMultiblock(IEBlocks.Multiblocks.mixer, (ModelFile)this.splitOBJ("block/metal_multiblock/mixer.obj", IEMultiblocks.MIXER), (ModelFile)this.splitOBJ("block/metal_multiblock/mixer_mirrored.obj", (TemplateMultiblock)IEMultiblocks.MIXER, true));
        this.createMultiblock(IEBlocks.Multiblocks.refinery, (ModelFile)this.splitOBJ("block/metal_multiblock/refinery.obj", IEMultiblocks.REFINERY), (ModelFile)this.splitOBJ("block/metal_multiblock/refinery_mirrored.obj", (TemplateMultiblock)IEMultiblocks.REFINERY, true));
        this.createMultiblock(IEBlocks.Multiblocks.dieselGenerator, (ModelFile)this.splitOBJ("block/metal_multiblock/diesel_generator.obj", IEMultiblocks.DIESEL_GENERATOR), (ModelFile)this.splitOBJ("block/metal_multiblock/diesel_generator_mirrored.obj", (TemplateMultiblock)IEMultiblocks.DIESEL_GENERATOR, true));
        this.createMultiblock(IEBlocks.Multiblocks.lightningrod, (ModelFile)this.splitOBJ("block/metal_multiblock/lightningrod.obj", IEMultiblocks.LIGHTNING_ROD));
        this.createMultiblock(IEBlocks.WoodenDevices.workbench, (ModelFile)this.splitIEOBJ("block/wooden_device/workbench.obj.ie", (List<Vector3i>)ImmutableList.of((Object)ModWorkbenchTileEntity.MASTER_POS, (Object)ModWorkbenchTileEntity.DUMMY_POS)), null, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, null, 180);
        this.createMultiblock(IEBlocks.MetalDevices.sampleDrill, (ModelFile)this.splitOBJ("block/metal_device/core_drill.obj", (List<Vector3i>)ImmutableList.of((Object)BlockPos.field_177992_a, (Object)BlockPos.field_177992_a.func_177984_a(), (Object)BlockPos.field_177992_a.func_177981_b(2))), null, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, null, 180);
        this.createMultiblock(IEBlocks.Multiblocks.autoWorkbench, (ModelFile)this.splitOBJ("block/metal_multiblock/auto_workbench.obj", IEMultiblocks.AUTO_WORKBENCH), (ModelFile)this.splitOBJ("block/metal_multiblock/auto_workbench_mirrored.obj", (TemplateMultiblock)IEMultiblocks.AUTO_WORKBENCH, true), (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, IEProperties.MIRRORED, 180);
    }

    private void createStoneMultiblocks() {
        this.blastFurnaceOff = this.cubeThree("blast_furnace_off", this.modLoc("block/multiblocks/blast_furnace"), this.modLoc("block/multiblocks/blast_furnace_off"));
        this.blastFurnaceOn = this.cubeThree("blast_furnace_on", this.modLoc("block/multiblocks/blast_furnace"), this.modLoc("block/multiblocks/blast_furnace_on"));
        this.cokeOvenOff = this.cubeThree("coke_oven_off", this.modLoc("block/multiblocks/coke_oven"), this.modLoc("block/multiblocks/coke_oven_off"));
        this.cokeOvenOn = this.cubeThree("coke_oven_on", this.modLoc("block/multiblocks/coke_oven"), this.modLoc("block/multiblocks/coke_oven_on"));
        this.alloySmelterOff = this.cubeTwo("alloy_smelter_off", this.modLoc("block/multiblocks/alloy_smelter_top"), this.modLoc("block/multiblocks/alloy_smelter_bottom"), this.modLoc("block/multiblocks/alloy_smelter_side"), this.modLoc("block/multiblocks/alloy_smelter_off"));
        this.alloySmelterOn = this.cubeTwo("alloy_smelter_on", this.modLoc("block/multiblocks/alloy_smelter_top"), this.modLoc("block/multiblocks/alloy_smelter_bottom"), this.modLoc("block/multiblocks/alloy_smelter_side"), this.modLoc("block/multiblocks/alloy_smelter_on"));
        this.createMultiblock(IEBlocks.Multiblocks.cokeOven, this.cokeOvenOff, this.cokeOvenOn, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, IEProperties.ACTIVE, 180);
        this.createMultiblock(IEBlocks.Multiblocks.alloySmelter, this.alloySmelterOff, this.alloySmelterOn, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, IEProperties.ACTIVE, 180);
        this.createMultiblock(IEBlocks.Multiblocks.blastFurnace, this.blastFurnaceOff, this.blastFurnaceOn, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, IEProperties.ACTIVE, 180);
    }

    private void createMultistateSingleModel(Block block, ConfiguredModel model) {
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{model});
    }

    private void createPump() {
        VariantBlockStateBuilder builder = this.getVariantBuilder(IEBlocks.MetalDevices.fluidPump);
        builder.partialState().with((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel(this.obj("block/metal_device/fluid_pump.obj"), 0, 0, false)});
        builder.partialState().with((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.loadedModels.getBuilder("metal_device/pump_bottom").loader(ModelConfigurableSides.Loader.NAME).additional("type", "side_vertical").additional("base_name", this.modLoc("block/metal_device/fluid_pump")))});
    }

    private void createRotatedBlock(Block block, Function<VariantBlockStateBuilder.PartialBlockstate, ModelFile> model, Property<Direction> facing, List<Property<?>> additionalProps) {
        this.createRotatedBlock(block, model, facing, additionalProps, 0, 180);
    }

    private void createRotatedBlock(Block block, Function<VariantBlockStateBuilder.PartialBlockstate, ModelFile> model, Property<Direction> facing, List<Property<?>> additionalProps, int offsetRotX, int offsetRotY) {
        VariantBlockStateBuilder stateBuilder = this.getVariantBuilder(block);
        this.forEachState(stateBuilder.partialState(), additionalProps, state -> {
            ModelFile modelLoc = (ModelFile)model.apply((VariantBlockStateBuilder.PartialBlockstate)state);
            for (Direction d : facing.func_177700_c()) {
                int y;
                int x;
                switch (d) {
                    case UP: {
                        x = 90;
                        y = 0;
                        break;
                    }
                    case DOWN: {
                        x = -90;
                        y = 0;
                        break;
                    }
                    default: {
                        y = this.getAngle(d, offsetRotY);
                        x = 0;
                    }
                }
                state.with(facing, (Comparable)d).setModels(new ConfiguredModel[]{new ConfiguredModel(modelLoc, x + offsetRotX, y, false)});
            }
        });
    }

    private void createMultiblock(Block b, ModelFile masterModel, ModelFile mirroredModel, int rotationOffset) {
        this.createMultiblock(b, masterModel, mirroredModel, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, IEProperties.MIRRORED, rotationOffset);
    }

    private void createMultiblock(Block b, ModelFile masterModel, ModelFile mirroredModel) {
        this.createMultiblock(b, masterModel, mirroredModel, 180);
    }

    private void createMultiblock(Block b, ModelFile masterModel) {
        this.createMultiblock(b, masterModel, null, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, null, 180);
    }

    private void createMultiblock(Block b, ModelFile masterModel, @Nullable ModelFile mirroredModel, EnumProperty<Direction> facing, @Nullable Property<Boolean> mirroredState, int rotationOffset) {
        Preconditions.checkArgument((mirroredModel == null == (mirroredState == null) ? 1 : 0) != 0);
        VariantBlockStateBuilder builder = this.getVariantBuilder(b);
        boolean[] possibleMirrorStates = mirroredState != null ? new boolean[]{false, true} : new boolean[1];
        for (boolean mirrored : possibleMirrorStates) {
            for (Direction dir : facing.func_177700_c()) {
                int angleY;
                int angleX;
                if (facing.func_177700_c().contains(Direction.UP)) {
                    angleX = -90 * dir.func_96559_d();
                    angleY = dir.func_176740_k() != Direction.Axis.Y ? this.getAngle(dir, rotationOffset) : 0;
                } else {
                    angleY = this.getAngle(dir, rotationOffset);
                    angleX = 0;
                }
                ModelFile model = mirrored ? mirroredModel : masterModel;
                VariantBlockStateBuilder.PartialBlockstate partialState = builder.partialState().with(facing, (Comparable)dir);
                if (mirroredState != null) {
                    partialState = partialState.with(mirroredState, (Comparable)Boolean.valueOf(mirrored));
                }
                partialState.setModels(new ConfiguredModel[]{new ConfiguredModel(model, angleX, angleY, true)});
            }
        }
    }

    private int getAngle(Direction dir, int offset) {
        return (int)((dir.func_185119_l() + (float)offset) % 360.0f);
    }

    public ModelFile createMetalLadder(String name, @Nullable ResourceLocation bottomTop, @Nullable ResourceLocation sides) {
        ResourceLocation parent;
        HashMap<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();
        if (bottomTop != null) {
            Preconditions.checkNotNull((Object)sides);
            parent = new ResourceLocation("immersiveengineering", "block/ie_scaffoldladder");
            textures.put("top", bottomTop);
            textures.put("bottom", bottomTop);
            textures.put("side", sides);
        } else {
            parent = new ResourceLocation("immersiveengineering", "block/ie_ladder");
        }
        textures.put("ladder", IEDataGenerator.rl("block/metal_decoration/metal_ladder"));
        LoadedModelBuilder ret = this.loadedModels.withExistingParent(name, parent);
        if (bottomTop != null) {
            ret.transforms(IEDataGenerator.rl("item/block"));
        }
        for (Map.Entry e : textures.entrySet()) {
            ret.texture((String)e.getKey(), (ResourceLocation)e.getValue());
        }
        return ret;
    }

    private void createDirectionalBlock(Block b, Property<Direction> prop, ModelFile model) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(b);
        for (Direction d : DirectionUtils.BY_HORIZONTAL_INDEX) {
            builder.partialState().with(prop, (Comparable)d).setModels(new ConfiguredModel[]{new ConfiguredModel(model, 0, this.getAngle(d, 180), true)});
        }
    }

    private void createWallmount(Block b, ResourceLocation texture) {
        VariantBlockStateBuilder stateBuilder = this.getVariantBuilder(b);
        for (Direction d : DirectionUtils.BY_HORIZONTAL_INDEX) {
            int rotation = this.getAngle(d, 0);
            for (WallmountBlock.Orientation or : WallmountBlock.Orientation.values()) {
                ResourceLocation modelLoc = IEDataGenerator.rl("block/wooden_device/wallmount" + or.modelSuffix() + ".obj");
                ModelFile model = this.obj(b.getRegistryName().func_110623_a() + or.modelSuffix(), modelLoc, (Map<String, ResourceLocation>)ImmutableMap.of((Object)"texture", (Object)texture));
                stateBuilder.partialState().with((Property)IEProperties.FACING_HORIZONTAL, (Comparable)d).with(WallmountBlock.ORIENTATION, (Comparable)((Object)or)).setModels(new ConfiguredModel[]{new ConfiguredModel(model, 0, rotation, true)});
            }
        }
    }

    private <T extends Comparable<T>> void forEach(VariantBlockStateBuilder.PartialBlockstate base, Property<T> prop, List<Property<?>> remaining, Consumer<VariantBlockStateBuilder.PartialBlockstate> out) {
        for (Comparable value : prop.func_177700_c()) {
            this.forEachState(base, remaining, map -> {
                map = map.with(prop, value);
                out.accept((VariantBlockStateBuilder.PartialBlockstate)map);
            });
        }
    }

    private void forEachState(VariantBlockStateBuilder.PartialBlockstate base, List<Property<?>> props, Consumer<VariantBlockStateBuilder.PartialBlockstate> out) {
        if (props.size() > 0) {
            List<Property<?>> remaining = props.subList(1, props.size());
            Property<?> main = props.get(0);
            this.forEach(base, main, remaining, out);
        } else {
            out.accept(base);
        }
    }

    private void createConnectorWithCustomModel(Block b, Function<VariantBlockStateBuilder.PartialBlockstate, Pair<ResourceLocation, JsonObject>> model, Function<VariantBlockStateBuilder.PartialBlockstate, ImmutableMap<String, ResourceLocation>> textures, List<Property<?>> additional, RenderType ... layers) {
        List layersList = Arrays.stream(layers).map(this::getName).collect(Collectors.toList());
        this.createConnector(b, (VariantBlockStateBuilder.PartialBlockstate s) -> {
            Pair m = (Pair)model.apply((VariantBlockStateBuilder.PartialBlockstate)s);
            return this.forConnectorModel((VariantBlockStateBuilder.PartialBlockstate)s, (JsonObject)m.getRight(), (ImmutableMap<String, ResourceLocation>)((ImmutableMap)textures.apply((VariantBlockStateBuilder.PartialBlockstate)s)), (ResourceLocation)m.getLeft(), layersList);
        }, additional, layers);
    }

    private void createConnector(Block b, Function<VariantBlockStateBuilder.PartialBlockstate, ResourceLocation> model, Function<VariantBlockStateBuilder.PartialBlockstate, ImmutableMap<String, ResourceLocation>> textures, List<Property<?>> additional, RenderType ... layers) {
        List layersList = Arrays.stream(layers).map(this::getName).collect(Collectors.toList());
        this.createConnector(b, (VariantBlockStateBuilder.PartialBlockstate s) -> this.forConnectorModel((VariantBlockStateBuilder.PartialBlockstate)s, (ResourceLocation)model.apply((VariantBlockStateBuilder.PartialBlockstate)s), layersList, (ImmutableMap<String, ResourceLocation>)((ImmutableMap)textures.apply((VariantBlockStateBuilder.PartialBlockstate)s))), additional, layers);
    }

    private String getName(RenderState state) {
        try {
            Field f = RenderState.class.getDeclaredField("name");
            f.setAccessible(true);
            return (String)f.get(state);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createConnector(Block b, Function<VariantBlockStateBuilder.PartialBlockstate, ModelFile> toModel, List<Property<?>> additional, RenderType ... layers) {
        int xForHorizontal;
        DirectionProperty facingProp;
        Preconditions.checkArgument((layers.length > 0 ? 1 : 0) != 0);
        if (b.func_176223_P().func_235901_b_((Property)IEProperties.FACING_ALL)) {
            facingProp = IEProperties.FACING_ALL;
            xForHorizontal = 90;
        } else if (b.func_176223_P().func_235901_b_((Property)IEProperties.FACING_TOP_DOWN)) {
            facingProp = IEProperties.FACING_TOP_DOWN;
            xForHorizontal = 90;
        } else if (b.func_176223_P().func_235901_b_((Property)IEProperties.FACING_HORIZONTAL)) {
            facingProp = IEProperties.FACING_HORIZONTAL;
            xForHorizontal = 0;
        } else {
            facingProp = null;
            xForHorizontal = 0;
        }
        Preconditions.checkState((facingProp == null || b.func_176223_P().func_235901_b_((Property)facingProp) ? 1 : 0) != 0, (Object)(b + " does not have " + facingProp));
        VariantBlockStateBuilder builder = this.getVariantBuilder(b);
        this.forEachState(builder.partialState(), additional, arg_0 -> this.lambda$createConnector$33((Property)facingProp, toModel, builder, xForHorizontal, arg_0));
    }

    private JsonObject forGuessedLoader(ResourceLocation modelLoc) {
        JsonObject baseJson = new JsonObject();
        Optional<ResourceLocation> loader = this.guessLoader(modelLoc);
        if (!loader.isPresent()) {
            baseJson.addProperty("parent", this.EMPTY_MODEL.model.getLocation().toString());
        } else {
            baseJson.addProperty("loader", loader.get().toString());
            if (!FeedthroughLoader.LOCATION.equals((Object)loader.get())) {
                baseJson.addProperty("model", this.addModelsPrefix(modelLoc).toString());
                baseJson.addProperty("flip-v", Boolean.valueOf(true));
                baseJson.addProperty("detectCullableFaces", Boolean.valueOf(false));
            }
        }
        return baseJson;
    }

    private ModelFile forConnectorModel(VariantBlockStateBuilder.PartialBlockstate state, ResourceLocation modelLoc, List<String> layers, ImmutableMap<String, ResourceLocation> textures) {
        Optional<ResourceLocation> loader = this.guessLoader(modelLoc);
        if (!textures.containsKey((Object)"particle") && loader.isPresent() && loader.get().func_110623_a().contains("obj")) {
            String particleTex = DataGenUtils.getTextureFromObj(modelLoc, this.existingFileHelper);
            if (particleTex.charAt(0) == '#') {
                particleTex = ((ResourceLocation)textures.get((Object)particleTex.substring(1))).toString();
            }
            textures = ImmutableMap.builder().putAll(textures).put((Object)"particle", (Object)new ResourceLocation(particleTex)).build();
        }
        JsonObject baseJson = this.forGuessedLoader(modelLoc);
        return this.forConnectorModel(state, baseJson, textures, modelLoc, layers);
    }

    private ModelFile forConnectorModel(VariantBlockStateBuilder.PartialBlockstate state, JsonObject model, ImmutableMap<String, ResourceLocation> texForState, ResourceLocation modelLocName, List<String> layers) {
        LoadedModelBuilder ret = this.loadedModels.getBuilder(this.nameFor(state.getOwner(), modelLocName, texForState)).loader(ConnectionLoader.LOADER_NAME).additional("base_model", (JsonElement)model).additional("layers", layers);
        for (Map.Entry e : texForState.entrySet()) {
            ret.texture((String)e.getKey(), (ResourceLocation)e.getValue());
        }
        return ret;
    }

    private Optional<ResourceLocation> guessLoader(ResourceLocation modelLoc) {
        if (modelLoc.func_110623_a().endsWith(".obj")) {
            return Optional.of(this.forgeLoc("obj"));
        }
        if (modelLoc.func_110623_a().endsWith(".obj.ie")) {
            return Optional.of(this.modLoc("ie_obj"));
        }
        if (modelLoc.equals((Object)this.EMPTY_MODEL.model.getLocation())) {
            return Optional.empty();
        }
        if (modelLoc.equals((Object)FeedthroughLoader.LOCATION)) {
            return Optional.of(FeedthroughLoader.LOCATION);
        }
        throw new RuntimeException("Failed to guess loader for " + modelLoc);
    }

    private String nameFor(Block b, ResourceLocation model, ImmutableMap<String, ResourceLocation> texReplacement) {
        int index;
        Map<Map<String, ResourceLocation>, Integer> namesForModel;
        String base;
        String modelPath = model.func_110623_a();
        String blockName = b.getRegistryName().func_110623_a();
        if (modelPath.endsWith(".obj")) {
            base = modelPath.substring(0, modelPath.length() - 4);
        } else if (modelPath.endsWith(".obj.ie")) {
            base = modelPath.substring(0, modelPath.length() - 7);
        } else if (FeedthroughLoader.LOCATION.equals((Object)model)) {
            base = "feedthrough";
        } else if (this.EMPTY_MODEL.model.getLocation().equals((Object)model)) {
            base = blockName + "_empty";
        } else {
            throw new RuntimeException("Unknown model type: " + model);
        }
        if (!this.nameCache.containsKey(base)) {
            this.nameCache.put(base, new HashMap());
        }
        if ((namesForModel = this.nameCache.get(base)).containsKey(texReplacement)) {
            index = namesForModel.get(texReplacement);
        } else {
            index = namesForModel.size();
            namesForModel.put((Map<String, ResourceLocation>)texReplacement, index);
        }
        if (index == 0) {
            return base;
        }
        return base + "_" + index;
    }

    private void createConnector(Block b, Function<VariantBlockStateBuilder.PartialBlockstate, ResourceLocation> model, ImmutableMap<String, ResourceLocation> textures, List<Property<?>> additional, RenderType ... layers) {
        this.createConnector(b, model, (VariantBlockStateBuilder.PartialBlockstate state) -> textures, additional, layers);
    }

    private void createConnector(Block b, ResourceLocation model, ImmutableMap<String, ResourceLocation> textures, RenderType ... layers) {
        this.createConnector(b, (VariantBlockStateBuilder.PartialBlockstate map) -> model, textures, (List<Property<?>>)ImmutableList.of(), layers);
    }

    private ModelFile quarter(String out, ResourceLocation texture) {
        return ((BlockModelBuilder)this.models().withExistingParent(out, this.modLoc("block/ie_quarter_block"))).texture("texture", texture);
    }

    private ModelFile threeQuarter(String out, ResourceLocation texture) {
        return ((BlockModelBuilder)this.models().withExistingParent(out, this.modLoc("block/ie_three_quarter_block"))).texture("texture", texture);
    }

    private void createHemp() {
        VariantBlockStateBuilder builder = this.getVariantBuilder(IEBlocks.Misc.hempPlant);
        for (EnumHempGrowth g : EnumHempGrowth.values()) {
            ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent("block/hemp/" + g.func_176610_l(), new ResourceLocation("block/crop"))).texture("crop", g.getTextureName());
            builder.partialState().with(HempBlock.GROWTH, (Comparable)((Object)g)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        }
    }

    private void createSawdust() {
        VariantBlockStateBuilder builder = this.getVariantBuilder(IEBlocks.WoodenDecoration.sawdust);
        ResourceLocation sawdustTexture = new ResourceLocation("immersiveengineering", "block/wooden_decoration/sawdust");
        ModelBuilder singleModel = null;
        Iterator iterator = SawdustBlock.LAYERS.func_177700_c().iterator();
        while (iterator.hasNext()) {
            ModelBuilder model;
            int layer = (Integer)iterator.next();
            String name = "block/sawdust_" + layer;
            if (layer == 9) {
                model = this.models().cubeAll(name, sawdustTexture);
            } else {
                int height = layer * 2 - 1;
                model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("block/thin_block"))).texture("particle", sawdustTexture)).texture("texture", sawdustTexture)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, (float)height, 16.0f).allFaces((direction, faceBuilder) -> {
                    if (direction.func_176740_k() == Direction.Axis.Y) {
                        faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#texture");
                    } else {
                        faceBuilder.uvs(0.0f, (float)(16 - height), 16.0f, 16.0f).texture("#texture").cullface(direction);
                    }
                    if (direction != Direction.UP) {
                        faceBuilder.cullface(direction);
                    }
                }).end();
            }
            if (layer == 1) {
                singleModel = model;
            }
            builder.partialState().with((Property)SawdustBlock.LAYERS, (Comparable)Integer.valueOf(layer)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        }
        this.itemModels.put(IEBlocks.WoodenDecoration.sawdust, (ModelFile)singleModel);
    }

    private ModelFile createRouterModel(ResourceLocation baseTexName, String outName) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent(outName, this.modLoc("block/ie_six_sides"));
        for (Direction d : DirectionUtils.VALUES) {
            builder.texture(d.func_176610_l(), new ResourceLocation(baseTexName.func_110624_b(), baseTexName.func_110623_a() + "_" + d.ordinal()));
        }
        builder.texture("particle", new ResourceLocation(baseTexName.func_110624_b(), baseTexName.func_110623_a() + "_0"));
        return builder;
    }

    public void assertModelExists(ResourceLocation name) {
        String suffix = name.func_110623_a().contains(".") ? "" : ".json";
        Preconditions.checkState((boolean)this.existingFileHelper.exists(name, ResourcePackType.CLIENT_RESOURCES, suffix, "models"), (Object)("Model \"" + name + "\" does not exist"));
    }

    private /* synthetic */ void lambda$createConnector$33(Property facingProp, Function toModel, VariantBlockStateBuilder builder, int xForHorizontal, VariantBlockStateBuilder.PartialBlockstate map) {
        if (facingProp != null) {
            for (Direction d : facingProp.func_177700_c()) {
                if (d == Direction.DOWN) {
                    VariantBlockStateBuilder.PartialBlockstate downState = map.with(facingProp, (Comparable)Direction.DOWN);
                    ModelFile downModel = (ModelFile)toModel.apply(downState);
                    builder.setModels(downState, new ConfiguredModel[]{new ConfiguredModel(downModel, xForHorizontal - 90, 0, true)});
                    continue;
                }
                if (d == Direction.UP) {
                    VariantBlockStateBuilder.PartialBlockstate upState = map.with(facingProp, (Comparable)Direction.UP);
                    ModelFile upModel = (ModelFile)toModel.apply(upState);
                    builder.setModels(upState, new ConfiguredModel[]{new ConfiguredModel(upModel, xForHorizontal + 90, 0, true)});
                    continue;
                }
                int rotation = this.getAngle(d, 0);
                VariantBlockStateBuilder.PartialBlockstate dState = map.with(facingProp, (Comparable)d);
                ModelFile connFile = (ModelFile)toModel.apply(dState);
                builder.setModels(dState, new ConfiguredModel[]{new ConfiguredModel(connFile, xForHorizontal, rotation, true)});
            }
        } else {
            ModelFile connFile = (ModelFile)toModel.apply(map);
            builder.setModels(map, new ConfiguredModel[]{new ConfiguredModel(connFile, 0, 0, true)});
        }
    }

    private static /* synthetic */ ModelFile lambda$registerStatesAndModels$17(ModelFile full, VariantBlockStateBuilder.PartialBlockstate state) {
        return full;
    }

    private static /* synthetic */ ModelFile lambda$registerStatesAndModels$16(ModelFile kineticDynamo, VariantBlockStateBuilder.PartialBlockstate state) {
        return kineticDynamo;
    }

    private static /* synthetic */ ModelFile lambda$registerStatesAndModels$15(ModelFile furnaceHeaterOn, ModelFile furnaceHeaterOff, VariantBlockStateBuilder.PartialBlockstate props) {
        if (props.getSetStates().get((Object)IEProperties.ACTIVE) == Boolean.TRUE) {
            return furnaceHeaterOn;
        }
        return furnaceHeaterOff;
    }

    private static /* synthetic */ ModelFile lambda$registerStatesAndModels$13(ModelFile batcherModel, VariantBlockStateBuilder.PartialBlockstate s) {
        return batcherModel;
    }

    private static /* synthetic */ ModelFile lambda$registerStatesAndModels$10(ModelFile turntableModel, VariantBlockStateBuilder.PartialBlockstate s) {
        return turntableModel;
    }

    private static /* synthetic */ Vector3i lambda$splitIEOBJ$9(Vector3i offset, BlockPos p) {
        return p.func_177973_b(offset);
    }

    private static /* synthetic */ Vector3i lambda$splitOBJ$5(Vector3i offset, BlockPos p) {
        return p.func_177973_b(offset);
    }
}

