/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.SawmillRecipe;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;

public class SawmillRecipeSerializer
extends IERecipeSerializer<SawmillRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)IEBlocks.Multiblocks.sawmill);
    }

    @Override
    public SawmillRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        ItemStack output = this.readOutput(json.get("result"));
        Ingredient input = Ingredient.func_199802_a((JsonElement)json.get("input"));
        ItemStack stripped = ItemStack.field_190927_a;
        if (json.has("stripped")) {
            stripped = this.readOutput(json.get("stripped"));
        }
        JsonArray array = json.getAsJsonArray("secondaries");
        int energy = JSONUtils.func_151203_m((JsonObject)json, (String)"energy");
        SawmillRecipe recipe = IEServerConfig.MACHINES.sawmillConfig.apply(new SawmillRecipe(recipeId, output, stripped, input, energy));
        for (int i = 0; i < array.size(); ++i) {
            JsonObject element = array.get(i).getAsJsonObject();
            if (!CraftingHelper.processConditions((JsonObject)element, (String)"conditions")) continue;
            boolean stripping = JSONUtils.func_151212_i((JsonObject)element, (String)"stripping");
            ItemStack stack = this.readOutput(element.get("output"));
            if (stripping) {
                recipe.addToSecondaryStripping(stack);
                continue;
            }
            recipe.addToSecondaryOutput(stack);
        }
        return recipe;
    }

    @Nullable
    public SawmillRecipe read(@Nonnull ResourceLocation recipeId, PacketBuffer buffer) {
        int i;
        ItemStack output = buffer.func_150791_c();
        ItemStack stripped = buffer.func_150791_c();
        Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
        int energy = buffer.readInt();
        SawmillRecipe recipe = new SawmillRecipe(recipeId, output, stripped, input, energy);
        int secondaryCount = buffer.readInt();
        for (i = 0; i < secondaryCount; ++i) {
            recipe.addToSecondaryStripping(buffer.func_150791_c());
        }
        secondaryCount = buffer.readInt();
        for (i = 0; i < secondaryCount; ++i) {
            recipe.addToSecondaryOutput(buffer.func_150791_c());
        }
        return recipe;
    }

    public void write(PacketBuffer buffer, SawmillRecipe recipe) {
        buffer.func_150788_a(recipe.output);
        buffer.func_150788_a(recipe.stripped);
        recipe.input.func_199564_a(buffer);
        buffer.writeInt(recipe.getTotalProcessEnergy());
        buffer.writeInt(recipe.secondaryStripping.size());
        for (ItemStack secondaryOutput : recipe.secondaryStripping) {
            buffer.func_150788_a(secondaryOutput);
        }
        buffer.writeInt(recipe.secondaryOutputs.size());
        for (ItemStack secondaryOutput : recipe.secondaryOutputs) {
            buffer.func_150788_a(secondaryOutput);
        }
    }
}

