/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.fluidaware;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.common.crafting.IngredientSerializerFluidStack;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class IngredientFluidStack
extends Ingredient {
    private final FluidTagInput fluidTagInput;
    ItemStack[] cachedStacks;

    public IngredientFluidStack(FluidTagInput fluidTagInput) {
        super(Stream.empty());
        this.fluidTagInput = fluidTagInput;
    }

    public IngredientFluidStack(ITag.INamedTag<Fluid> tag, int amount) {
        this(new FluidTagInput(tag.func_230234_a_(), amount));
    }

    public FluidTagInput getFluidTagInput() {
        return this.fluidTagInput;
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (this.cachedStacks == null) {
            this.cachedStacks = (ItemStack[])this.fluidTagInput.getMatchingFluidStacks().stream().map(FluidUtil::getFilledBucket).toArray(ItemStack[]::new);
        }
        return this.cachedStacks;
    }

    public boolean func_203189_d() {
        return false;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Optional handler = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
        return handler.isPresent() && this.fluidTagInput.extractFrom((IFluidHandler)handler.get(), IFluidHandler.FluidAction.SIMULATE);
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return IngredientSerializerFluidStack.INSTANCE;
    }

    @Nonnull
    public JsonElement func_200304_c() {
        JsonObject ret = (JsonObject)this.fluidTagInput.serialize();
        ret.addProperty("type", IngredientSerializerFluidStack.NAME.toString());
        return ret;
    }

    public boolean isSimple() {
        return false;
    }

    public ItemStack getExtractedStack(ItemStack input) {
        Optional handlerOpt = FluidUtil.getFluidHandler((ItemStack)input).resolve();
        if (handlerOpt.isPresent()) {
            IFluidHandlerItem handler = (IFluidHandlerItem)handlerOpt.get();
            this.fluidTagInput.extractFrom((IFluidHandler)handler, IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }
        return input;
    }
}

