/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class JerrycanRefillRecipe
extends SpecialRecipe {
    private final int jerrycanIndex = 0;
    private final int containerIndex = 1;

    public JerrycanRefillRecipe(ResourceLocation resourceLocation) {
        super(resourceLocation);
    }

    public boolean matches(@Nonnull CraftingInventory inv, World world) {
        FluidStack jerrycanFluid;
        ItemStack[] components = this.getComponents((IInventory)inv);
        if (!(components[0].func_190926_b() || components[1].func_190926_b() || (jerrycanFluid = (FluidStack)FluidUtil.getFluidContained((ItemStack)components[0]).orElseThrow(RuntimeException::new)).isEmpty())) {
            IFluidHandler handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)components[1]).orElseThrow(RuntimeException::new);
            FluidStack containerFluid = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
            return containerFluid.getAmount() < handler.getTankCapacity(0) && handler.isFluidValid(0, jerrycanFluid);
        }
        return false;
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        ItemStack[] components = this.getComponents((IInventory)inv);
        ItemStack newContainer = Utils.copyStackWithAmount(components[1], 1);
        IFluidHandlerItem handler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)newContainer).orElseThrow(RuntimeException::new);
        ItemNBTHelper.putInt(components[0], "jerrycanDrain", handler.fill((FluidStack)FluidUtil.getFluidContained((ItemStack)components[0]).orElseThrow(RuntimeException::new), IFluidHandler.FluidAction.EXECUTE));
        newContainer = handler.getContainer();
        return newContainer;
    }

    private ItemStack[] getComponents(IInventory inv) {
        ItemStack[] ret = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a};
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            if (ret[0].func_190926_b() && IEItems.Misc.jerrycan.equals(stackInSlot.func_77973_b()) && FluidUtil.getFluidContained((ItemStack)stackInSlot) != null) {
                ret[0] = stackInSlot;
                continue;
            }
            if (ret[1].func_190926_b() && FluidUtil.getFluidHandler((ItemStack)stackInSlot).isPresent()) {
                ret[1] = stackInSlot;
                continue;
            }
            return ret;
        }
        return ret;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList remaining = super.func_179532_b((IInventory)inv);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (FluidUtil.getFluidHandler((ItemStack)inv.func_70301_a(i)) == null) continue;
            remaining.set(i, (Object)ItemStack.field_190927_a);
            break;
        }
        return remaining;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeSerializers.JERRYCAN_REFILL.get();
    }
}

