/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.common.data.IEDataGenerator;
import blusunrize.immersiveengineering.common.network.MessageMultiblockSync;
import blusunrize.immersiveengineering.common.util.IELogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.resources.IResource;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.fml.packs.ResourcePackLoader;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="immersiveengineering")
public class StaticTemplateManager {
    public static Map<ResourceLocation, Template> SYNCED_CLIENT_TEMPLATES = new HashMap<ResourceLocation, Template>();

    private static Optional<InputStream> getModResource(ResourcePackType type, ResourceLocation name, @Nullable MinecraftServer server) {
        if (IEDataGenerator.EXISTING_HELPER != null) {
            try {
                int slash = name.func_110623_a().indexOf(47);
                String prefix = name.func_110623_a().substring(0, slash);
                ResourceLocation shortLoc = new ResourceLocation(name.func_110624_b(), name.func_110623_a().substring(slash + 1));
                return Optional.of(IEDataGenerator.EXISTING_HELPER.getResource(shortLoc, type, "", prefix).func_199027_b());
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
        if (server != null) {
            try {
                IResource resource = server.getDataPackRegistries().func_240970_h_().func_199002_a(name);
                return Optional.of(resource.func_199027_b());
            }
            catch (IOException x) {
                return Optional.empty();
            }
        }
        IELogger.error("Falling back to mod resource packs for resource {}", name);
        return ModList.get().getMods().stream().map(ModInfo::getModId).map(ResourcePackLoader::getResourcePackFor).filter(Optional::isPresent).map(Optional::get).filter(mfrp -> mfrp.func_195764_b(type, name)).map(mfrp -> StaticTemplateManager.getInputStreamOrThrow(type, name, mfrp)).findAny();
    }

    private static InputStream getInputStreamOrThrow(ResourcePackType type, ResourceLocation name, ModFileResourcePack source) {
        try {
            return source.func_195761_a(type, name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Template loadStaticTemplate(ResourceLocation loc, @Nullable MinecraftServer server) throws IOException {
        if (server == null && IEDataGenerator.EXISTING_HELPER == null) {
            return Objects.requireNonNull(SYNCED_CLIENT_TEMPLATES.get(loc));
        }
        String path = "structures/" + loc.func_110623_a() + ".nbt";
        Optional<InputStream> optStream = StaticTemplateManager.getModResource(ResourcePackType.SERVER_DATA, new ResourceLocation(loc.func_110624_b(), path), server);
        if (optStream.isPresent()) {
            return StaticTemplateManager.loadTemplate(optStream.get());
        }
        throw new RuntimeException("Mod resource not found: " + loc);
    }

    private static Template loadTemplate(InputStream inputStreamIn) throws IOException {
        CompoundNBT compoundnbt = CompressedStreamTools.func_74796_a((InputStream)inputStreamIn);
        Template template = new Template();
        template.func_186256_b(compoundnbt);
        return template;
    }

    public static void syncMultiblockTemplates(PacketDistributor.PacketTarget target, boolean resetMBs) {
        ArrayList<MessageMultiblockSync.SyncedTemplate> toSync = new ArrayList<MessageMultiblockSync.SyncedTemplate>();
        for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
            if (!(mb instanceof TemplateMultiblock)) continue;
            TemplateMultiblock templateMB = (TemplateMultiblock)mb;
            if (resetMBs) {
                templateMB.reset();
            }
            Template template = templateMB.getTemplate(ServerLifecycleHooks.getCurrentServer());
            ResourceLocation rl = templateMB.getTemplateLocation();
            toSync.add(new MessageMultiblockSync.SyncedTemplate(template, rl));
        }
        ImmersiveEngineering.packetHandler.send(target, (Object)new MessageMultiblockSync(toSync));
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent ev) {
        StaticTemplateManager.syncMultiblockTemplates(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)ev.getEntityLiving()), false);
    }
}

