/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.ModelConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.BasicConveyor;
import blusunrize.immersiveengineering.common.util.CapabilityReference;
import blusunrize.immersiveengineering.common.util.SafeChunkUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SplitConveyor
extends BasicConveyor {
    public static final ResourceLocation NAME = new ResourceLocation("immersiveengineering", "splitter");
    boolean nextOutputLeft = true;
    public static ResourceLocation texture_on = new ResourceLocation("immersiveengineering:block/conveyor/split");
    public static ResourceLocation texture_off = new ResourceLocation("immersiveengineering:block/conveyor/split_off");
    public static ResourceLocation texture_casing = new ResourceLocation("immersiveengineering:block/conveyor/split_wall");

    public SplitConveyor(TileEntity tile) {
        super(tile);
    }

    @Override
    public ConveyorHandler.ConveyorDirection getConveyorDirection() {
        return ConveyorHandler.ConveyorDirection.HORIZONTAL;
    }

    @Override
    public boolean changeConveyorDirection() {
        return false;
    }

    @Override
    public boolean setConveyorDirection(ConveyorHandler.ConveyorDirection dir) {
        return false;
    }

    @Override
    public void handleInsertion(ItemEntity entity, ConveyorHandler.ConveyorDirection conDir, double distX, double distZ) {
        String nbtKey = "immersiveengineering:conveyorDir" + Integer.toHexString(this.getTile().func_174877_v().hashCode());
        if (entity.getPersistentData().func_150297_b(nbtKey, 3) && !this.getTile().func_145831_w().field_72995_K) {
            ItemStack stack;
            Direction redirect = Direction.values()[entity.getPersistentData().func_74762_e(nbtKey)];
            BlockPos nextPos = this.getTile().func_174877_v().func_177972_a(redirect);
            double distNext = Math.abs((double)(redirect.func_176740_k() == Direction.Axis.Z ? nextPos.func_177952_p() : nextPos.func_177958_n()) + 0.5 - (redirect.func_176740_k() == Direction.Axis.Z ? entity.func_226281_cx_() : entity.func_226277_ct_()));
            TileEntity inventoryTile = this.getTile().func_145831_w().func_175625_s(nextPos);
            if (distNext < 0.7 && inventoryTile != null && !(inventoryTile instanceof ConveyorHandler.IConveyorTile) && !(stack = entity.func_92059_d()).func_190926_b()) {
                CapabilityReference<IItemHandler> insert = CapabilityReference.forNeighbor(this.getTile(), CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, redirect);
                ItemStack ret = Utils.insertStackIntoInventory(insert, stack, false);
                if (ret.func_190926_b()) {
                    entity.func_70106_y();
                } else if (ret.func_190916_E() < stack.func_190916_E()) {
                    entity.func_92058_a(ret);
                }
            }
        }
    }

    @Override
    public void onEntityCollision(@Nonnull Entity entity) {
        BlockPos nextPos;
        String nbtKey;
        if (!this.isActive()) {
            return;
        }
        Direction redirect = null;
        if (entity.func_70089_S()) {
            nbtKey = "immersiveengineering:conveyorDir" + Integer.toHexString(this.getTile().func_174877_v().hashCode());
            if (entity.getPersistentData().func_150297_b(nbtKey, 3)) {
                redirect = Direction.values()[entity.getPersistentData().func_74762_e(nbtKey)];
            } else {
                redirect = this.getOutputFace();
                entity.getPersistentData().func_74768_a(nbtKey, redirect.ordinal());
                nextPos = this.getTile().func_174877_v().func_177972_a(this.getOutputFace().func_176734_d());
                if (this.getTile().func_145831_w().func_175667_e(nextPos)) {
                    TileEntity nextTile = this.getTile().func_145831_w().func_175625_s(nextPos);
                    if (!(nextTile instanceof ConveyorHandler.IConveyorTile)) {
                        this.nextOutputLeft = !this.nextOutputLeft;
                    } else if (((ConveyorHandler.IConveyorTile)nextTile).getFacing() != this.getOutputFace()) {
                        this.nextOutputLeft = !this.nextOutputLeft;
                    }
                }
            }
        }
        super.onEntityCollision(entity);
        if (redirect != null) {
            boolean contact;
            nbtKey = "immersiveengineering:conveyorDir" + Integer.toHexString(this.getTile().func_174877_v().hashCode());
            nextPos = this.getTile().func_174877_v().func_177972_a(redirect);
            double distNext = Math.abs((double)(redirect.func_176740_k() == Direction.Axis.Z ? nextPos.func_177952_p() : nextPos.func_177958_n()) + 0.5 - (redirect.func_176740_k() == Direction.Axis.Z ? entity.func_226281_cx_() : entity.func_226277_ct_()));
            double treshold = 0.4;
            boolean bl = contact = distNext < treshold;
            if (contact) {
                entity.getPersistentData().func_82580_o(nbtKey);
            }
        }
    }

    @Override
    public boolean renderWall(Direction facing, int wall) {
        return false;
    }

    @Override
    public Direction[] sigTransportDirections() {
        return new Direction[]{this.getFacing().func_176746_e(), this.getFacing().func_176735_f()};
    }

    @Override
    public Vector3d getDirection(Entity entity, boolean outputBlocked) {
        Vector3d vec = super.getDirection(entity, outputBlocked);
        String nbtKey = "immersiveengineering:conveyorDir" + Integer.toHexString(this.getTile().func_174877_v().hashCode());
        if (!entity.getPersistentData().func_150297_b(nbtKey, 3)) {
            return vec;
        }
        Direction redirect = Direction.func_82600_a((int)entity.getPersistentData().func_74762_e(nbtKey));
        BlockPos wallPos = this.getTile().func_174877_v().func_177972_a(this.getFacing());
        double distNext = Math.abs((double)(this.getFacing().func_176740_k() == Direction.Axis.Z ? wallPos.func_177952_p() : wallPos.func_177958_n()) + 0.5 - (this.getFacing().func_176740_k() == Direction.Axis.Z ? entity.func_226281_cx_() : entity.func_226277_ct_()));
        if (distNext < 1.33) {
            double sideMove = Math.pow(1.0 + distNext, 0.1) * 0.2;
            if (distNext < 0.8) {
                vec = new Vector3d(this.getFacing().func_176740_k() == Direction.Axis.X ? 0.0 : vec.field_72450_a, vec.field_72448_b, this.getFacing().func_176740_k() == Direction.Axis.Z ? 0.0 : vec.field_72449_c);
            }
            vec = vec.func_72441_c((double)redirect.func_82601_c() * sideMove, 0.0, (double)redirect.func_82599_e() * sideMove);
        }
        return vec;
    }

    @Override
    public CompoundNBT writeConveyorNBT() {
        CompoundNBT nbt = super.writeConveyorNBT();
        nbt.func_74757_a("nextLeft", this.nextOutputLeft);
        return nbt;
    }

    @Override
    public void readConveyorNBT(CompoundNBT nbt) {
        super.readConveyorNBT(nbt);
        this.nextOutputLeft = nbt.func_74767_n("nextLeft");
    }

    @Override
    public ResourceLocation getActiveTexture() {
        return texture_on;
    }

    @Override
    public ResourceLocation getInactiveTexture() {
        return texture_off;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel) {
        TextureAtlasSprite tex_casing0 = ClientUtils.getSprite(texture_casing);
        Matrix4 matrix = new Matrix4(this.getFacing());
        TransformationMatrix tMatrix = matrix.toTransformationMatrix();
        float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        Vector3d[] vertices = new Vector3d[]{new Vector3d(0.0625, 0.0, 0.0), new Vector3d(0.0625, 0.0, 1.0), new Vector3d(0.9375, 0.0, 1.0), new Vector3d(0.9375, 0.0, 0.0)};
        baseModel.set(0, ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(tMatrix, vertices), Utils.rotateFacingTowardsDir(Direction.DOWN, this.getFacing()), ClientUtils.getSprite(ModelConveyor.rl_casing[3]), new double[]{1.0, 0.0, 15.0, 16.0}, colour, true));
        vertices = new Vector3d[]{new Vector3d(0.0625, 0.1875, 0.0), new Vector3d(0.0625, 0.1875, 1.0), new Vector3d(0.9375, 0.1875, 1.0), new Vector3d(0.9375, 0.1875, 0.0)};
        baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(tMatrix, vertices), Direction.UP, tex_casing0, new double[]{1.0, 16.0, 15.0, 0.0}, colour, false));
        vertices = new Vector3d[]{new Vector3d(0.0625, 0.0, 0.0), new Vector3d(0.0625, 0.1875, 0.0), new Vector3d(0.9375, 0.1875, 0.0), new Vector3d(0.9375, 0.0, 0.0)};
        baseModel.set(15, ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(tMatrix, vertices), this.getFacing(), ClientUtils.getSprite(ModelConveyor.rl_casing[1]), new double[]{1.0, 16.0, 15.0, 13.0}, colour, false));
        vertices = new Vector3d[]{new Vector3d(0.0625, 0.125, 0.0), new Vector3d(0.0625, 0.1875, 0.0), new Vector3d(0.9375, 0.1875, 0.0), new Vector3d(0.9375, 0.125, 0.0)};
        Vector3d[] vertices2 = new Vector3d[]{new Vector3d(0.5, 0.125, 0.0), new Vector3d(0.5, 0.125, 0.5), new Vector3d(0.5, 0.1875, 0.5), new Vector3d(0.5, 0.1875, 0.0)};
        Vector3d[] vertices3 = new Vector3d[]{new Vector3d(0.5, 0.125, 0.0), new Vector3d(0.5, 0.125, 0.5), new Vector3d(0.5, 0.1875, 0.5), new Vector3d(0.5, 0.1875, 0.0)};
        for (int i = 0; i < 8; ++i) {
            for (int iv = 0; iv < vertices.length; ++iv) {
                vertices[iv] = Utils.withCoordinate(vertices[iv], Direction.Axis.Z, (float)(i + 1) * 0.0625f);
                vertices2[iv] = vertices2[iv].func_72441_c(0.0625, 0.0, 0.0);
                vertices3[iv] = vertices3[iv].func_72441_c(-0.0625, 0.0, 0.0);
            }
            double v = 16 - i;
            baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(tMatrix, vertices), this.getFacing(), tex_casing0, new double[]{1.0, v - 1.0, 15.0, v}, colour, true));
            if (i >= 7) continue;
            double u = 8 - i;
            baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(tMatrix, vertices2), this.getFacing(), tex_casing0, new double[]{u - 1.0, 16.0, u, 8.0}, colour, true));
            baseModel.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176600_a, ClientUtils.applyMatrixToVertices(tMatrix, vertices3), this.getFacing(), tex_casing0, new double[]{u - 1.0, 16.0, u, 8.0}, colour, false));
        }
        super.modifyQuads(baseModel);
        return baseModel;
    }

    @Override
    public List<BlockPos> getNextConveyorCandidates() {
        BlockPos baseOutput = this.getTile().func_174877_v().func_177972_a(this.getOutputFace());
        return ImmutableList.of((Object)baseOutput, (Object)baseOutput.func_177977_b());
    }

    @Override
    public boolean isOutputBlocked() {
        Direction outputFace = this.getOutputFace();
        BlockPos here = this.getTile().func_174877_v();
        for (BlockPos outputPos : new BlockPos[]{here.func_177967_a(outputFace, 1), here.func_177967_a(outputFace, -1)}) {
            TileEntity tile = SafeChunkUtils.getSafeTE((IWorld)this.getTile().func_145831_w(), outputPos);
            if (!(tile instanceof ConveyorHandler.IConveyorTile) || !((ConveyorHandler.IConveyorTile)tile).getConveyorSubtype().isBlocked()) continue;
            return true;
        }
        return false;
    }

    private Direction getOutputFace() {
        if (this.nextOutputLeft) {
            return this.getFacing().func_176735_f();
        }
        return this.getFacing().func_176746_e();
    }
}

