/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.util.DirectionUtils;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidPlacerTileEntity
extends IEBaseTileEntity
implements ITickableTileEntity,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IBlockOverlayText {
    private final Map<Direction, IEEnums.IOSideConfig> sideConfig = new EnumMap<Direction, IEEnums.IOSideConfig>(Direction.class);
    public FluidTank tank;
    private int tickCount;
    private HashSet<BlockPos> checkedPositions;
    private TreeMap<Integer, Queue<BlockPos>> layeredPlacementQueue;
    private HashSet<BlockPos> tempFluids;
    private LazyOptional<IFluidHandler> tankCap;

    public FluidPlacerTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.FLUID_PLACER.get()));
        for (Direction d : DirectionUtils.VALUES) {
            this.sideConfig.put(d, IEEnums.IOSideConfig.OUTPUT);
        }
        this.sideConfig.put(Direction.UP, IEEnums.IOSideConfig.INPUT);
        this.tank = new FluidTank(4000);
        this.tickCount = 0;
        this.checkedPositions = new HashSet();
        this.layeredPlacementQueue = new TreeMap();
        this.tempFluids = new HashSet();
        this.tankCap = this.registerConstantCap(this.tank);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || this.isRSPowered()) {
            return;
        }
        if (this.tickCount % 16 == 0) {
            if (this.tickCount % 512 == 0) {
                this.prepareAreaCheck();
            }
            if (this.tank.getFluidAmount() >= 1000 && !this.layeredPlacementQueue.isEmpty()) {
                Queue<BlockPos> lowestLayer = this.layeredPlacementQueue.firstEntry().getValue();
                if (lowestLayer == null || lowestLayer.isEmpty()) {
                    this.layeredPlacementQueue.pollFirstEntry();
                } else {
                    BlockPos targetPos = lowestLayer.peek();
                    if (this.canFill(targetPos, false) && this.tank.getFluid().getFluid().getAttributes().canBePlacedInWorld((IBlockDisplayReader)this.field_145850_b, targetPos, this.tank.getFluid()) && FluidPlacerTileEntity.place(targetPos, this.tank, this.field_145850_b)) {
                        this.addConnectedSpaces(targetPos);
                        this.handleTempFluids();
                        lowestLayer.poll();
                    }
                }
            }
        }
        ++this.tickCount;
    }

    private static boolean place(BlockPos pos, FluidTank tank, World world) {
        if (tank.getFluidAmount() < 1000) {
            return false;
        }
        FluidStack stack = tank.getFluid();
        Item bucket = stack.getFluid().func_204524_b();
        if (!(bucket instanceof BucketItem)) {
            return false;
        }
        BucketItem bucketitem = (BucketItem)bucket;
        if (bucketitem == null || bucketitem == Items.field_190931_a) {
            return false;
        }
        ItemStack bucketStack = new ItemStack((IItemProvider)bucketitem);
        if (bucketitem.func_180616_a(null, world, pos, null)) {
            tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            bucketitem.func_203792_a(world, bucketStack, pos);
            return true;
        }
        return false;
    }

    private void prepareAreaCheck() {
        this.checkedPositions.clear();
        this.layeredPlacementQueue.clear();
        this.tempFluids.clear();
        this.addConnectedSpaces(this.func_174877_v());
        this.handleTempFluids();
    }

    private Queue<BlockPos> getQueueForYLevel(int yLevel) {
        Queue<BlockPos> queue = this.layeredPlacementQueue.get(yLevel);
        if (queue == null) {
            queue = new LinkedList<BlockPos>();
            this.layeredPlacementQueue.put(yLevel, queue);
        }
        return queue;
    }

    private void addConnectedSpaces(BlockPos pos) {
        for (Direction facing : Direction.values()) {
            if (facing == Direction.UP || pos == this.func_174877_v() && this.sideConfig.get(facing) != IEEnums.IOSideConfig.OUTPUT) continue;
            this.addToQueue(pos.func_177972_a(facing));
        }
    }

    private void addToQueue(BlockPos pos) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() <= 255 && this.checkedPositions.add(pos) && pos.func_177951_i((Vector3i)this.func_174877_v()) < 4096.0 && this.canFill(pos, true)) {
            this.getQueueForYLevel(pos.func_177956_o()).add(pos);
        }
    }

    private boolean canFill(BlockPos targetPos, boolean allowMatchingFull) {
        boolean fluidMatches;
        if (!this.field_145850_b.isAreaLoaded(targetPos, 1)) {
            return false;
        }
        BlockState state = this.field_145850_b.func_180495_p(targetPos);
        boolean canFill = !state.func_185904_a().func_76220_a();
        boolean bl = fluidMatches = state.func_204520_s().func_206886_c() == this.tank.getFluid().getFluid();
        if (!(!this.isFullFluidBlock(targetPos, state) || allowMatchingFull && fluidMatches)) {
            canFill = false;
        }
        if (!canFill && state.func_177230_c() instanceof IWaterLoggable) {
            canFill = ((IWaterLoggable)state.func_177230_c()).func_204510_a((IBlockReader)this.field_145850_b, targetPos, state, this.tank.getFluid().getFluid());
        }
        return canFill;
    }

    private void handleTempFluids() {
        HashSet<BlockPos> tempFluidsCopy = this.tempFluids;
        this.tempFluids = new HashSet();
        for (BlockPos pos : tempFluidsCopy) {
            this.addConnectedSpaces(pos);
        }
    }

    private boolean isFullFluidBlock(BlockPos pos, BlockState state) {
        return state.func_204520_s().func_206889_d();
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        CompoundNBT sideConfigNBT = nbt.func_74775_l("sideConfig");
        for (Direction d : DirectionUtils.VALUES) {
            this.sideConfig.put(d, IEEnums.IOSideConfig.VALUES[sideConfigNBT.func_74762_e(d.func_176610_l())]);
        }
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        if (descPacket) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        CompoundNBT sideConfigNBT = new CompoundNBT();
        for (Direction d : DirectionUtils.VALUES) {
            sideConfigNBT.func_74768_a(d.func_176610_l(), this.sideConfig.get(d).ordinal());
        }
        nbt.func_218657_a("sideConfig", (INBT)sideConfigNBT);
        nbt.func_218657_a("tank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
    }

    @Override
    public IEEnums.IOSideConfig getSideConfig(Direction side) {
        return this.sideConfig.get(side);
    }

    @Override
    public boolean toggleSide(Direction side, PlayerEntity p) {
        this.sideConfig.computeIfPresent(side, (s, conf) -> IEEnums.IOSideConfig.next(conf));
        this.prepareAreaCheck();
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 0, 0);
        return true;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || this.sideConfig.get(facing) == IEEnums.IOSideConfig.INPUT)) {
            return this.tankCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public ITextComponent[] getOverlayText(PlayerEntity player, RayTraceResult rtr, boolean hammer) {
        if (hammer && ((Boolean)IEClientConfig.showTextOverlay.get()).booleanValue() && rtr instanceof BlockRayTraceResult) {
            BlockRayTraceResult brtr = (BlockRayTraceResult)rtr;
            IEEnums.IOSideConfig here = this.sideConfig.get(brtr.func_216354_b());
            IEEnums.IOSideConfig opposite = this.sideConfig.get(brtr.func_216354_b().func_176734_d());
            return TextUtils.sideConfigWithOpposite("desc.immersiveengineering.info.blockSide.connectFluid.", here, opposite);
        }
        return null;
    }

    @Override
    public boolean useNixieFont(PlayerEntity player, RayTraceResult mop) {
        return false;
    }
}

