/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.IWireCoil;
import blusunrize.immersiveengineering.api.wires.ImmersiveConnectableTileEntity;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class EnergyMeterTileEntity
extends ImmersiveConnectableTileEntity
implements ITickableTileEntity,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IComparatorOverride,
EnergyTransferHandler.EnergyConnector,
IEBlockInterfaces.IBlockBounds,
IModelOffsetProvider {
    public final DoubleList lastPackets = new DoubleArrayList(20);
    private int nextPacketIndex = 0;
    private int compVal = -1;
    private Connection shuntConnection;
    private static final CachedVoxelShapes<Boolean> SHAPES = new CachedVoxelShapes<Boolean>(EnergyMeterTileEntity::getShape);

    public EnergyMeterTileEntity() {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)((TileEntityType)IETileTypes.ENERGY_METER.get()));
    }

    @Override
    public boolean interact(Direction side, PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        TileEntity below;
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof IWireCoil) {
            return false;
        }
        int transfer = this.getAveragePower();
        int packets = this.lastPackets.size();
        if (this.isDummy() && (below = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b())) instanceof EnergyMeterTileEntity) {
            packets = ((EnergyMeterTileEntity)below).lastPackets.size();
        }
        String transferred = "0";
        if (transfer > 0) {
            transferred = Utils.formatDouble(transfer, "0.###");
        }
        ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TranslationTextComponent("chat.immersiveengineering.info.energyTransfered", new Object[]{packets, transferred})});
        return true;
    }

    public void func_73660_a() {
        this.checkForNeedlessTicking();
        if (this.isDummy() || this.field_145850_b.field_72995_K) {
            return;
        }
        if ((this.field_145850_b.func_82737_E() & 0x1FL) == (this.field_174879_c.func_218275_a() & 0x1FL) || this.compVal < 0) {
            this.updateComparatorValues();
        }
        EnergyTransferHandler handler = this.globalNet.getLocalNet(this.field_174879_c).getHandler(EnergyTransferHandler.ID, EnergyTransferHandler.class);
        double transferred = 0.0;
        if (handler != null) {
            Object2DoubleMap<Connection> map = handler.getTransferredLastTick();
            transferred = map.getDouble((Object)this.shuntConnection);
        }
        if (this.nextPacketIndex >= this.lastPackets.size()) {
            this.lastPackets.add(transferred);
        } else {
            this.lastPackets.set(this.nextPacketIndex, transferred);
        }
        this.nextPacketIndex = (this.nextPacketIndex + 1) % 20;
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vector3i offset) {
        TileEntity below;
        if (this.isDummy() && (below = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b())) instanceof EnergyMeterTileEntity) {
            return ((EnergyMeterTileEntity)below).canConnectCable(cableType, target, offset);
        }
        if (!(cableType instanceof EnergyTransferHandler.IEnergyWire)) {
            return false;
        }
        for (ConnectionPoint cp : this.getConnectionPoints()) {
            for (Connection c : this.globalNet.getLocalNet(this.field_174879_c).getConnections(cp)) {
                if (c.isInternal() || !target.equals(cp) && c.type.getCategory().equals(cableType.getCategory())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<BlockPos> getIgnored(IImmersiveConnectable other) {
        if (this.isDummy()) {
            return ImmutableSet.of((Object)this.field_174879_c, (Object)this.field_174879_c.func_177977_b());
        }
        return ImmutableSet.of((Object)this.field_174879_c, (Object)this.field_174879_c.func_177984_a());
    }

    @Override
    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo info, Vector3i offset) {
        ConnectionPoint targetByHit;
        if (this.getFacing().func_176740_k() == Direction.Axis.X) {
            targetByHit = (double)info.hitZ > 0.5 ? new ConnectionPoint(this.field_174879_c, 0) : new ConnectionPoint(this.field_174879_c, 1);
        } else {
            ConnectionPoint connectionPoint = targetByHit = (double)info.hitX > 0.5 ? new ConnectionPoint(this.field_174879_c, 0) : new ConnectionPoint(this.field_174879_c, 1);
        }
        if (!this.globalNet.getLocalNet(targetByHit).getConnections(targetByHit).stream().allMatch(Connection::isInternal)) {
            return new ConnectionPoint(this.field_174879_c, 1 - targetByHit.getIndex());
        }
        return targetByHit;
    }

    @Override
    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
        if (this.isDummy()) {
            TileEntity below = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b());
            if (below instanceof EnergyMeterTileEntity) {
                ((EnergyMeterTileEntity)below).connectCable(cableType, target, other, otherTarget);
            }
        } else {
            super.connectCable(cableType, target, other, otherTarget);
        }
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        if (this.isDummy()) {
            return this.field_174879_c.func_177977_b();
        }
        return this.field_174879_c;
    }

    @Override
    public Vector3d getConnectionOffset(@Nonnull Connection con, ConnectionPoint here) {
        if (this.getFacing().func_176740_k() == Direction.Axis.X) {
            return new Vector3d(0.5, 1.4375, here.getIndex() == 0 ? 0.8125 : 0.1875);
        }
        return new Vector3d(here.getIndex() == 0 ? 0.8125 : 0.1875, 1.4375, 0.5);
    }

    @Override
    @Nullable
    public IEBlockInterfaces.IGeneralMultiblock master() {
        if (!this.isDummy()) {
            return this;
        }
        BlockPos masterPos = this.func_174877_v().func_177977_b();
        TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, masterPos);
        return this.getClass().isInstance(te) ? (IEBlockInterfaces.IGeneralMultiblock)te : null;
    }

    @Override
    public void placeDummies(BlockItemUseContext ctx, BlockState state) {
        BlockPos dummyPos = this.field_174879_c.func_177984_a();
        this.field_145850_b.func_175656_a(dummyPos, IEBaseBlock.applyLocationalWaterlogging((BlockState)state.func_206870_a((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true)), this.field_145850_b, dummyPos));
        ((EnergyMeterTileEntity)this.field_145850_b.func_175625_s(dummyPos)).setFacing(this.getFacing());
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        if (this.isDummy()) {
            this.field_145850_b.func_217377_a(pos.func_177977_b(), false);
        } else {
            this.field_145850_b.func_217377_a(pos.func_177984_a(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAveragePower() {
        EnergyMeterTileEntity te = this;
        if (te.isDummy()) {
            TileEntity below = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b());
            if (!(below instanceof EnergyMeterTileEntity)) {
                return -1;
            }
            te = (EnergyMeterTileEntity)below;
        }
        if (te.lastPackets.size() == 0) {
            return 0;
        }
        double sum = 0.0;
        DoubleList doubleList = te.lastPackets;
        synchronized (doubleList) {
            DoubleListIterator doubleListIterator = te.lastPackets.iterator();
            while (doubleListIterator.hasNext()) {
                double transfer = (Double)doubleListIterator.next();
                sum += transfer;
            }
        }
        return (int)Math.round(sum / (double)te.lastPackets.size());
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return SHAPES.get(this.isDummy());
    }

    private static List<AxisAlignedBB> getShape(Boolean isDummy) {
        ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.1875, -0.625, 0.1875, 0.8125, 0.8125, 0.8125), new AxisAlignedBB(0.0, -1.0, 0.0, 1.0, -0.625, 1.0)});
        if (!isDummy.booleanValue()) {
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, ((AxisAlignedBB)list.get(i)).func_72317_d(0.0, 1.0, 0.0));
            }
        }
        return list;
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    private void updateComparatorValues() {
        int oldVal = this.compVal;
        int maxTrans = 0;
        Collection<Connection> conns = this.globalNet.getLocalNet(this.field_174879_c).getConnections(this.field_174879_c);
        if (conns == null) {
            this.compVal = 0;
        } else {
            for (Connection c : conns) {
                if (!(c.type instanceof EnergyTransferHandler.IEnergyWire)) continue;
                maxTrans += ((EnergyTransferHandler.IEnergyWire)((Object)c.type)).getTransferRate();
            }
            double val = (double)this.getAveragePower() / (double)(maxTrans /= 2);
            this.compVal = (int)Math.ceil(15.0 * val);
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
            if (te instanceof EnergyMeterTileEntity) {
                ((EnergyMeterTileEntity)te).compVal = this.compVal;
            }
        }
        if (oldVal != this.compVal) {
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
            this.field_145850_b.func_175666_e(this.field_174879_c.func_177977_b(), this.func_195044_w().func_177230_c());
        }
    }

    @Override
    public int getComparatorInputOverride() {
        return this.compVal;
    }

    @Override
    public boolean isSource(ConnectionPoint cp) {
        return false;
    }

    @Override
    public boolean isSink(ConnectionPoint cp) {
        return false;
    }

    @Override
    public void onLoad() {
        this.shuntConnection = new Connection(this.field_174879_c, 0, 1);
        super.onLoad();
    }

    @Override
    public Iterable<? extends Connection> getInternalConnections() {
        if (this.shuntConnection != null) {
            return ImmutableList.of((Object)this.shuntConnection);
        }
        return ImmutableList.of();
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        return ImmutableList.of((Object)new ConnectionPoint(this.field_174879_c, 0), (Object)new ConnectionPoint(this.field_174879_c, 1));
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @Nullable Vector3i size) {
        if (this.isDummy()) {
            return BlockPos.field_177992_a;
        }
        return new BlockPos(0, -1, 0);
    }
}

