/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorageAdvanced;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.api.utils.IngredientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class PoweredMultiblockTileEntity<T extends PoweredMultiblockTileEntity<T, R>, R extends MultiblockRecipe>
extends MultiblockPartTileEntity<T>
implements IIEInventory,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IProcessTile,
IEBlockInterfaces.IComparatorOverride {
    public final FluxStorageAdvanced energyStorage;
    EnergyHelper.IEForgeEnergyWrapper wrapper = new EnergyHelper.IEForgeEnergyWrapper(this, null);
    public List<MultiblockProcess<R>> processQueue = new ArrayList<MultiblockProcess<R>>();
    public int tickedProcesses = 0;

    public PoweredMultiblockTileEntity(IETemplateMultiblock multiblockInstance, int energyCapacity, boolean redstoneControl, TileEntityType<? extends T> type) {
        super(multiblockInstance, type, redstoneControl);
        this.energyStorage = new FluxStorageAdvanced(energyCapacity);
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.energyStorage.readFromNBT(nbt);
        ListNBT processNBT = nbt.func_150295_c("processQueue", 10);
        this.processQueue.clear();
        for (int i = 0; i < processNBT.size(); ++i) {
            CompoundNBT tag = processNBT.func_150305_b(i);
            if (!tag.func_74764_b("recipe")) continue;
            int processTick = tag.func_74762_e("process_processTick");
            MultiblockProcess<R> process = this.loadProcessFromNBT(tag);
            if (process == null) continue;
            process.processTick = processTick;
            this.processQueue.add(process);
        }
        if (nbt.func_150297_b("computerOn", 1) && ModList.get().isLoaded("opencomputers")) {
            byte cOn = nbt.func_74771_c("computerOn");
            switch (cOn) {
                case 0: {
                    this.computerOn = Optional.of(false);
                    break;
                }
                case 1: {
                    this.computerOn = Optional.of(true);
                    break;
                }
                case 2: {
                    this.computerOn = Optional.empty();
                }
            }
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        this.energyStorage.writeToNBT(nbt);
        ListNBT processNBT = new ListNBT();
        for (MultiblockProcess<R> process : this.processQueue) {
            processNBT.add((Object)this.writeProcessToNBT(process));
        }
        nbt.func_218657_a("processQueue", (INBT)processNBT);
        if (this.computerOn.isPresent()) {
            nbt.func_74757_a("computerOn", ((Boolean)this.computerOn.get()).booleanValue());
        } else {
            nbt.func_74774_a("computerOn", (byte)2);
        }
    }

    @Nullable
    protected abstract R getRecipeForId(ResourceLocation var1);

    @Nullable
    protected MultiblockProcess<R> loadProcessFromNBT(CompoundNBT tag) {
        String id = tag.func_74779_i("recipe");
        R recipe = this.getRecipeForId(new ResourceLocation(id));
        if (recipe != null) {
            if (this.isInWorldProcessingMachine()) {
                return new MultiblockProcessInWorld<R>(recipe, tag.func_74760_g("process_transformationPoint"), Utils.loadItemStacksFromNBT(tag.func_74781_a("process_inputItem")));
            }
            return new MultiblockProcessInMachine<R>(recipe, tag.func_74759_k("process_inputSlots")).setInputTanks(tag.func_74759_k("process_inputTanks"));
        }
        return null;
    }

    protected CompoundNBT writeProcessToNBT(MultiblockProcess process) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("recipe", ((IESerializableRecipe)process.recipe).func_199560_c().toString());
        tag.func_74768_a("process_processTick", process.processTick);
        process.writeExtraDataToNBT(tag);
        return tag;
    }

    public abstract Set<BlockPos> getEnergyPos();

    public boolean isEnergyPos() {
        return this.getEnergyPos().contains(this.posInMultiblock);
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        PoweredMultiblockTileEntity master = (PoweredMultiblockTileEntity)this.master();
        if (master != null) {
            return master.energyStorage;
        }
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.IOSideConfig getEnergySideConfig(Direction facing) {
        return this.formed && this.isEnergyPos() ? IEEnums.IOSideConfig.INPUT : IEEnums.IOSideConfig.NONE;
    }

    @Override
    @Nullable
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        if (this.formed && this.isEnergyPos()) {
            return this.wrapper;
        }
        return null;
    }

    @Override
    public void postEnergyTransferUpdate(int energy, boolean simulate) {
        if (!simulate) {
            this.updateMasterBlock(null, energy != 0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.isDummy()) {
            BlockPos nullPos = this.getOrigin();
            return new AxisAlignedBB(nullPos, TemplateMultiblock.withSettingsAndOffset(nullPos, new BlockPos((Vector3i)this.structureDimensions.get()), this.getIsMirrored(), this.multiblockInstance.untransformDirection(this.getFacing())));
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public int getComparatorInputOverride() {
        if (!this.isRedstonePos()) {
            return 0;
        }
        PoweredMultiblockTileEntity master = (PoweredMultiblockTileEntity)this.master();
        if (master == null) {
            return 0;
        }
        return Utils.calcRedstoneFromInventory(master);
    }

    public void func_73660_a() {
        this.checkForNeedlessTicking();
        this.tickedProcesses = 0;
        if (this.field_145850_b.field_72995_K || this.isDummy() || this.isRSDisabled()) {
            return;
        }
        int max = this.getMaxProcessPerTick();
        int i = 0;
        Iterator<MultiblockProcess<R>> processIterator = this.processQueue.iterator();
        this.tickedProcesses = 0;
        while (processIterator.hasNext() && i++ < max) {
            MultiblockProcess<R> process = processIterator.next();
            if (process.canProcess(this)) {
                process.doProcessTick(this);
                ++this.tickedProcesses;
                this.updateMasterBlock(null, true);
            }
            if (!process.clearProcess) continue;
            processIterator.remove();
        }
    }

    @Nullable
    public abstract IFluidTank[] getInternalTanks();

    @Nullable
    public abstract R findRecipeForInsertion(ItemStack var1);

    @Nullable
    public abstract int[] getOutputSlots();

    @Nullable
    public abstract int[] getOutputTanks();

    public abstract boolean additionalCanProcessCheck(MultiblockProcess<R> var1);

    public abstract void doProcessOutput(ItemStack var1);

    public abstract void doProcessFluidOutput(FluidStack var1);

    public abstract void onProcessFinish(MultiblockProcess<R> var1);

    public abstract int getMaxProcessPerTick();

    public abstract int getProcessQueueMaxLength();

    public abstract float getMinProcessDistance(MultiblockProcess<R> var1);

    public abstract boolean isInWorldProcessingMachine();

    public boolean addProcessToQueue(MultiblockProcess<R> process, boolean simulate) {
        return this.addProcessToQueue(process, simulate, false);
    }

    public boolean addProcessToQueue(MultiblockProcess<R> process, boolean simulate, boolean addToPrevious) {
        if (addToPrevious && process instanceof MultiblockProcessInWorld) {
            MultiblockProcessInWorld newProcess = (MultiblockProcessInWorld)process;
            for (MultiblockProcess<R> curr : this.processQueue) {
                if (!(curr instanceof MultiblockProcessInWorld) || !process.recipe.equals(curr.recipe)) continue;
                MultiblockProcessInWorld existingProcess = (MultiblockProcessInWorld)curr;
                boolean canStack = true;
                for (ItemStack old : existingProcess.inputItems) {
                    for (ItemStack in : newProcess.inputItems) {
                        if (!ItemStack.func_179545_c((ItemStack)old, (ItemStack)in) || !Utils.compareItemNBT(old, in) || old.func_190916_E() + in.func_190916_E() <= old.func_77976_d()) continue;
                        canStack = false;
                        break;
                    }
                    if (canStack) continue;
                    break;
                }
                if (!canStack) continue;
                if (!simulate) {
                    block3: for (ItemStack old : existingProcess.inputItems) {
                        for (ItemStack in : newProcess.inputItems) {
                            if (!ItemStack.func_179545_c((ItemStack)old, (ItemStack)in) || !Utils.compareItemNBT(old, in)) continue;
                            old.func_190917_f(in.func_190916_E());
                            continue block3;
                        }
                    }
                }
                return true;
            }
        }
        if (this.getProcessQueueMaxLength() < 0 || this.processQueue.size() < this.getProcessQueueMaxLength()) {
            float dist = 1.0f;
            MultiblockProcess<R> p = null;
            if (this.processQueue.size() > 0 && (p = this.processQueue.get(this.processQueue.size() - 1)) != null) {
                dist = (float)p.processTick / (float)p.maxTicks;
            }
            if (p != null && dist < this.getMinProcessDistance(p)) {
                return false;
            }
            if (!simulate) {
                this.processQueue.add(process);
            }
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public int[] getCurrentProcessesStep() {
        PoweredMultiblockTileEntity master = (PoweredMultiblockTileEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesStep();
        }
        int[] ia = new int[this.processQueue.size()];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = this.processQueue.get((int)i).processTick;
        }
        return ia;
    }

    @Override
    @Nonnull
    public int[] getCurrentProcessesMax() {
        PoweredMultiblockTileEntity master = (PoweredMultiblockTileEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesMax();
        }
        int[] ia = new int[this.processQueue.size()];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = this.processQueue.get((int)i).maxTicks;
        }
        return ia;
    }

    public boolean shouldRenderAsActive() {
        return this.getEnergyStored(null) > 0 && !this.isRSDisabled() && !this.processQueue.isEmpty();
    }

    public static class MultiblockInventoryHandler_DirectProcessing<T extends PoweredMultiblockTileEntity<T, R>, R extends MultiblockRecipe>
    implements IItemHandlerModifiable {
        T multiblock;
        float transformationPoint = 0.5f;
        boolean doProcessStacking = false;

        public MultiblockInventoryHandler_DirectProcessing(T multiblock) {
            this.multiblock = multiblock;
        }

        public MultiblockInventoryHandler_DirectProcessing setTransformationPoint(float point) {
            this.transformationPoint = point;
            return this;
        }

        public MultiblockInventoryHandler_DirectProcessing setProcessStacking(boolean stacking) {
            this.doProcessStacking = stacking;
            return this;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            Object recipe = ((PoweredMultiblockTileEntity)this.multiblock).findRecipeForInsertion(stack = stack.func_77946_l());
            if (recipe == null) {
                return stack;
            }
            ItemStack displayStack = recipe.getDisplayStack(stack);
            if (((PoweredMultiblockTileEntity)this.multiblock).addProcessToQueue(new MultiblockProcessInWorld(recipe, this.transformationPoint, Utils.createNonNullItemStackListFromItemStack(displayStack)), simulate, this.doProcessStacking)) {
                this.multiblock.func_70296_d();
                ((IEBaseTileEntity)this.multiblock).markContainingBlockForUpdate(null);
                stack.func_190918_g(displayStack.func_190916_E());
                if (stack.func_190916_E() <= 0) {
                    stack = ItemStack.field_190927_a;
                }
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }

    public static class MultiblockProcessInWorld<R extends MultiblockRecipe>
    extends MultiblockProcess<R> {
        public List<ItemStack> inputItems;
        protected float transformationPoint;

        public MultiblockProcessInWorld(R recipe, float transformationPoint, NonNullList<ItemStack> inputItem) {
            super(recipe);
            this.inputItems = new ArrayList<ItemStack>((Collection<ItemStack>)inputItem);
            this.transformationPoint = transformationPoint;
        }

        public List<ItemStack> getDisplayItem() {
            NonNullList<ItemStack> list;
            if ((float)this.processTick / (float)this.maxTicks > this.transformationPoint && !(list = this.recipe.getItemOutputs()).isEmpty()) {
                return list;
            }
            return this.inputItems;
        }

        @Override
        protected void writeExtraDataToNBT(CompoundNBT nbt) {
            nbt.func_218657_a("process_inputItem", (INBT)Utils.writeInventory(this.inputItems));
            nbt.func_74776_a("process_transformationPoint", this.transformationPoint);
        }

        @Override
        protected void processFinish(PoweredMultiblockTileEntity multiblock) {
            super.processFinish(multiblock);
            int size = -1;
            for (ItemStack inputItem : this.inputItems) {
                for (IngredientWithSize s : this.recipe.getItemInputs()) {
                    if (!s.test(inputItem)) continue;
                    size = s.getCount();
                    break;
                }
                if (size <= 0 || inputItem.func_190916_E() <= size) continue;
                inputItem.func_77979_a(size);
                this.processTick = 0;
                this.clearProcess = false;
            }
        }
    }

    public static class MultiblockProcessInMachine<R extends MultiblockRecipe>
    extends MultiblockProcess<R> {
        protected int[] inputSlots = new int[0];
        protected int[] inputAmounts = null;
        protected int[] inputTanks = new int[0];

        public MultiblockProcessInMachine(R recipe, int ... inputSlots) {
            super(recipe);
            this.inputSlots = inputSlots;
        }

        public MultiblockProcessInMachine<R> setInputTanks(int ... inputTanks) {
            this.inputTanks = inputTanks;
            return this;
        }

        public MultiblockProcessInMachine<R> setInputAmounts(int ... inputAmounts) {
            this.inputAmounts = inputAmounts;
            return this;
        }

        public int[] getInputSlots() {
            return this.inputSlots;
        }

        @Nullable
        public int[] getInputAmounts() {
            return this.inputAmounts;
        }

        public int[] getInputTanks() {
            return this.inputTanks;
        }

        protected List<IngredientWithSize> getRecipeItemInputs(PoweredMultiblockTileEntity<?, R> multiblock) {
            return this.recipe.getItemInputs();
        }

        protected List<FluidTagInput> getRecipeFluidInputs(PoweredMultiblockTileEntity<?, R> multiblock) {
            return this.recipe.getFluidInputs();
        }

        @Override
        public void doProcessTick(PoweredMultiblockTileEntity<?, R> multiblock) {
            NonNullList inv = multiblock.getInventory();
            if (this.recipe.shouldCheckItemAvailability() && this.recipe.getItemInputs() != null && inv != null) {
                NonNullList query = NonNullList.func_191197_a((int)this.inputSlots.length, (Object)ItemStack.field_190927_a);
                for (int i = 0; i < this.inputSlots.length; ++i) {
                    if (this.inputSlots[i] < 0 || this.inputSlots[i] >= inv.size()) continue;
                    query.set(i, multiblock.getInventory().get(this.inputSlots[i]));
                }
                if (!IngredientUtils.stacksMatchIngredientWithSizeList(this.recipe.getItemInputs(), (NonNullList<ItemStack>)query)) {
                    this.clearProcess = true;
                    return;
                }
            }
            super.doProcessTick(multiblock);
        }

        @Override
        protected void processFinish(PoweredMultiblockTileEntity<?, R> multiblock) {
            super.processFinish(multiblock);
            NonNullList inv = multiblock.getInventory();
            List<IngredientWithSize> itemInputList = this.getRecipeItemInputs(multiblock);
            if (inv != null && this.inputSlots != null && itemInputList != null) {
                if (this.inputAmounts != null && this.inputSlots.length == this.inputAmounts.length) {
                    for (int i = 0; i < this.inputSlots.length; ++i) {
                        if (this.inputAmounts[i] <= 0) continue;
                        ((ItemStack)inv.get(this.inputSlots[i])).func_190918_g(this.inputAmounts[i]);
                    }
                } else {
                    block1: for (IngredientWithSize ingr : new ArrayList<IngredientWithSize>(itemInputList)) {
                        int ingrSize = ingr.getCount();
                        for (int slot : this.inputSlots) {
                            if (((ItemStack)inv.get(slot)).func_190926_b() || !ingr.test((ItemStack)inv.get(slot))) continue;
                            int taken = Math.min(((ItemStack)inv.get(slot)).func_190916_E(), ingrSize);
                            ((ItemStack)inv.get(slot)).func_190918_g(taken);
                            if (((ItemStack)inv.get(slot)).func_190916_E() <= 0) {
                                inv.set(slot, (Object)ItemStack.field_190927_a);
                            }
                            if ((ingrSize -= taken) <= 0) continue block1;
                        }
                    }
                }
            }
            IFluidTank[] tanks = multiblock.getInternalTanks();
            List<FluidTagInput> fluidInputList = this.getRecipeFluidInputs(multiblock);
            if (tanks != null && this.inputTanks != null && fluidInputList != null) {
                block3: for (FluidTagInput ingr : new ArrayList<FluidTagInput>(fluidInputList)) {
                    int ingrSize = ingr.getAmount();
                    for (int tank : this.inputTanks) {
                        if (tanks[tank] == null || !ingr.testIgnoringAmount(tanks[tank].getFluid())) continue;
                        int taken = Math.min(tanks[tank].getFluidAmount(), ingrSize);
                        tanks[tank].drain(taken, IFluidHandler.FluidAction.EXECUTE);
                        if ((ingrSize -= taken) <= 0) continue block3;
                    }
                }
            }
        }

        @Override
        protected void writeExtraDataToNBT(CompoundNBT nbt) {
            if (this.inputSlots != null) {
                nbt.func_74783_a("process_inputSlots", this.inputSlots);
            }
            if (this.inputAmounts != null) {
                nbt.func_74783_a("process_inputAmounts", this.inputAmounts);
            }
            if (this.inputTanks != null) {
                nbt.func_74783_a("process_inputTanks", this.inputTanks);
            }
        }
    }

    public static abstract class MultiblockProcess<R extends MultiblockRecipe> {
        public R recipe;
        public int processTick;
        public int maxTicks;
        public int energyPerTick;
        public boolean clearProcess = false;

        public MultiblockProcess(R recipe) {
            this.recipe = recipe;
            this.processTick = 0;
            this.maxTicks = ((MultiblockRecipe)this.recipe).getTotalProcessTime();
            this.energyPerTick = ((MultiblockRecipe)this.recipe).getTotalProcessEnergy() / this.maxTicks;
        }

        protected List<ItemStack> getRecipeItemOutputs(PoweredMultiblockTileEntity<?, R> multiblock) {
            return this.recipe.getActualItemOutputs(multiblock);
        }

        protected List<FluidStack> getRecipeFluidOutputs(PoweredMultiblockTileEntity<?, R> multiblock) {
            return this.recipe.getActualFluidOutputs(multiblock);
        }

        public boolean canProcess(PoweredMultiblockTileEntity<?, R> multiblock) {
            if (multiblock.energyStorage.extractEnergy(this.energyPerTick, true) == this.energyPerTick) {
                List<FluidStack> fluidOutputs;
                NonNullList<ItemStack> outputs = ((MultiblockRecipe)this.recipe).getItemOutputs();
                if (outputs != null && !outputs.isEmpty()) {
                    int[] outputSlots = multiblock.getOutputSlots();
                    for (ItemStack output : outputs) {
                        if (output.func_190926_b()) continue;
                        boolean canOutput = false;
                        if (outputSlots == null) {
                            canOutput = true;
                        } else {
                            for (int iOutputSlot : outputSlots) {
                                ItemStack s = (ItemStack)multiblock.getInventory().get(iOutputSlot);
                                if (!s.func_190926_b() && (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)output) || s.func_190916_E() + output.func_190916_E() > multiblock.getSlotLimit(iOutputSlot))) continue;
                                canOutput = true;
                                break;
                            }
                        }
                        if (canOutput) continue;
                        return false;
                    }
                }
                if ((fluidOutputs = ((MultiblockRecipe)this.recipe).getFluidOutputs()) != null && !fluidOutputs.isEmpty()) {
                    IFluidTank[] tanks = multiblock.getInternalTanks();
                    int[] outputTanks = multiblock.getOutputTanks();
                    for (FluidStack output : fluidOutputs) {
                        if (output == null || output.getAmount() <= 0) continue;
                        boolean canOutput = false;
                        if (tanks == null || outputTanks == null) {
                            canOutput = true;
                        } else {
                            for (int iOutputTank : outputTanks) {
                                if (iOutputTank < 0 || iOutputTank >= tanks.length || tanks[iOutputTank] == null || tanks[iOutputTank].fill(output, IFluidHandler.FluidAction.SIMULATE) != output.getAmount()) continue;
                                canOutput = true;
                                break;
                            }
                        }
                        if (canOutput) continue;
                        return false;
                    }
                }
                return multiblock.additionalCanProcessCheck(this);
            }
            return false;
        }

        public void doProcessTick(PoweredMultiblockTileEntity<?, R> multiblock) {
            int energyExtracted = this.energyPerTick;
            int ticksAdded = 1;
            if (this.recipe.getMultipleProcessTicks() > 1) {
                int possibleTicks;
                int averageInsertion = multiblock.energyStorage.getAverageInsertion();
                if ((averageInsertion = multiblock.energyStorage.extractEnergy(averageInsertion, true)) > energyExtracted && (possibleTicks = Math.min(averageInsertion / this.energyPerTick, Math.min(this.recipe.getMultipleProcessTicks(), this.maxTicks - this.processTick))) > 1) {
                    ticksAdded = possibleTicks;
                    energyExtracted *= ticksAdded;
                }
            }
            multiblock.energyStorage.extractEnergy(energyExtracted, false);
            this.processTick += ticksAdded;
            if (this.processTick >= this.maxTicks) {
                this.processFinish(multiblock);
            }
        }

        protected void processFinish(PoweredMultiblockTileEntity<?, R> multiblock) {
            List<FluidStack> fluidOutputs;
            List<ItemStack> outputs = this.getRecipeItemOutputs(multiblock);
            if (outputs != null && !outputs.isEmpty()) {
                int[] outputSlots = multiblock.getOutputSlots();
                block0: for (ItemStack output : outputs) {
                    if (output.func_190926_b()) continue;
                    if (outputSlots == null || multiblock.getInventory() == null) {
                        multiblock.doProcessOutput(output.func_77946_l());
                        continue;
                    }
                    for (Object iOutputSlot : (Object)outputSlots) {
                        ItemStack s = (ItemStack)multiblock.getInventory().get((int)iOutputSlot);
                        if (s.func_190926_b()) {
                            multiblock.getInventory().set((int)iOutputSlot, (Object)output.func_77946_l());
                            continue block0;
                        }
                        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)output) || s.func_190916_E() + output.func_190916_E() > multiblock.getSlotLimit((int)iOutputSlot)) continue;
                        ((ItemStack)multiblock.getInventory().get((int)iOutputSlot)).func_190917_f(output.func_190916_E());
                        continue block0;
                    }
                }
            }
            if ((fluidOutputs = this.getRecipeFluidOutputs(multiblock)) != null && !fluidOutputs.isEmpty()) {
                IFluidTank[] tanks = multiblock.getInternalTanks();
                int[] outputTanks = multiblock.getOutputTanks();
                block2: for (FluidStack output : fluidOutputs) {
                    if (output == null || output.getAmount() <= 0) continue;
                    if (tanks == null || outputTanks == null) {
                        multiblock.doProcessFluidOutput(output);
                        continue;
                    }
                    for (int iOutputTank : outputTanks) {
                        if (iOutputTank < 0 || iOutputTank >= tanks.length || tanks[iOutputTank] == null || tanks[iOutputTank].fill(output, IFluidHandler.FluidAction.SIMULATE) != output.getAmount()) continue;
                        tanks[iOutputTank].fill(output, IFluidHandler.FluidAction.EXECUTE);
                        continue block2;
                    }
                }
            }
            multiblock.onProcessFinish(this);
            this.clearProcess = true;
        }

        protected abstract void writeExtraDataToNBT(CompoundNBT var1);
    }
}

