/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.cloth;

import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorStructuralTileEntity;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Triple;

public class BalloonTileEntity
extends ConnectorStructuralTileEntity
implements IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IHammerInteraction {
    public int style = 0;
    public DyeColor colour0 = null;
    public DyeColor colour1 = null;
    public CapabilityShader.ShaderWrapper_Direct shader = new CapabilityShader.ShaderWrapper_Direct(new ResourceLocation("immersiveengineering", "balloon"));
    LazyOptional<CapabilityShader.ShaderWrapper> shaderCap;

    public BalloonTileEntity() {
        super((TileEntityType<? extends ConnectorStructuralTileEntity>)((TileEntityType)IETileTypes.BALLOON.get()));
        this.reInitCapability();
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        int oldStyle = this.style;
        DyeColor oldC0 = this.colour0;
        DyeColor oldC1 = this.colour1;
        this.style = nbt.func_74762_e("style");
        int tmpIdx = nbt.func_74762_e("colour0");
        this.colour0 = tmpIdx >= 0 && tmpIdx < DyeColor.values().length ? DyeColor.func_196056_a((int)tmpIdx) : null;
        tmpIdx = nbt.func_74762_e("colour1");
        DyeColor dyeColor = this.colour1 = tmpIdx >= 0 && tmpIdx < DyeColor.values().length ? DyeColor.func_196056_a((int)tmpIdx) : null;
        if (oldStyle != this.style || oldC0 != this.colour0 || oldC1 != this.colour1) {
            this.requestModelDataUpdate();
        }
        if (nbt.func_150297_b("shader", 10)) {
            this.shader = new CapabilityShader.ShaderWrapper_Direct(new ResourceLocation("immersiveengineering", "balloon"));
            this.shader.deserializeNBT(nbt.func_74775_l("shader"));
            this.reInitCapability();
        }
    }

    @Override
    public void writeCustomNBT(@Nonnull CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("style", this.style);
        nbt.func_74768_a("colour0", this.colour0 != null ? this.colour0.func_196059_a() : -1);
        nbt.func_74768_a("colour1", this.colour1 != null ? this.colour1.func_196059_a() : -1);
        nbt.func_218657_a("shader", (INBT)this.shader.serializeNBT());
    }

    @Override
    @Nonnull
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.9375, (double)0.875);
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return super.func_145842_c(id, arg);
    }

    private void reInitCapability() {
        if (this.shaderCap != null) {
            this.unregisterCap(this.shaderCap);
        }
        this.shaderCap = this.registerConstantCap(this.shader);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityShader.SHADER_CAPABILITY) {
            return this.shaderCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    @Nonnull
    public String getCacheKey(@Nonnull BlockState object) {
        if (this.shader != null && !this.shader.getShaderItem().func_190926_b() && this.shader.getShaderItem().func_77973_b() instanceof IShaderItem) {
            return ((IShaderItem)this.shader.getShaderItem().func_77973_b()).getShaderName(this.shader.getShaderItem()).toString();
        }
        return this.colour0 + ":" + this.colour1 + ":" + this.style;
    }

    @Override
    public Vector4f getRenderColor(BlockState object, String group, Vector4f original) {
        if (this.shader != null && !this.shader.getShaderItem().func_190926_b() && this.shader.getShaderItem().func_77973_b() instanceof IShaderItem) {
            return original;
        }
        if (this.style == 0) {
            if (group.startsWith("balloon1_")) {
                return Utils.vec4fFromDye(this.colour1);
            }
            if (group.startsWith("balloon0_")) {
                return Utils.vec4fFromDye(this.colour0);
            }
        } else {
            if (group.endsWith("_1")) {
                return Utils.vec4fFromDye(this.colour1);
            }
            if (group.endsWith("_0")) {
                return Utils.vec4fFromDye(this.colour0);
            }
        }
        return original;
    }

    @Override
    public Vector3d getConnectionOffset(@Nonnull Connection con, ConnectionPoint here) {
        double dist;
        BlockPos end = con.getOtherEnd(here).getPosition();
        int xDif = end.func_177958_n() - this.func_174877_v().func_177958_n();
        int zDif = end.func_177952_p() - this.func_174877_v().func_177952_p();
        int yDif = end.func_177956_o() - this.func_174877_v().func_177956_o();
        if (yDif < 0 && (dist = Math.sqrt(xDif * xDif + zDif * zDif)) / (double)Math.abs(yDif) < 2.5) {
            return new Vector3d(0.5, 0.09375, 0.5);
        }
        if (Math.abs(zDif) > Math.abs(xDif)) {
            return new Vector3d(0.5, 0.09375, zDif > 0 ? 0.78125 : 0.21875);
        }
        return new Vector3d(xDif > 0 ? 0.78125 : 0.21875, 0.09375, 0.5);
    }

    @Override
    public boolean interact(Direction side, PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof IShaderItem) {
            if (this.shader == null) {
                this.shader = new CapabilityShader.ShaderWrapper_Direct(new ResourceLocation("immersiveengineering", "balloon"));
            }
            this.shader.setShaderItem(Utils.copyStackWithAmount(heldItem, 1));
            this.markContainingBlockForUpdate(null);
            return true;
        }
        boolean target = false;
        if (side.func_176740_k() == Direction.Axis.Y && this.style == 0) {
            target = ((double)hitX < 0.375 || (double)hitX > 0.625) && ((double)hitZ < 0.375 || (double)hitZ > 0.625);
        } else if (side.func_176740_k() == Direction.Axis.Z) {
            target = this.style == 0 ? (double)hitX < 0.375 || (double)hitX > 0.625 : (double)hitY > 0.5625 && (double)hitY < 0.75;
        } else if (side.func_176740_k() == Direction.Axis.X) {
            target = this.style == 0 ? (double)hitZ < 0.375 || (double)hitZ > 0.625 : (double)hitY > 0.5625 && (double)hitY < 0.75;
        }
        DyeColor heldDye = Utils.getDye(heldItem);
        if (heldDye == null) {
            return false;
        }
        if (!target) {
            if (this.colour0 == heldDye) {
                return false;
            }
            this.colour0 = heldDye;
        } else {
            if (this.colour1 == heldDye) {
                return false;
            }
            this.colour1 = heldDye;
        }
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Override
    public boolean hammerUseSide(Direction side, PlayerEntity player, Hand hand, Vector3d hitVec) {
        if (!this.field_145850_b.field_72995_K) {
            this.style = 1 - this.style;
            this.markContainingBlockForUpdate(null);
        }
        return true;
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        if (entity instanceof AbstractArrowEntity) {
            Vector3d pos = Vector3d.func_237489_a_((Vector3i)this.func_174877_v());
            world.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187619_bk, SoundCategory.BLOCKS, 1.5f, 0.7f);
            world.func_217377_a(this.func_174877_v(), false);
            world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.05, 0.0);
            Triple<ItemStack, ShaderRegistry.ShaderRegistryEntry, ShaderCase> shader = ShaderRegistry.getStoredShaderAndCase(this.shader);
            if (shader != null) {
                ((ShaderRegistry.ShaderRegistryEntry)shader.getMiddle()).getEffectFunction().execute(world, (ItemStack)shader.getLeft(), null, ((ShaderCase)shader.getRight()).getShaderType().toString(), pos, null, 0.375f);
            }
        }
    }

    @Override
    public Direction getFacing() {
        return Direction.NORTH;
    }

    @Override
    public void setFacing(Direction facing) {
    }
}

