/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.utils.CombinedModelData;
import blusunrize.immersiveengineering.client.utils.SinglePropertyModelData;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.util.DirectionUtils;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.SafeChunkUtils;
import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class IEBaseTileEntity
extends TileEntity
implements IEBlockInterfaces.BlockstateProvider {
    protected IEBlockInterfaces.IGeneralMultiblock tempMasterTE;
    private BlockState overrideBlockState = null;
    private final EnumMap<Direction, Integer> redstoneBySide = new EnumMap(Direction.class);
    private final Set<LazyOptional<?>> caps = new HashSet();
    private final Map<Direction, LazyOptional<IEnergyStorage>> energyCaps = new HashMap<Direction, LazyOptional<IEnergyStorage>>();

    public IEBaseTileEntity(TileEntityType<? extends TileEntity> type) {
        super(type);
    }

    public void func_230337_a_(BlockState stateIn, CompoundNBT nbtIn) {
        super.func_230337_a_(stateIn, nbtIn);
        this.readCustomNBT(nbtIn, false);
    }

    public abstract void readCustomNBT(CompoundNBT var1, boolean var2);

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        this.writeCustomNBT(nbt, false);
        return nbt;
    }

    public abstract void writeCustomNBT(CompoundNBT var1, boolean var2);

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbttagcompound = new CompoundNBT();
        this.writeCustomNBT(nbttagcompound, true);
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readCustomNBT(pkt.func_148857_g(), true);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        this.writeCustomNBT(nbt, true);
        return nbt;
    }

    public void func_189668_a(Mirror mirrorIn) {
        if (mirrorIn == Mirror.FRONT_BACK && this instanceof IEBlockInterfaces.IDirectionalTile) {
            ((IEBlockInterfaces.IDirectionalTile)((Object)this)).setFacing(((IEBlockInterfaces.IDirectionalTile)((Object)this)).getFacing());
            this.func_70296_d();
            if (this.field_174879_c != null) {
                this.markBlockForUpdate(this.field_174879_c, null);
            }
        }
    }

    public void receiveMessageFromClient(CompoundNBT message) {
    }

    public void receiveMessageFromServer(CompoundNBT message) {
    }

    public void onEntityCollision(World world, Entity entity) {
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 0 || id == 255) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        if (id == 254) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void markContainingBlockForUpdate(@Nullable BlockState newState) {
        if (this.field_145850_b != null) {
            this.markBlockForUpdate(this.func_174877_v(), newState);
        }
    }

    public void markBlockForUpdate(BlockPos pos, @Nullable BlockState newState) {
        BlockState state = this.field_145850_b.func_180495_p(pos);
        if (newState == null) {
            newState = state;
        }
        this.field_145850_b.func_184138_a(pos, state, newState, 3);
        this.field_145850_b.func_195593_d(pos, newState.func_177230_c());
    }

    protected <T> LazyOptional<T> registerConstantCap(T val) {
        return this.registerCap(() -> val);
    }

    protected <T> LazyOptional<T> registerCap(NonNullSupplier<T> cap) {
        return this.registerCap(LazyOptional.of(cap));
    }

    protected <T> LazyOptional<T> registerCap(LazyOptional<T> cap) {
        this.caps.add(cap);
        return cap;
    }

    protected <T> void unregisterCap(LazyOptional<T> cap) {
        cap.invalidate();
        this.caps.remove(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY && this instanceof EnergyHelper.IIEInternalFluxConnector) {
            if (!this.energyCaps.containsKey(side)) {
                EnergyHelper.IEForgeEnergyWrapper wrapper = ((EnergyHelper.IIEInternalFluxConnector)((Object)this)).getCapabilityWrapper(side);
                if (wrapper != null) {
                    this.energyCaps.put(side, this.registerConstantCap(wrapper));
                } else {
                    this.energyCaps.put(side, (LazyOptional<IEnergyStorage>)LazyOptional.empty());
                }
            }
            return this.energyCaps.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public double func_145833_n() {
        double increase = (Double)IEClientConfig.increasedTileRenderdistance.get();
        return super.func_145833_n() * increase * increase;
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (LazyOptional<?> cap : this.caps) {
            if (!cap.isPresent()) continue;
            cap.invalidate();
        }
        this.caps.clear();
    }

    @Nonnull
    public World getWorldNonnull() {
        return Objects.requireNonNull(super.func_145831_w());
    }

    protected void checkLight() {
        this.checkLight(this.field_174879_c);
    }

    protected void checkLight(BlockPos pos) {
        this.getWorldNonnull().func_205220_G_().func_205360_a(pos, (Object)this.func_195044_w().func_177230_c(), 4);
    }

    public void setOverrideState(BlockState state) {
        this.overrideBlockState = state;
    }

    public BlockState func_195044_w() {
        if (this.overrideBlockState != null) {
            return this.overrideBlockState;
        }
        return super.func_195044_w();
    }

    public void func_145836_u() {
        BlockState old = this.func_195044_w();
        super.func_145836_u();
        BlockState newState = this.func_195044_w();
        if (old != null && newState != null && this.func_200662_C().func_223045_a(old.func_177230_c()) && !this.func_200662_C().func_223045_a(newState.func_177230_c())) {
            this.setOverrideState(old);
        }
    }

    @Override
    public void setState(BlockState state) {
        if (this.getWorldNonnull().func_180495_p(this.field_174879_c) == this.getState()) {
            this.getWorldNonnull().func_175656_a(this.field_174879_c, state);
        }
    }

    @Override
    public BlockState getState() {
        return this.func_195044_w();
    }

    @Nonnull
    public IModelData getModelData() {
        IModelData base = super.getModelData();
        if (this instanceof IEBlockInterfaces.IPropertyPassthrough) {
            return new CombinedModelData(base, new SinglePropertyModelData<TileEntity>(this, IEProperties.Model.TILEENTITY_PASSTHROUGH));
        }
        return base;
    }

    public void func_226984_a_(World world, BlockPos pos) {
        super.func_226984_a_(world, pos);
        this.redstoneBySide.clear();
    }

    protected void onNeighborBlockChange(BlockPos otherPos) {
        BlockPos delta = otherPos.func_177973_b((Vector3i)this.field_174879_c);
        Direction side = Direction.func_176737_a((float)delta.func_177958_n(), (float)delta.func_177956_o(), (float)delta.func_177952_p());
        Preconditions.checkNotNull((Object)side);
        this.updateRSForSide(side);
    }

    private void updateRSForSide(Direction side) {
        BlockState state;
        int rsStrength = this.getWorldNonnull().func_175651_c(this.field_174879_c.func_177972_a(side), side);
        if (rsStrength == 0 && this instanceof IEBlockInterfaces.IRedstoneOutput && ((IEBlockInterfaces.IRedstoneOutput)((Object)this)).canConnectRedstone(side) && (state = SafeChunkUtils.getBlockState((IWorld)this.field_145850_b, this.field_174879_c.func_177972_a(side))).func_177230_c() == Blocks.field_150488_af && (Integer)state.func_177229_b((Property)RedstoneWireBlock.field_176351_O) > rsStrength) {
            rsStrength = (Integer)state.func_177229_b((Property)RedstoneWireBlock.field_176351_O);
        }
        this.redstoneBySide.put(side, rsStrength);
    }

    protected int getRSInput(Direction from) {
        if (this.getWorldNonnull().field_72995_K || !this.redstoneBySide.containsKey(from)) {
            this.updateRSForSide(from);
        }
        return this.redstoneBySide.get(from);
    }

    protected int getMaxRSInput() {
        int ret = 0;
        for (Direction d : DirectionUtils.VALUES) {
            ret = Math.max(ret, this.getRSInput(d));
        }
        return ret;
    }

    protected boolean isRSPowered() {
        for (Direction d : DirectionUtils.VALUES) {
            if (this.getRSInput(d) <= 0) continue;
            return true;
        }
        return false;
    }
}

