/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IVertexBufferHolder;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.utils.SinglePropertyModelData;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.wooden.WindmillTileEntity;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.common.util.NonNullSupplier;

public class WindmillRenderer
extends TileEntityRenderer<WindmillTileEntity> {
    public static DynamicModel<Void> MODEL;
    private static final IVertexBufferHolder[] BUFFERS;

    public WindmillRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    private static IVertexBufferHolder getBufferHolder(int sails) {
        if (BUFFERS[sails] == null) {
            WindmillRenderer.BUFFERS[sails] = IVertexBufferHolder.create((NonNullSupplier<List<BakedQuad>>)((NonNullSupplier)() -> {
                IBakedModel model = MODEL.get(null);
                ArrayList<String> parts = new ArrayList<String>();
                parts.add("base");
                for (int i = 1; i <= sails; ++i) {
                    parts.add("sail_" + i);
                }
                SinglePropertyModelData<IEProperties.IEObjState> data = new SinglePropertyModelData<IEProperties.IEObjState>(new IEProperties.IEObjState(IEProperties.VisibilityList.show(parts)), IEProperties.Model.IE_OBJ_STATE);
                return model.getQuads(IEBlocks.WoodenDevices.windmill.func_176223_P(), null, Utils.RAND, data);
            }));
        }
        return BUFFERS[sails];
    }

    public void render(WindmillTileEntity tile, float partialTicks, MatrixStack transform, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.getWorldNonnull().func_175667_e(tile.func_174877_v())) {
            return;
        }
        transform.func_227860_a_();
        transform.func_227861_a_(0.5, 0.5, 0.5);
        float dir = tile.getFacing() == Direction.SOUTH ? 0.0f : (tile.getFacing() == Direction.NORTH ? 180.0f : (tile.getFacing() == Direction.EAST ? 90.0f : -90.0f));
        float rot = 360.0f * (tile.rotation + (!tile.canTurn || tile.rotation == 0.0f ? 0.0f : partialTicks) * tile.perTick);
        transform.func_227863_a_(new Quaternion(new Vector3f(tile.getFacing().func_176740_k() == Direction.Axis.X ? 1.0f : 0.0f, 0.0f, tile.getFacing().func_176740_k() == Direction.Axis.Z ? 1.0f : 0.0f), rot, true));
        transform.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), dir, true));
        transform.func_227861_a_(-0.5, -0.5, -0.5);
        WindmillRenderer.getBufferHolder(tile.sails).render(RenderType.func_228641_d_(), combinedLightIn, combinedOverlayIn, bufferIn, transform);
        transform.func_227865_b_();
    }

    public static void reset() {
        for (IVertexBufferHolder vbo : BUFFERS) {
            if (vbo == null) continue;
            vbo.reset();
        }
    }

    static {
        BUFFERS = new IVertexBufferHolder[9];
    }
}

