/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.AutoWorkbenchRenderer;
import blusunrize.immersiveengineering.common.blocks.wooden.ModWorkbenchTileEntity;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;

public class ModWorkbenchRenderer
extends TileEntityRenderer<ModWorkbenchTileEntity> {
    public ModWorkbenchRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(ModWorkbenchTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (te.isDummy() || !te.getWorldNonnull().func_175667_e(te.func_174877_v())) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        Direction facing = te.getFacing();
        float angle = facing == Direction.NORTH ? 0.0f : (facing == Direction.WEST ? 90.0f : (facing == Direction.EAST ? -90.0f : 180.0f));
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), angle, true));
        ItemStack stack = (ItemStack)te.getInventory().get(0);
        boolean showIngredients = true;
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof EngineersBlueprintItem) {
                matrixStack.func_227860_a_();
                double playerDistanceSq = ClientUtils.mc().field_71439_g.func_195048_a(Vector3d.func_237489_a_((Vector3i)te.func_174877_v()));
                if (playerDistanceSq < 120.0) {
                    BlueprintCraftingRecipe[] recipes = BlueprintCraftingRecipe.findRecipes(ItemNBTHelper.getString(stack, "blueprint"));
                    float lineWidth = playerDistanceSq < 25.0 ? 1.0f : (playerDistanceSq < 40.0 ? 0.5f : 0.1f);
                    int l = recipes.length;
                    int perRow = l > 6 ? l - 3 : (l > 4 ? l - 2 : (l == 1 ? 2 : (l == 2 ? 3 : l)));
                    matrixStack.func_227861_a_(0.0, 0.501, 0.0);
                    matrixStack.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), -90.0f, true));
                    matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), -22.5f, true));
                    matrixStack.func_227861_a_(0.39, l > 4 ? 0.72 : 0.78, 0.0);
                    float scale = l > 4 ? 0.009375f : 0.012f;
                    matrixStack.func_227862_a_(scale, -scale, scale);
                    int i = 0;
                    while (i < l) {
                        BlueprintCraftingRecipe recipe = recipes[i % recipes.length];
                        AutoWorkbenchRenderer.BlueprintLines blueprint = recipe == null ? null : AutoWorkbenchRenderer.getBlueprintDrawable(recipe, te.getWorldNonnull());
                        if (blueprint == null) continue;
                        double dX = i < perRow ? 0.93725 / (double)scale - (double)perRow * 16.6 + (double)i * 16.6 : 0.70375 / (double)scale - (double)(i % perRow) * 16.6;
                        double dY = i < perRow ? 0.0 : -0.15625;
                        matrixStack.func_227861_a_(dX, dY / (double)scale, 0.0);
                        float texScale = (float)blueprint.textureScale / 16.0f;
                        matrixStack.func_227862_a_(1.0f / texScale, 1.0f / texScale, 1.0f / texScale);
                        blueprint.draw(lineWidth, matrixStack, bufferIn);
                        matrixStack.func_227862_a_(texScale, texScale, texScale);
                        matrixStack.func_227861_a_(-dX, -dY / (double)scale, 0.0);
                        ++i;
                    }
                }
                matrixStack.func_227865_b_();
            } else {
                showIngredients = false;
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, 0.5625, 0.0);
                matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 180.0f, true));
                matrixStack.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), 90.0f, true));
                matrixStack.func_227861_a_(-0.875, 0.0, 0.0);
                matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
                try {
                    ClientUtils.mc().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                matrixStack.func_227865_b_();
            }
        }
        if (showIngredients) {
            for (int i = 1; i < te.getInventory().size(); ++i) {
                double dZ;
                double dX;
                if (i < 5) {
                    dX = -0.5 + (i == 2 ? -0.0625 : (i == 4 ? 0.03215 : 0.0));
                    dZ = (double)i * 0.25 - 0.625;
                } else {
                    dX = -1.25;
                    dZ = -0.125 + (double)(i - 5) * -0.25;
                }
                stack = (ItemStack)te.getInventory().get(i);
                if (stack.func_190926_b()) continue;
                matrixStack.func_227860_a_();
                matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 180.0f, true));
                matrixStack.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), 90.0f, true));
                matrixStack.func_227861_a_(dX, dZ, -0.515);
                matrixStack.func_227862_a_(0.25f, 0.25f, 0.25f);
                try {
                    ClientUtils.mc().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                matrixStack.func_227865_b_();
            }
        }
        matrixStack.func_227865_b_();
    }
}

