/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.RevolverScreen;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.data.IEDataGenerator;
import blusunrize.immersiveengineering.common.items.BuzzsawItem;
import blusunrize.immersiveengineering.common.items.ChemthrowerItem;
import blusunrize.immersiveengineering.common.items.DrillItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.IEShieldItem;
import blusunrize.immersiveengineering.common.items.RailgunItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class ItemOverlayUtils {
    public static IVertexBuilder getHudElementsBuilder(IRenderTypeBuffer.Impl buffer) {
        return buffer.getBuffer(IERenderTypes.getGui(IEDataGenerator.rl("textures/gui/hud_elements.png")));
    }

    public static void renderRevolverOverlay(IRenderTypeBuffer.Impl buffer, MatrixStack transform, int scaledWidth, int scaledHeight, PlayerEntity player, Hand hand, ItemStack equipped) {
        NonNullList<ItemStack> bullets = ((IEItemInterfaces.IBulletContainer)equipped.func_77973_b()).getBullets(equipped, true);
        if (bullets != null) {
            float cdMax;
            int cd;
            float cooldown;
            int bulletAmount = ((IEItemInterfaces.IBulletContainer)equipped.func_77973_b()).getBulletCount(equipped);
            HandSide side = hand == Hand.MAIN_HAND ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
            boolean right = side == HandSide.RIGHT;
            float dx = right ? (float)(scaledWidth - 32 - 48) : 48.0f;
            float dy = scaledHeight - 64;
            transform.func_227860_a_();
            transform.func_227860_a_();
            transform.func_227861_a_((double)dx, (double)dy, 0.0);
            transform.func_227862_a_(0.5f, 0.5f, 1.0f);
            RevolverScreen.drawExternalGUI(bullets, bulletAmount, transform);
            transform.func_227865_b_();
            if (equipped.func_77973_b() instanceof RevolverItem && (cooldown = 1.0f - (float)(cd = ((RevolverItem)equipped.func_77973_b()).getShootCooldown(equipped)) / (cdMax = (float)((RevolverItem)equipped.func_77973_b()).getMaxShootCooldown(equipped))) > 0.0f) {
                transform.func_227861_a_((double)(scaledWidth / 2 + (right ? 1 : -6)), (double)(scaledHeight / 2 - 7), 0.0);
                float h1 = (double)cooldown > 0.33 ? 0.5f : cooldown * 1.5f;
                float h2 = cooldown;
                float x2 = (double)cooldown < 0.75 ? 1.0f : 4.0f * (1.0f - cooldown);
                float uMin = (88.0f + (right ? 0.0f : 7.0f * x2)) / 256.0f;
                float uMax = (88.0f + (right ? 7.0f * x2 : 0.0f)) / 256.0f;
                float vMin1 = (112.0f + (right ? h1 : h2) * 15.0f) / 256.0f;
                float vMin2 = (112.0f + (right ? h2 : h1) * 15.0f) / 256.0f;
                IVertexBuilder builder = ItemOverlayUtils.getHudElementsBuilder(buffer);
                Matrix4f mat = transform.func_227866_c_().func_227870_a_();
                builder.func_227888_a_(mat, (right ? 0.0f : 1.0f - x2) * 7.0f, 15.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMin, 0.49609375f).func_181675_d();
                builder.func_227888_a_(mat, (right ? x2 : 1.0f) * 7.0f, 15.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMax, 0.49609375f).func_181675_d();
                builder.func_227888_a_(mat, (right ? x2 : 1.0f) * 7.0f, (right ? h2 : h1) * 15.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMax, vMin2).func_181675_d();
                builder.func_227888_a_(mat, (right ? 0.0f : 1.0f - x2) * 7.0f, (right ? h1 : h2) * 15.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMin, vMin1).func_181675_d();
            }
            transform.func_227865_b_();
        }
    }

    public static void renderRailgunOverlay(IRenderTypeBuffer.Impl buffer, MatrixStack transform, int scaledWidth, int scaledHeight, PlayerEntity player, Hand hand, ItemStack equipped) {
        int duration = 72000 - (player.func_184587_cr() && player.func_184600_cs() == hand ? player.func_184605_cv() : 0);
        int chargeTime = ((RailgunItem)equipped.func_77973_b()).getChargeTime(equipped);
        int chargeLevel = duration < 72000 ? Math.min(99, (int)((float)duration / (float)chargeTime * 100.0f)) : 0;
        float scale = 1.5f;
        IVertexBuilder builder = ItemOverlayUtils.getHudElementsBuilder(buffer);
        boolean boundLeft = player.func_184591_cq() == HandSide.RIGHT == (hand == Hand.OFF_HAND);
        float dx = boundLeft ? 24.0f : (float)(scaledWidth - 24 - 64);
        float dy = scaledHeight - 16;
        transform.func_227860_a_();
        transform.func_227861_a_((double)dx, (double)dy, 0.0);
        ClientUtils.drawTexturedRect(builder, transform, 0.0f, -32.0f, 64.0f, 32.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.25f, 0.375f, 0.5f);
        ItemStack ammo = RailgunItem.findAmmo(equipped, player);
        if (!ammo.func_190926_b()) {
            ClientUtils.renderItemWithOverlayIntoGUI((IRenderTypeBuffer)buffer, transform, ammo, 6, -22);
        }
        transform.func_227861_a_(30.0, -27.5, 0.0);
        transform.func_227862_a_(scale, scale, 1.0f);
        String chargeTxt = chargeLevel < 10 ? "0 " + chargeLevel : chargeLevel / 10 + " " + chargeLevel % 10;
        ClientUtils.font().func_228079_a_(chargeTxt, 0.0f, 0.0f, -557004, true, transform.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
        transform.func_227865_b_();
    }

    public static void renderFluidTankOverlay(IRenderTypeBuffer.Impl buffer, MatrixStack transform, int scaledWidth, int scaledHeight, PlayerEntity player, Hand hand, ItemStack equipped, boolean renderFluidUse, BiConsumer<IVertexBuilder, IFluidHandlerItem> additionalRender) {
        IVertexBuilder builder = ItemOverlayUtils.getHudElementsBuilder(buffer);
        int rightOffset = 0;
        if (ClientUtils.mc().field_71474_y.field_186717_N) {
            rightOffset += 100;
        }
        float dx = scaledWidth - rightOffset - 16;
        float dy = scaledHeight;
        transform.func_227860_a_();
        transform.func_227861_a_((double)dx, (double)dy, 0.0);
        int w = 31;
        int h = 62;
        float uMin = 0.69921875f;
        float uMax = 0.8203125f;
        float vMin = 0.03515625f;
        float vMax = 0.27734375f;
        ClientUtils.drawTexturedRect(builder, transform, -24.0f, -68.0f, w, h, 1.0f, 1.0f, 1.0f, 1.0f, uMin, uMax, vMin, vMax);
        transform.func_227861_a_(-23.0, -37.0, 0.0);
        LazyOptional handlerOpt = FluidUtil.getFluidHandler((ItemStack)equipped);
        handlerOpt.ifPresent(handler -> {
            int capacity = -1;
            if (handler.getTanks() > 0) {
                capacity = handler.getTankCapacity(0);
            }
            if (capacity > 0) {
                FluidStack fuel = handler.getFluidInTank(0);
                int amount = fuel.getAmount();
                if (renderFluidUse && player.func_184587_cr() && player.func_184600_cs() == hand) {
                    int use = player.func_184612_cw();
                    amount -= use * (Integer)IEServerConfig.TOOLS.chemthrower_consumption.get();
                }
                float cap = capacity;
                float angle = 83.0f - (float)(166 * amount) / cap;
                transform.func_227860_a_();
                transform.func_227863_a_(new Quaternion(0.0f, 0.0f, angle, true));
                ClientUtils.drawTexturedRect(builder, transform, 6.0f, -2.0f, 24.0f, 4.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.35546875f, 0.48046875f, 0.3125f, 0.33984375f);
                transform.func_227865_b_();
                transform.func_227861_a_(23.0, 37.0, 0.0);
                additionalRender.accept(builder, (IFluidHandlerItem)handler);
            }
        });
        transform.func_227865_b_();
    }

    public static void renderDrillOverlay(IRenderTypeBuffer.Impl buffer, MatrixStack transform, int scaledWidth, int scaledHeight, PlayerEntity player, Hand hand, ItemStack equipped) {
        ItemOverlayUtils.renderFluidTankOverlay(buffer, transform, scaledWidth, scaledHeight, player, hand, equipped, false, (builder, handler) -> {
            ClientUtils.drawTexturedRect(builder, transform, -54.0f, -73.0f, 66.0f, 72.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.421875f, 0.6796875f, 0.015625f, 0.296875f);
            ItemStack head = ((DrillItem)equipped.func_77973_b()).getHead(equipped);
            if (!head.func_190926_b()) {
                ClientUtils.renderItemWithOverlayIntoGUI((IRenderTypeBuffer)buffer, transform, head, -51, -45);
            }
        });
    }

    public static void renderBuzzsawOverlay(IRenderTypeBuffer.Impl buffer, MatrixStack transform, int scaledWidth, int scaledHeight, PlayerEntity player, Hand hand, ItemStack equipped) {
        ItemOverlayUtils.renderFluidTankOverlay(buffer, transform, scaledWidth, scaledHeight, player, hand, equipped, false, (builder, handler) -> {
            ClientUtils.drawTexturedRect(builder, transform, -54.0f, -73.0f, 66.0f, 72.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.421875f, 0.6796875f, 0.015625f, 0.296875f);
            ItemStack blade = ((BuzzsawItem)equipped.func_77973_b()).getSawblade(equipped);
            if (!blade.func_190926_b()) {
                ClientUtils.renderItemWithOverlayIntoGUI((IRenderTypeBuffer)buffer, transform, blade, -51, -45);
            }
        });
    }

    public static void renderChemthrowerOverlay(IRenderTypeBuffer.Impl buffer, MatrixStack transform, int scaledWidth, int scaledHeight, PlayerEntity player, Hand hand, ItemStack equipped) {
        ItemOverlayUtils.renderFluidTankOverlay(buffer, transform, scaledWidth, scaledHeight, player, hand, equipped, true, (builder, handler) -> {
            ClientUtils.drawTexturedRect(builder, transform, -41.0f, -73.0f, 53.0f, 72.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.03125f, 0.23828125f, 0.015625f, 0.296875f);
            boolean ignite = ChemthrowerItem.isIgniteEnable(equipped);
            ClientUtils.drawTexturedRect(builder, transform, -32.0f, -43.0f, 12.0f, 12.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.2578125f, 0.3046875f, (float)(ignite ? 21 : 9) / 256.0f, (float)(ignite ? 33 : 21) / 256.0f);
            ClientUtils.drawTexturedRect(builder, transform, -100.0f, -20.0f, 64.0f, 16.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.25f, 0.296875f, 0.359375f);
            FluidStack fuel = handler.getFluidInTank(0);
            if (!fuel.isEmpty()) {
                String name = ClientUtils.font().func_238417_a_((ITextProperties)fuel.getDisplayName(), 50).getString().trim();
                ClientUtils.font().func_228079_a_(name, (float)(-68 - ClientUtils.font().func_78256_a(name) / 2), -15.0f, 0, false, transform.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
            }
        });
    }

    public static void renderShieldOverlay(IRenderTypeBuffer.Impl buffer, MatrixStack transform, int scaledWidth, int scaledHeight, PlayerEntity player, Hand hand, ItemStack equipped) {
        CompoundNBT upgrades = ((IEShieldItem)equipped.func_77973_b()).getUpgrades(equipped);
        if (!upgrades.isEmpty()) {
            float h;
            IVertexBuilder builder = ItemOverlayUtils.getHudElementsBuilder(buffer);
            boolean boundLeft = player.func_184591_cq() == HandSide.RIGHT == (hand == Hand.OFF_HAND);
            float dx = boundLeft ? 16.0f : (float)(scaledWidth - 16 - 64);
            float dy = scaledHeight;
            transform.func_227860_a_();
            transform.func_227861_a_((double)dx, (double)dy, 0.0);
            ClientUtils.drawTexturedRect(builder, transform, 0.0f, -22.0f, 64.0f, 22.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.25f, 0.6875f, 0.7734375f);
            if (upgrades.func_74767_n("flash")) {
                ClientUtils.drawTexturedRect(builder, transform, 11.0f, -38.0f, 16.0f, 16.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.04296875f, 0.10546875f, 0.625f, 0.6875f);
                if (upgrades.func_74764_b("flash_cooldown")) {
                    h = (float)upgrades.func_74762_e("flash_cooldown") / 40.0f * 16.0f;
                    ClientUtils.drawTexturedRect(builder, transform, 11.0f, -22.0f - h, 16.0f, h, 1.0f, 1.0f, 1.0f, 1.0f, 0.04296875f, 0.10546875f, (214.0f - h) / 256.0f, 0.8359375f);
                }
            }
            if (upgrades.func_74767_n("shock")) {
                ClientUtils.drawTexturedRect(builder, transform, 40.0f, -38.0f, 12.0f, 16.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.15625f, 0.203125f, 0.625f, 0.6875f);
                if (upgrades.func_74764_b("shock_cooldown")) {
                    h = (float)upgrades.func_74762_e("shock_cooldown") / 40.0f * 16.0f;
                    ClientUtils.drawTexturedRect(builder, transform, 40.0f, -22.0f - h, 12.0f, h, 1.0f, 1.0f, 1.0f, 1.0f, 0.15625f, 0.203125f, (214.0f - h) / 256.0f, 0.8359375f);
                }
            }
            transform.func_227865_b_();
        }
    }
}

