/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class TagUtils {
    public static ITagCollection<Item> ITEM_TAG_COLLECTION = TagCollectionManager.func_242178_a().func_241836_b();
    public static ITagCollection<Block> BLOCK_TAG_COLLECTION = TagCollectionManager.func_242178_a().func_241835_a();

    public static ITag<Item> getItemTag(ResourceLocation key) {
        return ITEM_TAG_COLLECTION.func_199910_a(key);
    }

    public static ITag<Block> getBlockTag(ResourceLocation key) {
        return BLOCK_TAG_COLLECTION.func_199910_a(key);
    }

    public static Collection<ResourceLocation> getTagsForItem(Item item) {
        return ITEM_TAG_COLLECTION.func_199913_a((Object)item);
    }

    public static Collection<ResourceLocation> getTagsForBlock(Block block) {
        return BLOCK_TAG_COLLECTION.func_199913_a((Object)block);
    }

    public static boolean isInBlockOrItemTag(ItemStack stack, ResourceLocation oreName) {
        if (!TagUtils.isNonemptyBlockOrItemTag(oreName)) {
            return false;
        }
        ITag<Item> itemTag = TagUtils.getItemTag(oreName);
        if (itemTag != null && itemTag.func_230236_b_().contains(stack.func_77973_b())) {
            return true;
        }
        ITag<Block> blockTag = TagUtils.getBlockTag(oreName);
        return blockTag != null && blockTag.func_230236_b_().stream().map(IItemProvider::func_199767_j).anyMatch(i -> stack.func_77973_b() == i);
    }

    public static boolean isNonemptyItemTag(ResourceLocation name) {
        ITag<Item> t = TagUtils.getItemTag(name);
        return t != null && !t.func_230236_b_().isEmpty();
    }

    public static boolean isNonemptyBlockTag(ResourceLocation name) {
        ITag<Block> t = TagUtils.getBlockTag(name);
        return t != null && !t.func_230236_b_().isEmpty();
    }

    public static boolean isNonemptyBlockOrItemTag(ResourceLocation name) {
        return TagUtils.isNonemptyBlockTag(name) || TagUtils.isNonemptyItemTag(name);
    }

    public static NonNullList<ItemStack> getItemsInTag(ResourceLocation name) {
        NonNullList ret = NonNullList.func_191196_a();
        TagUtils.addItemsInTag((NonNullList<ItemStack>)ret, TagUtils.getItemTag(name));
        TagUtils.addItemsInTag((NonNullList<ItemStack>)ret, TagUtils.getBlockTag(name));
        return ret;
    }

    private static <T extends IItemProvider> void addItemsInTag(NonNullList<ItemStack> out, ITag<T> in) {
        if (in != null) {
            in.func_230236_b_().stream().map(ItemStack::new).forEach(arg_0 -> out.add(arg_0));
        }
    }

    public static boolean isInPrefixedTag(ItemStack stack, String componentType) {
        return TagUtils.getMatchingPrefix(stack, componentType) != null;
    }

    public static String getMatchingPrefix(ItemStack stack, String ... componentTypes) {
        for (ResourceLocation name : TagUtils.getMatchingTagNames(stack)) {
            for (String componentType : componentTypes) {
                if (!name.func_110623_a().startsWith(componentType)) continue;
                return componentType;
            }
        }
        return null;
    }

    public static Collection<ResourceLocation> getMatchingTagNames(ItemStack stack) {
        HashSet<ResourceLocation> ret = new HashSet<ResourceLocation>(TagUtils.getTagsForItem(stack.func_77973_b()));
        Block b = Block.func_149634_a((Item)stack.func_77973_b());
        if (b != Blocks.field_150350_a) {
            ret.addAll(TagUtils.getTagsForBlock(b));
        }
        return ret;
    }

    public static String[] getMatchingPrefixAndRemaining(ItemStack stack, String ... componentTypes) {
        for (ResourceLocation name : TagUtils.getMatchingTagNames(stack)) {
            for (String componentType : componentTypes) {
                if (!name.func_110623_a().startsWith(componentType)) continue;
                String material = name.func_110623_a().substring(componentType.length());
                if (material.startsWith("/")) {
                    material = material.substring(1);
                }
                if (material.length() <= 0) continue;
                return new String[]{componentType, material};
            }
        }
        return null;
    }

    public static boolean isIngot(ItemStack stack) {
        return TagUtils.isInPrefixedTag(stack, "ingots/");
    }

    public static boolean isPlate(ItemStack stack) {
        return TagUtils.isInPrefixedTag(stack, "plates/");
    }
}

