/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;

public class ArcFurnaceRecipe
extends MultiblockRecipe {
    public static IRecipeType<ArcFurnaceRecipe> TYPE = IRecipeType.func_222147_a((String)"immersiveengineering:arc_furnace");
    public static RegistryObject<IERecipeSerializer<ArcFurnaceRecipe>> SERIALIZER;
    public final IngredientWithSize input;
    public final IngredientWithSize[] additives;
    public final NonNullList<ItemStack> output;
    @Nonnull
    public final ItemStack slag;
    public String specialRecipeType;
    public static List<String> specialRecipeTypes;
    public static Map<ResourceLocation, ArcFurnaceRecipe> recipeList;
    private static final Set<IRecipeType<?>> RECYCLING_RECIPE_TYPES;
    private static final List<Predicate<ItemStack>> RECYCLING_ALLOWED;
    private static final List<Predicate<ItemStack>> INVALID_RECYCLING_OUTPUTS;

    public ArcFurnaceRecipe(ResourceLocation id, NonNullList<ItemStack> output, IngredientWithSize input, @Nonnull ItemStack slag, int time, int energy, IngredientWithSize ... additives) {
        super((ItemStack)output.get(0), TYPE, id);
        this.output = output;
        this.input = input;
        this.slag = slag;
        this.setTimeAndEnergy(time, energy);
        this.additives = additives;
        ArrayList inputList = Lists.newArrayList((Object[])new IngredientWithSize[]{this.input});
        if (this.additives.length > 0) {
            inputList.addAll(Lists.newArrayList((Object[])this.additives));
        }
        this.setInputListWithSizes(inputList);
        this.outputList = this.output;
    }

    @Override
    protected IERecipeSerializer<ArcFurnaceRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    public NonNullList<ItemStack> getOutputs(ItemStack input, NonNullList<ItemStack> additives) {
        return this.output;
    }

    public boolean matches(ItemStack input, NonNullList<ItemStack> additives) {
        if (this.input != null && this.input.test(input)) {
            int[] consumed = this.getConsumedAdditives(additives, false);
            return consumed != null;
        }
        return false;
    }

    public int[] getConsumedAdditives(NonNullList<ItemStack> additives, boolean consume) {
        int[] consumed = new int[additives.size()];
        for (IngredientWithSize add : this.additives) {
            if (add == null) continue;
            int addAmount = add.getCount();
            Iterator it = additives.iterator();
            int i = 0;
            while (it.hasNext()) {
                ItemStack query = (ItemStack)it.next();
                if (!query.func_190926_b()) {
                    if (add.test(query)) {
                        if (query.func_190916_E() > addAmount) {
                            query.func_190918_g(addAmount);
                            consumed[i] = addAmount;
                            addAmount = 0;
                        } else {
                            addAmount -= query.func_190916_E();
                            consumed[i] = query.func_190916_E();
                            query.func_190920_e(0);
                        }
                    }
                    if (addAmount <= 0) break;
                }
                ++i;
            }
            if (addAmount <= 0) continue;
            for (int j = 0; j < consumed.length; ++j) {
                ((ItemStack)additives.get(j)).func_190917_f(consumed[j]);
            }
            return null;
        }
        if (!consume) {
            for (int j = 0; j < consumed.length; ++j) {
                ((ItemStack)additives.get(j)).func_190917_f(consumed[j]);
            }
        }
        return consumed;
    }

    public boolean isValidInput(ItemStack stack) {
        return this.input != null && this.input.test(stack);
    }

    public boolean isValidAdditive(ItemStack stack) {
        for (IngredientWithSize add : this.additives) {
            if (add == null || !add.test(stack)) continue;
            return true;
        }
        return false;
    }

    public ArcFurnaceRecipe setSpecialRecipeType(String type) {
        this.specialRecipeType = type;
        if (!specialRecipeTypes.contains(type)) {
            specialRecipeTypes.add(type);
        }
        return this;
    }

    public static ArcFurnaceRecipe findRecipe(ItemStack input, NonNullList<ItemStack> additives) {
        for (ArcFurnaceRecipe recipe : recipeList.values()) {
            if (recipe == null || !recipe.matches(input, additives)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean isValidRecipeInput(ItemStack stack) {
        for (ArcFurnaceRecipe recipe : recipeList.values()) {
            if (recipe == null || !recipe.isValidInput(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidRecipeAdditive(ItemStack stack) {
        for (ArcFurnaceRecipe recipe : recipeList.values()) {
            if (recipe == null || !recipe.isValidAdditive(stack)) continue;
            return true;
        }
        return false;
    }

    public static void allowRecipeTypeForRecycling(IRecipeType<?> recipeType) {
        RECYCLING_RECIPE_TYPES.add(recipeType);
    }

    public static void allowItemForRecycling(Predicate<ItemStack> predicate) {
        RECYCLING_ALLOWED.add(predicate);
    }

    public static void makeItemInvalidRecyclingOutput(Predicate<ItemStack> predicate) {
        INVALID_RECYCLING_OUTPUTS.add(predicate);
    }

    public static boolean canRecycle(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (Predicate<ItemStack> predicate : RECYCLING_ALLOWED) {
            if (!predicate.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidRecyclingOutput(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (Predicate<ItemStack> predicate : INVALID_RECYCLING_OUTPUTS) {
            if (!predicate.test(stack)) continue;
            return false;
        }
        return true;
    }

    public static Predicate<IRecipe<?>> assembleRecyclingFilter() {
        return iRecipe -> {
            if (!RECYCLING_RECIPE_TYPES.contains(iRecipe.func_222127_g())) {
                return false;
            }
            return ArcFurnaceRecipe.canRecycle(iRecipe.func_77571_b());
        };
    }

    static {
        specialRecipeTypes = new ArrayList<String>();
        recipeList = Collections.emptyMap();
        RECYCLING_RECIPE_TYPES = new HashSet();
        RECYCLING_ALLOWED = new ArrayList<Predicate<ItemStack>>();
        INVALID_RECYCLING_OUTPUTS = new ArrayList<Predicate<ItemStack>>();
    }
}

