/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.yungnickyoung.minecraft.yungsapi.json.BiomeDictionaryTypeAdapter;
import com.yungnickyoung.minecraft.yungsapi.json.BlockSetSelectorAdapter;
import com.yungnickyoung.minecraft.yungsapi.json.BlockStateAdapter;
import com.yungnickyoung.minecraft.yungsapi.world.BlockSetSelector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.block.BlockState;
import net.minecraftforge.common.BiomeDictionary;

public class JSON {
    private static Gson gson;

    private JSON() {
    }

    public static String toJsonString(Object object) {
        return gson.toJson(object);
    }

    public static void createJsonFileFromObject(Path path, Object object) throws IOException {
        String jsonString = gson.toJson(object);
        Files.write(path, jsonString.getBytes(), new OpenOption[0]);
    }

    public static <T> T loadObjectFromJsonFile(Path path, Class<T> objectClass) throws IOException {
        BufferedReader reader = Files.newBufferedReader(path);
        Object jsonObject = gson.fromJson((Reader)reader, objectClass);
        ((Reader)reader).close();
        return (T)jsonObject;
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeHierarchyAdapter(BlockState.class, (Object)new BlockStateAdapter());
        gsonBuilder.registerTypeHierarchyAdapter(BlockSetSelector.class, (Object)new BlockSetSelectorAdapter());
        gsonBuilder.registerTypeHierarchyAdapter(BiomeDictionary.Type.class, (Object)new BiomeDictionaryTypeAdapter());
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.disableHtmlEscaping();
        gson = gsonBuilder.create();
    }
}

