/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldConnectionManager;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointsSort;

public class WaypointWorldRootContainer
extends WaypointWorldContainer {
    public boolean configLoaded = false;
    private boolean usingMultiworldDetection = false;
    private boolean ignoreServerLevelId = false;
    private String defaultMultiworldId;
    private boolean teleportationEnabled = true;
    private boolean usingDefaultTeleportCommand = true;
    private String teleportCommand;
    private WaypointsSort sortType = WaypointsSort.NONE;
    private boolean sortReversed;
    private WaypointWorldConnectionManager subWorldConnections;

    public WaypointWorldRootContainer(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, String key) {
        super(modMain, minimapSession, key);
        this.updateConnectionsField(minimapSession);
    }

    public void updateConnectionsField(XaeroMinimapSession minimapSession) {
        this.subWorldConnections = minimapSession.getWaypointsManager().isMultiplayer(this.key) ? new WaypointWorldConnectionManager() : new WaypointWorldConnectionManager(){

            @Override
            public boolean isConnected(WaypointWorld world1, WaypointWorld world2) {
                return true;
            }

            @Override
            public void save(PrintWriter writer) {
            }
        };
    }

    private File getConfigFile() {
        Path directoryPath = this.getDirectory().toPath();
        try {
            Files.createDirectories(directoryPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return directoryPath.resolve("config.txt").toFile();
    }

    public void saveConfig() {
        File configFile = this.getConfigFile();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(configFile));
            writer.println("usingMultiworldDetection:" + this.usingMultiworldDetection);
            writer.println("ignoreServerLevelId:" + this.ignoreServerLevelId);
            if (this.defaultMultiworldId != null) {
                writer.println("defaultMultiworldId:" + this.defaultMultiworldId);
            }
            writer.println("teleportationEnabled:" + this.teleportationEnabled);
            writer.println("usingDefaultTeleportCommand:" + this.usingDefaultTeleportCommand);
            if (this.teleportCommand != null) {
                writer.println("teleportCommand:" + this.teleportCommand.replace(":", "^col^"));
            }
            writer.println("sortType:" + this.sortType.name());
            writer.println("sortReversed:" + this.sortReversed);
            this.subWorldConnections.save(writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (writer != null) {
            writer.close();
        }
    }

    public void loadConfig() {
        this.configLoaded = true;
        File configFile = this.getConfigFile();
        if (!configFile.exists()) {
            this.saveConfig();
            return;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(configFile));
            while ((line = reader.readLine()) != null) {
                String[] args = line.split(":");
                if (args[0].equals("usingMultiworldDetection")) {
                    this.usingMultiworldDetection = args[1].equals("true");
                    continue;
                }
                if (args[0].equals("ignoreServerLevelId")) {
                    this.ignoreServerLevelId = args[1].equals("true");
                    continue;
                }
                if (args[0].equals("defaultMultiworldId")) {
                    this.defaultMultiworldId = args[1];
                    continue;
                }
                if (args[0].equals("teleportationEnabled")) {
                    this.teleportationEnabled = args[1].equals("true");
                    continue;
                }
                if (args[0].equals("usingDefaultTeleportCommand")) {
                    this.usingDefaultTeleportCommand = args[1].equals("true");
                    continue;
                }
                if (args[0].equals("teleportCommand")) {
                    this.teleportCommand = args[1].replace("^col^", ":");
                    continue;
                }
                if (args[0].equals("sortType")) {
                    this.sortType = WaypointsSort.valueOf(args[1]);
                    continue;
                }
                if (args[0].equals("sortReversed")) {
                    this.sortReversed = args[1].equals("true");
                    continue;
                }
                if (!args[0].equals("connection")) continue;
                String worldKey1 = args[1];
                String worldKey2 = args[2];
                this.subWorldConnections.addConnection(worldKey1, worldKey2);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isUsingMultiworldDetection() {
        return this.usingMultiworldDetection;
    }

    public void setUsingMultiworldDetection(boolean usingMultiworldDetection) {
        this.usingMultiworldDetection = usingMultiworldDetection;
    }

    public String getDefaultMultiworldId() {
        return this.defaultMultiworldId;
    }

    public void setDefaultMultiworldId(String defaultMultiworldId) {
        this.defaultMultiworldId = defaultMultiworldId;
    }

    public boolean isTeleportationEnabled() {
        return this.teleportationEnabled;
    }

    public void setTeleportationEnabled(boolean teleportation) {
        this.teleportationEnabled = teleportation;
    }

    public boolean isUsingDefaultTeleportCommand() {
        return this.usingDefaultTeleportCommand;
    }

    public void setUsingDefaultTeleportCommand(boolean usingDefaultTeleportCommand) {
        this.usingDefaultTeleportCommand = usingDefaultTeleportCommand;
    }

    public String getTeleportCommand() {
        return this.teleportCommand;
    }

    public void setTeleportCommand(String teleportCommand) {
        this.teleportCommand = teleportCommand;
    }

    public WaypointsSort getSortType() {
        return this.sortType;
    }

    public void toggleSortType() {
        this.sortType = WaypointsSort.values()[(this.sortType.ordinal() + 1) % WaypointsSort.values().length];
    }

    public boolean isSortReversed() {
        return this.sortReversed;
    }

    public void toggleSortReversed() {
        this.sortReversed = !this.sortReversed;
    }

    public boolean isIgnoreServerLevelId() {
        return this.ignoreServerLevelId;
    }

    public WaypointWorldConnectionManager getSubWorldConnections() {
        return this.subWorldConnections;
    }
}

