/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;

public class EntityIconModelPartsRenderer {
    public Method ageableModelHeadPartsMethod;
    public Method ageableModelBodyPartsMethod;
    public Method segmentedModelPartsMethod;
    private Field cubeListField;

    public EntityIconModelPartsRenderer() {
        try {
            this.ageableModelHeadPartsMethod = AgeableModel.class.getDeclaredMethod("func_225602_a_", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                this.ageableModelHeadPartsMethod = AgeableModel.class.getDeclaredMethod("getHeadParts", new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
        }
        try {
            this.ageableModelBodyPartsMethod = AgeableModel.class.getDeclaredMethod("func_225600_b_", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                this.ageableModelBodyPartsMethod = AgeableModel.class.getDeclaredMethod("getBodyParts", new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
        }
        try {
            this.segmentedModelPartsMethod = SegmentedModel.class.getDeclaredMethod("func_225601_a_", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                this.segmentedModelPartsMethod = SegmentedModel.class.getDeclaredMethod("getParts", new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
        }
        try {
            this.cubeListField = ModelRenderer.class.getDeclaredField("field_78804_l");
        }
        catch (NoSuchFieldException e) {
            try {
                this.cubeListField = ModelRenderer.class.getDeclaredField("cubeList");
            }
            catch (NoSuchFieldException e1) {
                e1.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectList<ModelRenderer.ModelBox> getCubeList(ModelRenderer modelRenderer) {
        boolean accessibleBU = this.cubeListField.isAccessible();
        this.cubeListField.setAccessible(true);
        try {
            ObjectList objectList = (ObjectList)this.cubeListField.get(modelRenderer);
            return objectList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.cubeListField.setAccessible(accessibleBU);
        }
        return null;
    }

    public void renderPart(MatrixStack matrixStack, IVertexBuilder vertexBuilder, ModelRenderer mr, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainModelPart, float r, float g, float b, float a) {
        if (mr == null) {
            return;
        }
        if (renderedModels.contains(mr)) {
            return;
        }
        float rotationPointBUX = mr.field_78800_c;
        float rotationPointBUY = mr.field_78797_d;
        float rotationPointBUZ = mr.field_78798_e;
        float rotateAngleBUX = mr.field_78795_f;
        float rotateAngleBUY = mr.field_78796_g;
        float rotateAngleBUZ = mr.field_78808_h;
        float centerPointX = mainModelPart.field_78800_c;
        float centerPointY = mainModelPart.field_78797_d;
        float centerPointZ = mainModelPart.field_78798_e;
        ObjectList<ModelRenderer.ModelBox> mainCubeList = this.getCubeList(mainModelPart);
        if (mainCubeList != null && !mainCubeList.isEmpty()) {
            ModelRenderer.ModelBox firstBox = (ModelRenderer.ModelBox)mainCubeList.get(0);
            centerPointX += (firstBox.field_78248_d + firstBox.field_78252_a) / 2.0f;
            centerPointY += (firstBox.field_78249_e + firstBox.field_78250_b) / 2.0f;
        }
        mr.func_78793_a(mr.field_78800_c - centerPointX, mr.field_78797_d - centerPointY, mr.field_78798_e - centerPointZ);
        mr.field_78795_f = 0.0f;
        mr.field_78796_g = 0.0f;
        mr.field_78808_h = 0.0f;
        mr.func_228309_a_(matrixStack, vertexBuilder, 0xF000F0, OverlayTexture.field_229196_a_, r, g, b, a);
        mr.field_78800_c = rotationPointBUX;
        mr.field_78797_d = rotationPointBUY;
        mr.field_78798_e = rotationPointBUZ;
        mr.field_78795_f = rotateAngleBUX;
        mr.field_78796_g = rotateAngleBUY;
        mr.field_78808_h = rotateAngleBUZ;
        renderedModels.add(mr);
    }

    public ModelRenderer renderDeclaredMethod(MatrixStack matrixStack, IVertexBuilder vertexBuilder, Method m, EntityModel entityModel, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, float r, float g, float b, float a) {
        Iterable<ModelRenderer> renderers = this.handleDeclaredMethod(m, entityModel);
        return this.renderPartsIterable(renderers, matrixStack, vertexBuilder, renderedModels, mainPart, r, g, b, a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<ModelRenderer> handleDeclaredMethod(Method m, EntityModel entityModel) {
        if (m != null) {
            boolean accessibleBU = m.isAccessible();
            m.setAccessible(true);
            try {
                Iterable iterable = (Iterable)m.invoke((Object)entityModel, new Object[0]);
                return iterable;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                m.setAccessible(accessibleBU);
            }
        }
        return null;
    }

    public ModelRenderer renderPartsIterable(Iterable<ModelRenderer> parts, MatrixStack matrixStack, IVertexBuilder vertexBuilder, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, float r, float g, float b, float a) {
        if (parts == null) {
            return mainPart;
        }
        Iterator<ModelRenderer> partsIterator = parts.iterator();
        if (partsIterator.hasNext()) {
            if (mainPart == null) {
                mainPart = partsIterator.next();
                this.renderPart(matrixStack, vertexBuilder, mainPart, renderedModels, mainPart, r, g, b, a);
            }
            while (partsIterator.hasNext()) {
                this.renderPart(matrixStack, vertexBuilder, partsIterator.next(), renderedModels, mainPart, r, g, b, a);
            }
        }
        return mainPart;
    }
}

