/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.MinimapRadar;
import xaero.common.minimap.region.MinimapChunk;
import xaero.common.minimap.render.MinimapRenderer;
import xaero.common.minimap.render.radar.EntityIconManager;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.minimap.write.MinimapWriter;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;

public class MinimapFBORenderer
extends MinimapRenderer {
    private ImprovedFramebuffer scalingFramebuffer;
    private ImprovedFramebuffer rotationFramebuffer;
    private EntityIconManager entityIconManager;
    private boolean triedFBO;
    private boolean loadedFBO;

    public MinimapFBORenderer(IXaeroMinimap modMain, Minecraft mc, WaypointsGuiRenderer waypointsGuiRenderer, MinimapInterface minimapInterface) {
        super(modMain, mc, waypointsGuiRenderer, minimapInterface);
    }

    public void loadFrameBuffer(MinimapProcessor minimapProcessor) {
        if (!minimapProcessor.canUseFrameBuffer()) {
            System.out.println("FBO mode not supported! Using minimap safe mode.");
        } else {
            this.scalingFramebuffer = new ImprovedFramebuffer(512, 512, false);
            this.rotationFramebuffer = new ImprovedFramebuffer(512, 512, false);
            this.rotationFramebuffer.func_147607_a(9729);
            this.loadedFBO = this.scalingFramebuffer.field_147616_f != -1 && this.rotationFramebuffer.field_147616_f != -1;
            this.entityIconManager = new EntityIconManager(new EntityIconPrerenderer());
        }
        this.triedFBO = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderChunks(XaeroMinimapSession minimapSession, MatrixStack matrixStack, MinimapProcessor minimap, int mapSize, int bufferSize, float sizeFix, float partial, int lightLevel, boolean useWorldMap, boolean lockedNorth, double ps, double pc) {
        MinimapWriter minimapWriter = minimap.getMinimapWriter();
        synchronized (minimapWriter) {
            this.renderChunksToFBO(minimapSession, matrixStack, minimap, (PlayerEntity)this.mc.field_71439_g, this.mc.func_175606_aa(), bufferSize, mapSize, sizeFix, partial, lightLevel, true, useWorldMap, lockedNorth, ps, pc);
        }
        Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        GlStateManager.func_227714_e_((int)0, (int)0, (int)Minecraft.func_71410_x().func_147110_a().field_147621_c, (int)Minecraft.func_71410_x().func_147110_a().field_147618_d);
        this.rotationFramebuffer.func_147612_c();
    }

    public void renderChunksToFBO(XaeroMinimapSession minimapSession, MatrixStack matrixStack, MinimapProcessor minimap, PlayerEntity player, Entity renderEntity, int bufferSize, int viewW, float sizeFix, float partial, int level, boolean retryIfError, boolean useWorldMap, boolean lockedNorth, double ps, double pc) {
        double zInsidePixel;
        double maxVisibleLength = lockedNorth ? (double)viewW : (double)viewW * Math.sqrt(2.0);
        int radius = (int)Math.ceil(maxVisibleLength / 2.0 / this.zoom / 64.0);
        double playerX = minimap.getEntityRadar().getEntityX(renderEntity, partial);
        double playerZ = minimap.getEntityRadar().getEntityZ(renderEntity, partial);
        int xFloored = OptimizedMath.myFloor(playerX);
        int zFloored = OptimizedMath.myFloor(playerZ);
        int playerChunkX = xFloored >> 6;
        int playerChunkZ = zFloored >> 6;
        int offsetX = xFloored & 0x3F;
        int offsetZ = zFloored & 0x3F;
        boolean zooming = (double)((int)this.zoom) != this.zoom;
        this.scalingFramebuffer.func_147610_a(true);
        GL11.glClear((int)16640);
        GlStateManager.func_227619_H_();
        RenderHelper.func_74518_a();
        long before = System.currentTimeMillis();
        GlStateManager.func_227658_a_((int)256, (boolean)Minecraft.field_142025_a);
        RenderSystem.matrixMode((int)5889);
        this.helper.defaultOrtho();
        RenderSystem.matrixMode((int)5888);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        before = System.currentTimeMillis();
        double xInsidePixel = minimap.getEntityRadar().getEntityX(renderEntity, partial) - (double)xFloored;
        if (xInsidePixel < 0.0) {
            xInsidePixel += 1.0;
        }
        if ((zInsidePixel = minimap.getEntityRadar().getEntityZ(renderEntity, partial) - (double)zFloored) < 0.0) {
            zInsidePixel += 1.0;
        }
        float halfWView = (float)viewW / 2.0f;
        float angle = (float)(90.0 - this.getRenderAngle(renderEntity, lockedNorth, partial));
        RenderSystem.enableBlend();
        RenderSystem.translatef((float)256.0f, (float)256.0f, (float)-2000.0f);
        RenderSystem.scaled((double)this.zoom, (double)this.zoom, (double)1.0);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)-256, (int)-256, (int)256, (int)256, (int)-16777216);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (useWorldMap) {
            this.modMain.getSupportMods().worldmapSupport.drawMinimap(minimapSession, matrixStack, this.helper, xFloored, zFloored, radius, zooming, this.zoom);
        } else if (minimap.getMinimapWriter().getLoadedBlocks() != null && level >= 0) {
            int minX = playerChunkX - radius;
            int minZ = playerChunkZ - radius;
            int maxX = playerChunkX + radius + 1;
            int maxZ = playerChunkZ + radius + 1;
            for (int X = minX; X <= maxX; ++X) {
                int canvasX = X - minimap.getMinimapWriter().getLoadedMapChunkX();
                if (canvasX < 0 || canvasX >= minimap.getMinimapWriter().getLoadedBlocks().length) continue;
                for (int Z = minZ; Z <= maxZ; ++Z) {
                    MinimapChunk mchunk;
                    int canvasZ = Z - minimap.getMinimapWriter().getLoadedMapChunkZ();
                    if (canvasZ < 0 || canvasZ >= minimap.getMinimapWriter().getLoadedBlocks().length || (mchunk = minimap.getMinimapWriter().getLoadedBlocks()[canvasX][canvasZ]) == null) continue;
                    mchunk.bindTexture(level);
                    if (!mchunk.isHasSomething() || level >= mchunk.getLevelsBuffered() || mchunk.getGlTexture(level) == 0) continue;
                    if (!zooming) {
                        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    } else {
                        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    }
                    int drawX = (mchunk.getX() - playerChunkX) * 64 - offsetX;
                    int drawZ = (mchunk.getZ() - playerChunkZ) * 64 - offsetZ;
                    RenderSystem.enableBlend();
                    GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                    this.helper.drawMyTexturedModalRect(drawX, drawZ, 0, 64, 64.0f, 64.0f, -64.0f, 64.0f);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    if (this.modMain.getSettings().chunkGrid > -1) {
                        int grid = ModSettings.COLORS[this.modMain.getSettings().chunkGrid];
                        r = grid >> 16 & 0xFF;
                        g = grid >> 8 & 0xFF;
                        b = grid & 0xFF;
                    }
                    for (int t = 0; t < 16; ++t) {
                        if (mchunk.getTile(t % 4, t / 4) == null || !this.modMain.getSettings().getSlimeChunks(minimapSession.getWaypointsManager()) || !mchunk.getTile(t % 4, t / 4).isSlimeChunk()) continue;
                        int slimeDrawX = drawX + 16 * (t % 4);
                        int slimeDrawZ = drawZ + 16 * (t / 4);
                        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)slimeDrawX, (int)slimeDrawZ, (int)(slimeDrawX + 16), (int)(slimeDrawZ + 16), (int)-2142047936);
                    }
                    if (this.modMain.getSettings().chunkGrid > -1) {
                        float top;
                        RenderSystem.disableTexture();
                        RenderSystem.enableBlend();
                        RenderSystem.pushMatrix();
                        RenderSystem.translatef((float)(drawX + 64), (float)(drawZ + 64), (float)0.0f);
                        RenderSystem.scaled((double)(1.0 / this.zoom), (double)(1.0 / this.zoom), (double)1.0);
                        RenderSystem.color4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)0.5f);
                        float left = top = (float)(-64.0 * this.zoom);
                        this.helper.drawMyColoredRect(left, -1.0f, 0.0f, 0.0f);
                        this.helper.drawMyColoredRect(left, (float)(-16.0 * this.zoom) - 1.0f, 0.0f, (float)(-16.0 * this.zoom));
                        this.helper.drawMyColoredRect(left, (float)(-32.0 * this.zoom) - 1.0f, 0.0f, (float)(-32.0 * this.zoom));
                        this.helper.drawMyColoredRect(left, (float)(-48.0 * this.zoom) - 1.0f, 0.0f, (float)(-48.0 * this.zoom));
                        this.helper.drawMyColoredRect(-1.0f, top, 0.0f, 0.0f);
                        this.helper.drawMyColoredRect((float)(-16.0 * this.zoom) - 1.0f, top, (float)(-16.0 * this.zoom), 0.0f);
                        this.helper.drawMyColoredRect((float)(-32.0 * this.zoom) - 1.0f, top, (float)(-32.0 * this.zoom), 0.0f);
                        this.helper.drawMyColoredRect((float)(-48.0 * this.zoom) - 1.0f, top, (float)(-48.0 * this.zoom), 0.0f);
                        RenderSystem.popMatrix();
                        RenderSystem.disableBlend();
                        RenderSystem.enableTexture();
                    }
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        }
        this.scalingFramebuffer.func_147609_e();
        this.rotationFramebuffer.func_147610_a(false);
        GL11.glClear((int)16640);
        this.scalingFramebuffer.func_147612_c();
        RenderSystem.loadIdentity();
        if (this.modMain.getSettings().getAntiAliasing()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        RenderSystem.translatef((float)halfWView, (float)halfWView, (float)-2000.0f);
        GL11.glPushMatrix();
        if (!lockedNorth) {
            GL11.glRotatef((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        RenderSystem.translated((double)(-xInsidePixel * this.zoom), (double)(-zInsidePixel * this.zoom), (double)0.0);
        RenderSystem.disableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(this.modMain.getSettings().minimapOpacity / 100.0)));
        this.helper.drawMyTexturedModalRect(-256.0f, -256.0f, 0, 0, 512.0f, 512.0f, 512.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        before = System.currentTimeMillis();
        GlStateManager.func_227700_d_();
        GlStateManager.func_227639_a_((int)516, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)1);
        GlStateManager.func_227674_b_((int)519);
        GlStateManager.func_227674_b_((int)515);
        GlStateManager.func_227667_a_((boolean)false);
        GlStateManager.func_227667_a_((boolean)true);
        GlStateManager.func_227760_t_((int)1);
        GlStateManager.func_227760_t_((int)0);
        this.mc.func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
        if (this.modMain.getSettings().getSmoothDots()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        GlStateManager.func_227709_e_();
        GlStateManager.func_227639_a_((int)516, (float)0.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        PlayerEntity p = player;
        ModSettings settings = this.modMain.getSettings();
        MinimapRadar minimapRadar = minimap.getEntityRadar();
        this.renderEntityListToFBO(matrixStack, minimap, p, renderEntity, minimapRadar.getEntitiesIterator(), ps, pc, playerX, playerZ, partial, settings.otherNames, 0, minimapRadar, settings, lockedNorth);
        this.renderEntityListToFBO(matrixStack, minimap, p, renderEntity, minimapRadar.getItemsIterator(), ps, pc, playerX, playerZ, partial, settings.itemNames, 0, minimapRadar, settings, lockedNorth);
        this.renderEntityListToFBO(matrixStack, minimap, p, renderEntity, minimapRadar.getLivingIterator(), ps, pc, playerX, playerZ, partial, settings.friendlyMobNames, settings.mobIcons, minimapRadar, settings, lockedNorth);
        this.renderEntityListToFBO(matrixStack, minimap, p, renderEntity, minimapRadar.getHostileIterator(), ps, pc, playerX, playerZ, partial, settings.hostileMobNames, settings.hostileIcons, minimapRadar, settings, lockedNorth);
        this.renderEntityListToFBO(matrixStack, minimap, p, renderEntity, minimapRadar.getLivingTamedIterator(), ps, pc, playerX, playerZ, partial, settings.tamedMobNames, settings.tamedIcons, minimapRadar, settings, lockedNorth);
        this.renderEntityListToFBO(matrixStack, minimap, p, renderEntity, minimapRadar.getPlayersIterator(), ps, pc, playerX, playerZ, partial, settings.playerNames, settings.playerIcons, minimapRadar, settings, lockedNorth);
        this.renderEntityListToFBO(matrixStack, minimap, p, renderEntity, minimapRadar.getPlayersOtherTeamsIterator(), ps, pc, playerX, playerZ, partial, settings.otherTeamsNames == 3 ? settings.playerNames : settings.otherTeamsNames, settings.playerIcons, minimapRadar, settings, lockedNorth);
        this.mc.func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
        if (this.modMain.getSettings().mainEntityAs == 1) {
            this.renderEntityDotToFBO(matrixStack, minimap, p, renderEntity, renderEntity, ps, pc, playerX, playerZ, partial, false, false, minimapRadar, lockedNorth);
        }
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GlStateManager.func_227700_d_();
        RenderSystem.defaultAlphaFunc();
        this.rotationFramebuffer.func_147609_e();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.matrixMode((int)5889);
        Misc.minecraftOrtho(this.mc);
        RenderSystem.matrixMode((int)5888);
        GL11.glPopMatrix();
    }

    public void renderEntityListToFBO(MatrixStack matrixStack, MinimapProcessor minimap, PlayerEntity p, Entity renderEntity, Iterator<Entity> iter, double ps, double pc, double playerX, double playerZ, float partial, int names, int icons, MinimapRadar minimapRadar, ModSettings settings, boolean lockedNorth) {
        boolean iconsForList;
        boolean alwaysNameTags = this.modMain.getSettings().alwaysEntityNametags;
        boolean playerListPressed = this.mc.field_71474_y.field_74321_H.func_151470_d();
        boolean namesForList = names == 1 && playerListPressed || names == 2;
        boolean bl = iconsForList = icons == 1 && playerListPressed || icons == 2;
        while (iter.hasNext()) {
            int entityType;
            Entity e = iter.next();
            if (renderEntity == e) continue;
            boolean name = namesForList;
            boolean icon = iconsForList;
            if (names == 3) {
                entityType = minimapRadar.getType(e, p, true);
                int fallbackNames = 0;
                if (entityType == 2) {
                    fallbackNames = settings.hostileMobNames;
                } else if (entityType == 3) {
                    fallbackNames = settings.friendlyMobNames;
                }
                boolean bl2 = name = fallbackNames == 1 && playerListPressed || fallbackNames == 2;
            }
            if (icons == 3) {
                entityType = minimapRadar.getType(e, p, true);
                int fallbackIcons = 0;
                if (entityType == 2) {
                    fallbackIcons = settings.hostileIcons;
                } else if (entityType == 3) {
                    fallbackIcons = settings.mobIcons;
                }
                boolean bl3 = icon = fallbackIcons == 1 && playerListPressed || fallbackIcons == 2;
            }
            if (!(e instanceof PlayerEntity)) {
                boolean bl4 = name = name || alwaysNameTags && e.func_145818_k_();
            }
            if (icon && e instanceof AbstractClientPlayerEntity) {
                this.renderPlayerHeadToFBO(matrixStack, minimap, p, renderEntity, (AbstractClientPlayerEntity)e, ps, pc, playerX, playerZ, partial, name, minimapRadar, lockedNorth);
                continue;
            }
            this.renderEntityDotToFBO(matrixStack, minimap, p, renderEntity, e, ps, pc, playerX, playerZ, partial, name, icon, minimapRadar, lockedNorth);
        }
    }

    public void renderPlayerHeadToFBO(MatrixStack matrixStack, MinimapProcessor minimap, PlayerEntity p, Entity renderEntity, AbstractClientPlayerEntity e, double ps, double pc, double playerX, double playerZ, float partial, boolean name, MinimapRadar minimapRadar, boolean lockedNorth) {
        if (!minimapRadar.shouldRenderEntity((Entity)e)) {
            return;
        }
        double offx = minimap.getEntityRadar().getEntityX((Entity)e, partial) - playerX;
        double offz = minimap.getEntityRadar().getEntityZ((Entity)e, partial) - playerZ;
        float offh = (float)(renderEntity.func_226278_cu_() - e.func_226278_cu_());
        RenderSystem.pushMatrix();
        double zoomedOffX = offx * this.zoom;
        double zoomedOffZ = offz * this.zoom;
        double translateX = ps * zoomedOffX - pc * zoomedOffZ;
        double translateY = pc * zoomedOffX + ps * zoomedOffZ;
        int roundedX = (int)Math.round(translateX);
        int roundedY = (int)Math.round(translateY);
        RenderSystem.translated((double)roundedX, (double)roundedY, (double)0.0);
        RenderSystem.scaled((double)2.0, (double)2.0, (double)1.0);
        float brightness = minimap.getEntityRadar().getEntityBrightness(offh);
        GL11.glColor3d((double)brightness, (double)brightness, (double)brightness);
        boolean flag1 = e != null && e.func_175148_a(PlayerModelPart.CAPE) && (e.func_146103_bH().getName().equals("Dinnerbone") || e.func_146103_bH().getName().equals("Grumm"));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(e.func_110306_p());
        int l2 = 8 + (flag1 ? 8 : 0);
        int i3 = 8 * (flag1 ? -1 : 1);
        GL11.glPushMatrix();
        double headsScale = this.modMain.getSettings().headsScale;
        GL11.glScaled((double)headsScale, (double)headsScale, (double)1.0);
        AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)-4, (int)-4, (int)8, (int)8, (float)8.0f, (float)l2, (int)8, (int)i3, (int)64, (int)64);
        if (e != null && e.func_175148_a(PlayerModelPart.HAT)) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(e.func_110306_p());
            int j3 = 8 + (flag1 ? 8 : 0);
            int k3 = 8 * (flag1 ? -1 : 1);
            AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)-4, (int)-4, (int)8, (int)8, (float)40.0f, (float)j3, (int)8, (int)k3, (int)64, (int)64);
        }
        GL11.glPopMatrix();
        if (name) {
            RenderSystem.pushMatrix();
            RenderSystem.scaled((double)0.5, (double)0.5, (double)1.0);
            int color = minimap.getEntityRadar().getEntityColour(p, (Entity)e, 0.0f);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String entityName = e.func_145748_c_().getString();
            int nameW = this.mc.field_71466_p.func_78256_a(entityName);
            double dotNameScale = this.modMain.getSettings().dotNameScale;
            GlStateManager.func_227670_b_((double)0.0, (double)Math.round(11.0 * headsScale), (double)0.0);
            GL11.glScaled((double)dotNameScale, (double)dotNameScale, (double)1.0);
            Misc.drawPiercingText(matrixStack, entityName.replaceAll("(\u00a7[0-9a-f])+", ""), (float)(-nameW / 2 + 1), 1.0f, -12566464, false);
            Misc.drawPiercingText(matrixStack, entityName, (float)(-nameW / 2), 0.0f, color, false);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            RenderSystem.popMatrix();
        }
        GL11.glPopMatrix();
    }

    public void renderEntityDotToFBO(MatrixStack matrixStack, MinimapProcessor minimap, PlayerEntity p, Entity renderEntity, Entity e, double ps, double pc, double playerX, double playerZ, float partial, boolean name, boolean icon, MinimapRadar minimapRadar, boolean lockedNorth) {
        double dotsScale;
        int entityHeadTexture;
        if (!minimapRadar.shouldRenderEntity(e)) {
            return;
        }
        double offx = minimapRadar.getEntityX(e, partial) - playerX;
        double offz = minimapRadar.getEntityZ(e, partial) - playerZ;
        float offh = (float)(renderEntity.func_226278_cu_() - e.func_226278_cu_());
        GL11.glPushMatrix();
        double zoomedOffX = offx * this.zoom;
        double zoomedOffZ = offz * this.zoom;
        double translateX = ps * zoomedOffX - pc * zoomedOffZ;
        double translateY = pc * zoomedOffX + ps * zoomedOffZ;
        int roundedX = (int)Math.round(translateX);
        int roundedY = (int)Math.round(translateY);
        RenderSystem.translated((double)roundedX, (double)roundedY, (double)0.0);
        int nameOffsetX = 0;
        int nameOffsetY = 0;
        GL11.glPushMatrix();
        int n = entityHeadTexture = icon ? this.entityIconManager.getEntityHeadTexture(e, this.rotationFramebuffer, this.helper) : -1;
        if (entityHeadTexture != -1) {
            RenderSystem.translated((double)(translateX - (double)roundedX), (double)(translateY - (double)roundedY), (double)0.0);
            dotsScale = this.modMain.getSettings().headsScale;
            GL11.glScaled((double)dotsScale, (double)dotsScale, (double)1.0);
            float brightness = minimapRadar.getEntityBrightness(offh);
            GlStateManager.func_227644_a_((int)1, (int)771, (int)1, (int)771);
            GlStateManager.func_227760_t_((int)entityHeadTexture);
            GlStateManager.func_227702_d_((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
            this.helper.drawMyTexturedModalRect(-32.0f, -32.0f, 0, 64, 64.0f, 64.0f, -64.0f, 64.0f);
            this.mc.func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        } else {
            dotsScale = this.modMain.getSettings().dotsScale;
            int color = minimapRadar.getEntityColour(p, e, offh);
            float f = (float)(color >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(color & 0xFF) / 255.0f;
            RenderSystem.color4f((float)f, (float)f1, (float)f2, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            double partialX = translateX - (double)roundedX;
            double partialY = translateY - (double)roundedY;
            RenderSystem.translated((double)partialX, (double)partialY, (double)0.0);
            if (this.modMain.getSettings().getSmoothDots()) {
                GL11.glScaled((double)dotsScale, (double)dotsScale, (double)1.0);
                this.helper.drawMyTexturedModalRect(-3.5f, -3.5f, 1, 88, 8.0f, 8.0f, 256.0f);
            } else {
                double dotRadius = 3.5 * (dotsScale = (double)((int)dotsScale));
                double dotRadiusPartial = dotRadius - (double)((int)dotRadius);
                nameOffsetX = partialX - dotRadiusPartial <= -0.5 ? -1 : 0;
                nameOffsetY = partialY - dotRadiusPartial < -0.5 ? -1 : 0;
                GL11.glScaled((double)dotsScale, (double)dotsScale, (double)1.0);
                this.helper.drawMyTexturedModalRect(-3.5f, -3.5f, 9, 77, 8.0f, 8.0f, 256.0f);
            }
        }
        GL11.glPopMatrix();
        if (name) {
            RenderSystem.pushMatrix();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String entityName = e.func_145748_c_().getString();
            int nameW = this.mc.field_71466_p.func_78256_a(entityName);
            int offsetY = icon ? 11 : 5;
            double dotNameScale = this.modMain.getSettings().dotNameScale;
            GlStateManager.func_227670_b_((double)nameOffsetX, (double)((long)nameOffsetY + Math.round((double)offsetY * dotsScale)), (double)0.0);
            GL11.glScaled((double)dotNameScale, (double)dotNameScale, (double)1.0);
            Misc.drawPiercingText(matrixStack, entityName.replaceAll("(\u00a7[0-9a-f])+", ""), (float)(-nameW / 2 + 1), 1.0f, -12566464, false);
            Misc.drawPiercingText(matrixStack, entityName, (float)(-nameW / 2), 0.0f, -1, false);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            GlStateManager.func_227709_e_();
            GlStateManager.func_227639_a_((int)516, (float)0.0f);
            RenderSystem.popMatrix();
            this.mc.func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
        }
        GL11.glPopMatrix();
    }

    public void deleteFramebuffers() {
        this.scalingFramebuffer.func_147608_a();
        this.rotationFramebuffer.func_147608_a();
        if (this.entityIconManager != null) {
            this.entityIconManager.reset();
        }
    }

    public boolean isLoadedFBO() {
        return this.loadedFBO;
    }

    public void setLoadedFBO(boolean loadedFBO) {
        this.loadedFBO = loadedFBO;
    }

    public boolean isTriedFBO() {
        return this.triedFBO;
    }

    public void resetEntityIcons() {
        if (this.entityIconManager != null) {
            this.entityIconManager.reset();
        }
    }
}

