/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import com.mojang.blaze3d.matrix.MatrixStack;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.interfaces.InterfaceInstance;
import xaero.common.minimap.MinimapInterface;

public class MinimapInterfaceInstance
extends InterfaceInstance {
    private XaeroMinimapSession minimapSession;
    private IXaeroMinimap modMain;

    public MinimapInterfaceInstance(MinimapInterface inter, IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        super(inter);
        this.minimapSession = minimapSession;
        this.modMain = modMain;
    }

    @Override
    public void render(MatrixStack matrixStack, int width, int height, double scale, float partial) {
        this.minimapSession.getMinimapProcessor().onRender(matrixStack, this.inter.getX(), this.inter.getY(), width, height, scale, this.getSize(), this.getW(scale), partial);
        super.render(matrixStack, width, height, scale, partial);
    }

    @Override
    public int getW(double scale) {
        return (int)((double)this.getSize() / scale * (double)this.modMain.getSettings().getMinimapScale());
    }

    @Override
    public int getH(double scale) {
        return this.getW(scale);
    }

    @Override
    public int getWC(double scale) {
        return this.getW(scale);
    }

    @Override
    public int getHC(double scale) {
        return this.getH(scale);
    }

    @Override
    public int getW0(double scale) {
        return this.getW(scale);
    }

    @Override
    public int getH0(double scale) {
        return this.getH(scale);
    }

    @Override
    public int getSize() {
        return this.minimapSession.getMinimapProcessor().getMinimapSize() + 36 + 2;
    }
}

