/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.items;

import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.compat.BaubleTools;
import mcjty.theoneprobe.items.CreativeProbe;
import mcjty.theoneprobe.items.Probe;
import mcjty.theoneprobe.items.ProbeNote;
import mcjty.theoneprobe.items.TopArmorMaterial;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;

public class ModItems {
    public static CreativeProbe creativeProbe;
    public static Probe probe;
    public static Item diamondHelmetProbe;
    public static Item goldHelmetProbe;
    public static Item ironHelmetProbe;
    public static Item probeGoggles;
    public static ProbeNote probeNote;
    public static String PROBETAG;
    public static String PROBETAG_HAND;

    public static void init() {
        probe = new Probe();
        creativeProbe = new CreativeProbe();
        TopArmorMaterial materialDiamondHelmet = new TopArmorMaterial("diamond_helmet_probe", 33, new int[]{3, 6, 8, 3}, 10, SoundEvents.field_187716_o, 2.0f, null);
        TopArmorMaterial materialGoldHelmet = new TopArmorMaterial("gold_helmet_probe", 7, new int[]{1, 3, 5, 2}, 25, SoundEvents.field_187722_q, 0.0f, null);
        TopArmorMaterial materialIronHelmet = new TopArmorMaterial("iron_helmet_probe", 15, new int[]{2, 5, 6, 2}, 9, SoundEvents.field_187725_r, 0.0f, null);
        diamondHelmetProbe = ModItems.makeHelmet(materialDiamondHelmet, 3, "diamond_helmet_probe");
        goldHelmetProbe = ModItems.makeHelmet(materialGoldHelmet, 4, "gold_helmet_probe");
        ironHelmetProbe = ModItems.makeHelmet(materialIronHelmet, 2, "iron_helmet_probe");
        probeNote = new ProbeNote();
        if (TheOneProbe.baubles) {
            probeGoggles = BaubleTools.initProbeGoggle();
        }
    }

    private static Item makeHelmet(TopArmorMaterial material, int renderIndex, String name) {
        ArmorItem item = new ArmorItem(material, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(TheOneProbe.tabProbe)){};
        item.setRegistryName(name);
        return item;
    }

    public static boolean isProbeInHand(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() == probe || stack.func_77973_b() == creativeProbe) {
            return true;
        }
        if (stack.func_77978_p() == null) {
            return false;
        }
        return stack.func_77978_p().func_74764_b(PROBETAG_HAND);
    }

    private static boolean isProbeHelmet(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77978_p() == null) {
            return false;
        }
        return stack.func_77978_p().func_74764_b(PROBETAG);
    }

    public static boolean hasAProbeSomewhere(PlayerEntity player) {
        return ModItems.hasProbeInHand(player, Hand.MAIN_HAND) || ModItems.hasProbeInHand(player, Hand.OFF_HAND) || ModItems.hasProbeInHelmet(player) || ModItems.hasProbeInBauble(player);
    }

    private static boolean hasProbeInHand(PlayerEntity player, Hand hand) {
        ItemStack item = player.func_184586_b(hand);
        return ModItems.isProbeInHand(item);
    }

    private static boolean hasProbeInHelmet(PlayerEntity player) {
        ItemStack helmet = player.field_71071_by.func_70301_a(39);
        return ModItems.isProbeHelmet(helmet);
    }

    private static boolean hasProbeInBauble(PlayerEntity player) {
        if (TheOneProbe.baubles) {
            return BaubleTools.hasProbeGoggle(player);
        }
        return false;
    }

    static {
        PROBETAG = "theoneprobe";
        PROBETAG_HAND = "theoneprobe_hand";
    }
}

