/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.capabilities;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.StandardDrawerGroup;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.INBTSerializable;

public class CapabilityDrawerGroup {
    @CapabilityInject(value=IDrawerGroup.class)
    public static Capability<IDrawerGroup> DRAWER_GROUP_CAPABILITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IDrawerGroup.class, (Capability.IStorage)new DefaultStorage(), DefaultImplementation::new);
    }

    private static class DefaultImplementation
    extends StandardDrawerGroup {
        DefaultImplementation() {
            super(1);
        }

        @Override
        @Nonnull
        protected StandardDrawerGroup.DrawerData createDrawer(int slot) {
            return new StandardDrawerGroup.DrawerData(this);
        }
    }

    private static class DefaultStorage
    implements Capability.IStorage<IDrawerGroup> {
        private DefaultStorage() {
        }

        @Nullable
        public INBT writeNBT(Capability<IDrawerGroup> capability, IDrawerGroup instance, Direction side) {
            if (instance instanceof INBTSerializable) {
                return ((INBTSerializable)instance).serializeNBT();
            }
            return new CompoundNBT();
        }

        public void readNBT(Capability<IDrawerGroup> capability, IDrawerGroup instance, Direction side, INBT nbt) {
            if (instance instanceof INBTSerializable) {
                INBTSerializable serializer = (INBTSerializable)instance;
                serializer.deserializeNBT(nbt);
            }
        }
    }
}

