/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.experience;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createenchantmentindustry.common.fluids.experience.ExperienceHatchBehaviour;
import plus.dragons.createenchantmentindustry.common.fluids.experience.ExperienceHatchBlockEntity;
import plus.dragons.createenchantmentindustry.common.fluids.experience.ExperienceHelper;
import plus.dragons.createenchantmentindustry.common.registry.CEIAdvancements;
import plus.dragons.createenchantmentindustry.common.registry.CEIBlockEntities;

public class ExperienceHatchBlock
extends HorizontalDirectionalBlock
implements IBE<ExperienceHatchBlockEntity>,
IWrenchable,
ProperWaterloggedBlock {
    public static final MapCodec<ExperienceHatchBlock> CODEC = ExperienceHatchBlock.simpleCodec(ExperienceHatchBlock::new);

    public ExperienceHatchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING, WATERLOGGED}));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        if (context.getClickedFace().getAxis().isVertical()) {
            return null;
        }
        return this.withWater((BlockState)state.setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite()), context);
    }

    public FluidState getFluidState(BlockState state) {
        return this.fluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        this.updateWater(level, state, pos);
        return state;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (player instanceof FakePlayer) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos.relative((Direction)state.getValue((Property)FACING)));
        if (blockEntity == null) {
            return InteractionResult.PASS;
        }
        IFluidHandler tankCapability = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, blockEntity.getBlockPos(), null);
        if (tankCapability == null) {
            return InteractionResult.PASS;
        }
        ExperienceHatchBehaviour filter = (ExperienceHatchBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, ExperienceHatchBehaviour.TYPE);
        if (filter == null) {
            return InteractionResult.PASS;
        }
        if (player.isSecondaryUseActive()) {
            FluidStack fluid = filter.getFluidToDrain();
            if ((fluid = tankCapability.drain(fluid, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
                return InteractionResult.PASS;
            }
            blockEntity.setChanged();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.getChunkSource().blockChanged(blockEntity.getBlockPos());
            }
            int experience = ExperienceHelper.getExperienceFromFluid(fluid);
            player.giveExperiencePoints(experience);
            CEIAdvancements.SPIRITUAL_RETURN.awardTo(player);
            return InteractionResult.SUCCESS;
        }
        int experience = ExperienceHelper.getExperienceForPlayer(player);
        FluidStack fluid = filter.getFluidToFill(experience);
        int filled = tankCapability.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
        if (filled == 0) {
            return InteractionResult.PASS;
        }
        blockEntity.setChanged();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().blockChanged(blockEntity.getBlockPos());
        }
        experience = ExperienceHelper.getExperienceFromFluid(fluid.copyWithAmount(filled));
        player.giveExperiencePoints(-experience);
        CEIAdvancements.SPIRIT_TAKING.awardTo(player);
        return InteractionResult.SUCCESS;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AllShapes.ITEM_HATCH.get(((Direction)state.getValue((Property)FACING)).getOpposite());
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public Class<ExperienceHatchBlockEntity> getBlockEntityClass() {
        return ExperienceHatchBlockEntity.class;
    }

    public BlockEntityType<? extends ExperienceHatchBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CEIBlockEntities.EXPERIENCE_HATCH.get();
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

