/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins.neoforge.self;

import net.mehvahdjukaar.supplementaries.common.items.WrenchItem;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={WrenchItem.class})
public abstract class SelfWrenchMixin
extends Item {
    public SelfWrenchMixin(Item.Properties properties) {
        super(properties);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(Enchantments.KNOCKBACK)) {
            return true;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        LivingEntity armorStand;
        HangingEntity hangingEntity;
        boolean shiftDown = player.isShiftKeyDown();
        if (entity instanceof HangingEntity && (hangingEntity = (HangingEntity)entity).getDirection().getAxis().isHorizontal()) {
            Direction dir = hangingEntity.getDirection();
            dir = shiftDown ? dir.getCounterClockWise() : dir.getClockWise();
            hangingEntity.setDirection(dir);
            WrenchItem.playTurningEffects(hangingEntity.getPos(), shiftDown, Direction.UP, player.level(), player);
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            return true;
        }
        if (entity instanceof LivingEntity && this.interactLivingEntity(stack, player, armorStand = (LivingEntity)entity, InteractionHand.MAIN_HAND).consumesAction()) {
            return true;
        }
        return super.onLeftClickEntity(stack, player, entity);
    }
}

