/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.IFlowerModelProvider;
import net.mehvahdjukaar.supplementaries.common.utils.neoforge.FlowerPotHandlerImpl;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class FlowerPotHandler {
    private static final Map<Item, ResourceLocation> SPECIAL_FLOWER_BOX_FLOWERS = new IdentityHashMap<Item, ResourceLocation>();
    private static final Map<Item, ResourceLocation> SPECIAL_TALL_FLOWER_BOX_FLOWERS = new IdentityHashMap<Item, ResourceLocation>();
    public static final List<ResourceLocation> CUSTOM_MODELS = new ArrayList<ResourceLocation>();

    @Contract
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Block getEmptyPot(FlowerPotBlock fullPot) {
        return FlowerPotHandlerImpl.getEmptyPot(fullPot);
    }

    /*
     * WARNING - void declaration
     */
    @Contract
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Block getFullPot(FlowerPotBlock emptyPot, Block flowerBlock) {
        void var1_1;
        return FlowerPotHandlerImpl.getFullPot(emptyPot, (Block)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isEmptyPot(Block b) {
        return FlowerPotHandlerImpl.isEmptyPot(b);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerFlowerPots() {
        FlowerPotHandlerImpl.registerFlowerPots();
    }

    public static void setup() {
        FlowerPotHandler.registerFlowerPots();
        FlowerPotHandler.registerBuiltin();
    }

    public static void registerCustomFlower(Item item, ResourceLocation model) {
        SPECIAL_FLOWER_BOX_FLOWERS.put(item, model);
    }

    public static void registerCustomSimpleFlower(Item item, ResourceLocation model) {
        SPECIAL_TALL_FLOWER_BOX_FLOWERS.put(item, model);
    }

    private static void registerFlower(String itemRes) {
        ResourceLocation id = ResourceLocation.parse((String)itemRes);
        Optional opt = BuiltInRegistries.ITEM.getOptional(id);
        if (opt.isPresent()) {
            ResourceLocation res = Supplementaries.res("block/plants/" + id.getPath());
            CUSTOM_MODELS.add(res);
            FlowerPotHandler.registerCustomFlower((Item)opt.get(), res);
        }
    }

    private static void registerSimpleFlower(Item item) {
        ResourceLocation res = Supplementaries.res("block/plants/simple/" + Utils.getID((Item)item).getPath());
        CUSTOM_MODELS.add(res);
        FlowerPotHandler.registerCustomSimpleFlower(item, res);
    }

    private static void registerBuiltin() {
        ArrayList<String> toAdd = new ArrayList<String>();
        toAdd.add(Utils.getID((Item)Items.CACTUS).toString());
        toAdd.add(Utils.getID((Item)Items.FLOWERING_AZALEA).toString());
        toAdd.add(Utils.getID((Item)Items.AZALEA).toString());
        toAdd.add(Utils.getID((Item)ModRegistry.FLAX_SEEDS_ITEM.get()).toString());
        if (CompatHandler.SNOWYSPIRIT) {
            toAdd.add("snowyspirit:ginger_flower");
        }
        if (CompatHandler.HAUNTEDHARVEST) {
            toAdd.add("hauntedharvest:kernels");
        }
        if (CompatHandler.QUARK) {
            Item[] items = new Item[]{Items.SUGAR_CANE, Items.BEETROOT_SEEDS, Items.CARROT, Items.CHORUS_FLOWER, Items.POTATO, Items.SHORT_GRASS, Items.COCOA_BEANS, Items.WHEAT_SEEDS, Items.VINE, Items.LARGE_FERN, Items.SWEET_BERRIES, Items.WEEPING_VINES, Items.NETHER_SPROUTS, Items.MELON_SEEDS, Items.PUMPKIN_SEEDS, Items.TALL_GRASS, Items.SEA_PICKLE, Items.NETHER_WART};
            toAdd.add("quark:chorus_weeds");
            toAdd.add("quark:root");
            toAdd.add("quark:chorus_twist");
            Arrays.stream(items).forEach(i -> toAdd.add(Utils.getID((Item)i).toString()));
        }
        if (CompatHandler.POKECUBE_LEGENDS) {
            toAdd.add("pokecube_legends:crystallized_cactus");
        }
        if (CompatHandler.POKECUBE) {
            String[] berries = new String[]{"pokecube:berry_aspear", "pokecube:berry_cheri", "pokecube:berry_chesto", "pokecube:berry_cornn", "pokecube:berry_enigma", "pokecube:berry_grepa", "pokecube:berry_hondew", "pokecube:berry_jaboca", "pokecube:berry_kelpsy", "pokecube:berry_leppa", "pokecube:berry_lum", "pokecube:berry_nanab", "pokecube:berry_null", "pokecube:berry_oran", "pokecube:berry_pecha", "pokecube:berry_persim", "pokecube:berry_pinap", "pokecube:berry_pomeg", "pokecube:berry_qualot", "pokecube:berry_rawst", "pokecube:berry_rowap", "pokecube:berry_sitrus", "pokecube:berry_tamato"};
            toAdd.addAll(Arrays.asList(berries));
        }
        if (CompatHandler.MOREMINECARTS) {
            toAdd.add("moreminecarts:chunkrodite_block");
            toAdd.add("moreminecarts:glass_cactus");
        }
        if (CompatHandler.HABITAT) {
            toAdd.add("habitat:rafflesia");
            toAdd.add("habitat:orange_ball_cactus");
            toAdd.add("habitat:red_ball_cactus");
            toAdd.add("habitat:pink_ball_cactus");
            toAdd.add("habitat:yellow_ball_cactus");
            toAdd.add("habitat:kabloom_pulp");
        }
        if (CompatHandler.ENDERGETIC) {
            toAdd.add("endergetic:tall_poise_bush");
        }
        if (CompatHandler.SIMPLEFARMING) {
            toAdd.add("simplefarming:cantaloupe_block");
            toAdd.add("simplefarming:honeydew_block");
            toAdd.add("simplefarming:squash_block");
        }
        if (CompatHandler.ATMOSPHERIC) {
            toAdd.add("atmospheric:barrel_cactus");
        }
        if (CompatHandler.OVERWEIGHT_FARMING) {
            toAdd.add("overweight_farming:overweight_cabbage");
            toAdd.add("overweight_farming:overweight_potato");
            toAdd.add("overweight_farming:overweight_poisonous_potato");
            toAdd.add("overweight_farming:overweight_carrot");
            toAdd.add("overweight_farming:overweight_onion");
            toAdd.add("overweight_farming:overweight_cabbage");
        }
        toAdd.forEach(FlowerPotHandler::registerFlower);
        ArrayList<Item> tallFlowers = new ArrayList<Item>(List.of(Items.ROSE_BUSH, Items.SUNFLOWER, Items.LILAC, Items.WEEPING_VINES, Items.VINE, Items.GLOW_BERRIES, Items.SWEET_BERRIES, Items.SUGAR_CANE, Items.TWISTING_VINES, Items.PEONY, Items.LARGE_FERN, Items.PITCHER_PLANT));
        if (CompatHandler.QUARK) {
            tallFlowers.add(Items.TALL_GRASS);
        }
        tallFlowers.forEach(FlowerPotHandler::registerSimpleFlower);
    }

    @Nullable
    public static ResourceLocation getSpecialFlowerModel(Item i, boolean forRenderer) {
        BlockItem blockItem;
        Block block;
        ResourceLocation res;
        if (CommonConfigs.Building.FLOWER_BOX_SIMPLE_MODE.get().booleanValue() && ((res = SPECIAL_TALL_FLOWER_BOX_FLOWERS.get(i)) != null || !forRenderer)) {
            return res;
        }
        res = SPECIAL_FLOWER_BOX_FLOWERS.get(i);
        if (res != null) {
            return res;
        }
        if (i instanceof IFlowerModelProvider) {
            IFlowerModelProvider flowerModelProvider = (IFlowerModelProvider)i;
            return flowerModelProvider.getModel();
        }
        if (i instanceof BlockItem && (block = (blockItem = (BlockItem)i).getBlock()) instanceof IFlowerModelProvider) {
            IFlowerModelProvider flowerModelProvider = (IFlowerModelProvider)block;
            return flowerModelProvider.getModel();
        }
        return null;
    }

    public static boolean hasSpecialFlowerModel(Item i) {
        return FlowerPotHandler.getSpecialFlowerModel(i, false) != null;
    }
}

