/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.entity.ParticleTrailEmitter;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.BombExplosion;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class BombEntity
extends ImprovedProjectileEntity
implements IExtraClientSpawnData {
    private final boolean hasFuse = CommonConfigs.Tools.BOMB_FUSE.get() != 0;
    private BombType type = BombType.NORMAL;
    private boolean active = true;
    private int changeTimer = -1;
    private boolean superCharged = false;
    private final ParticleTrailEmitter trailEmitter = ParticleTrailEmitter.builder().spacing(0.25).maxParticlesPerTick(20).minParticlesPerTick(1).build();

    public BombEntity(EntityType<? extends BombEntity> type, Level world) {
        super(type, world);
        this.maxAge = this.hasFuse ? CommonConfigs.Tools.BOMB_FUSE.get() : 200;
    }

    public BombEntity(Level worldIn, LivingEntity throwerIn, BombType type) {
        super(ModEntities.BOMB.get(), throwerIn, worldIn);
        this.type = type;
        this.maxAge = this.hasFuse ? CommonConfigs.Tools.BOMB_FUSE.get() : 300;
    }

    public BombEntity(Level worldIn, double x, double y, double z, BombType type) {
        super(ModEntities.BOMB.get(), x, y, z, worldIn);
        this.type = type;
        this.maxAge = this.hasFuse ? CommonConfigs.Tools.BOMB_FUSE.get() : 300;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Active", this.active);
        compound.putInt("Type", this.type.ordinal());
        compound.putInt("Timer", this.changeTimer);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.active = compound.getBoolean("Active");
        this.type = BombType.values()[compound.getInt("Type")];
        this.changeTimer = compound.getInt("Timer");
    }

    public void readSpawnData(RegistryFriendlyByteBuf buffer) {
        this.type = (BombType)buffer.readEnum(BombType.class);
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.type);
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return PlatHelper.getEntitySpawnPacket((Entity)this, (ServerEntity)serverEntity);
    }

    protected Item getDefaultItem() {
        return ModRegistry.BOMB_ITEM.get();
    }

    private void spawnBreakParticles() {
        for (int i = 0; i < 8; ++i) {
            this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 3: {
                this.spawnBreakParticles();
                this.discard();
                break;
            }
            case 10: {
                this.spawnBreakParticles();
                this.discard();
                break;
            }
            case 68: {
                this.level().addParticle((ParticleOptions)ParticleTypes.SONIC_BOOM, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                break;
            }
            case 67: {
                RandomSource random = this.level().getRandom();
                for (int i = 0; i < 10; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX() + 0.25 - (double)(random.nextFloat() * 0.5f), this.getY() + (double)0.45f - (double)(random.nextFloat() * 0.5f), this.getZ() + 0.25 - (double)(random.nextFloat() * 0.5f), 0.0, 0.005, 0.0);
                }
                this.active = false;
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    public boolean hasReachedEndOfLife() {
        return super.hasReachedEndOfLife() || this.changeTimer == 0;
    }

    public void tick() {
        if (this.active && this.isInWater() && this.type != BombType.BLUE) {
            this.turnOff();
        }
        super.tick();
    }

    public void spawnTrailParticles() {
        this.trailEmitter.tick((Entity)this, (p, v) -> this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, p.x, 0.25 + p.y, p.z, 0.0, 0.02, 0.0));
    }

    public void turnOff() {
        Level level = this.level();
        if (!level.isClientSide()) {
            level.broadcastEntityEvent((Entity)this, (byte)67);
            this.playEntityOnFireExtinguishedSound();
        }
        this.active = false;
    }

    public void playerTouch(Player entityIn) {
        if (!this.level().isClientSide && !this.active && entityIn.getInventory().add(this.getItem())) {
            entityIn.take((Entity)this, 1);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void onHitEntity(EntityHitResult hit) {
        super.onHitEntity(hit);
        hit.getEntity().hurt(this.level().damageSources().thrown((Entity)this, this.getOwner()), 1.0f);
        if (hit.getEntity() instanceof LargeFireball) {
            this.superCharged = true;
            hit.getEntity().remove(Entity.RemovalReason.DISCARDED);
        }
        this.activateBomb();
    }

    protected void onHitBlock(BlockHitResult hit) {
        super.onHitBlock(hit);
        BlockState state = this.level().getBlockState(hit.getBlockPos());
        if (!state.is(ModTags.BOUNCY_BLOCKS) || hit.getDirection() != Direction.UP) {
            this.setDeltaMovement(Vec3.ZERO);
            this.setOnGround(true);
            this.activateBomb();
        }
    }

    private void activateBomb() {
        Level level = this.level();
        if (!level.isClientSide && !this.hasFuse) {
            boolean isInstantlyActivated = this.type.isInstantlyActivated();
            if (!isInstantlyActivated && this.changeTimer == -1) {
                this.changeTimer = 5;
                level.broadcastEntityEvent((Entity)this, (byte)68);
                level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.FLINTANDSTEEL_USE, SoundSource.NEUTRAL, 1.5f, 1.3f);
            }
            if (!this.isRemoved() && (isInstantlyActivated || this.superCharged)) {
                this.reachedEndOfLife();
            }
        }
    }

    protected void updateRotation() {
    }

    public float getDefaultShootVelocity() {
        return 1.25f;
    }

    public double getDefaultGravity() {
        return 0.04f;
    }

    public void reachedEndOfLife() {
        Level level = this.level();
        level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.NETHERITE_BLOCK_BREAK, SoundSource.NEUTRAL, 1.5f, 1.5f);
        if (!level.isClientSide) {
            if (this.active) {
                this.createExplosion();
                level.broadcastEntityEvent((Entity)this, (byte)10);
            } else {
                level.broadcastEntityEvent((Entity)this, (byte)3);
            }
            this.discard();
        }
    }

    private void createExplosion() {
        Player p;
        Entity entity;
        boolean breaks;
        boolean bl = breaks = this.getOwner() instanceof Player || PlatHelper.isMobGriefingOn((Level)this.level(), (Entity)this.getOwner());
        if (CompatHandler.FLAN && (entity = this.getOwner()) instanceof Player && !FlanCompat.canBreak(p = (Player)entity, BlockPos.containing((Position)this.position()))) {
            breaks = false;
        }
        if (this.superCharged) {
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 6.0f, breaks, this.getOwner() instanceof Player ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.MOB);
        }
        if ((entity = this.level()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)entity;
            BombExplosion.createExplosion((Entity)this, sl, this.getX(), this.getY() + 0.25, this.getZ(), this.type, breaks);
        }
    }

    public static enum BombType {
        NORMAL,
        BLUE,
        SPIKY;


        public double getRadius() {
            return this == BLUE ? CommonConfigs.Tools.BOMB_BLUE_RADIUS.get() : CommonConfigs.Tools.BOMB_RADIUS.get();
        }

        public BreakingMode breakMode() {
            return this == BLUE ? CommonConfigs.Tools.BOMB_BLUE_BREAKS.get() : CommonConfigs.Tools.BOMB_BREAKS.get();
        }

        public float volume() {
            return this == BLUE ? 5.0f : 3.0f;
        }

        public void applyStatusEffects(LivingEntity entity, double distSq) {
            switch (this.ordinal()) {
                case 1: {
                    entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 600));
                    entity.igniteForSeconds(10.0f);
                    break;
                }
            }
        }

        public boolean isInstantlyActivated() {
            return this != BLUE;
        }

        public void spawnExtraParticles(double x, double y, double z, Level level) {
            switch (this.ordinal()) {
                case 1: {
                    ParticleUtil.spawnParticleInASphere((Level)level, (double)x, (double)y, (double)z, () -> ParticleTypes.FLAME, (int)40, (float)0.4f, (float)0.01f, (float)0.15f);
                    break;
                }
                case 2: {
                    RandomSource random = level.getRandom();
                    ParticleType<?> particle = CompatObjects.SHARPNEL.get();
                    if (particle instanceof ParticleOptions) {
                        ParticleOptions p = (ParticleOptions)particle;
                        for (int i = 0; i < 80; ++i) {
                            float dx = (float)(random.nextGaussian() * 2.0);
                            float dy = (float)(random.nextGaussian() * 2.0);
                            float dz = (float)(random.nextGaussian() * 2.0);
                            level.addParticle(p, x, y, z, (double)dx, (double)dy, (double)dz);
                        }
                        break;
                    }
                    ParticleUtil.spawnParticleInASphere((Level)level, (double)x, (double)y, (double)z, () -> ParticleTypes.CRIT, (int)100, (float)5.0f, (float)0.01f, (float)0.15f);
                }
            }
        }
    }

    public static enum BreakingMode {
        ALL,
        WEAK,
        NONE;

    }
}

