/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.util;

import com.chaosthedude.naturescompass.NaturesCompass;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;

public class PlayerUtils {
    public static boolean canTeleport(MinecraftServer server, Player player) {
        return PlayerUtils.cheatModeEnabled(server, player) || PlayerUtils.isOp(player) || PlayerUtils.hasPermission(player);
    }

    public static boolean cheatModeEnabled(MinecraftServer server, Player player) {
        LevelData levelData;
        if (server != null && server.isSingleplayer() && (levelData = server.getLevel(player.level().dimension()).getLevelData()) instanceof ServerLevelData) {
            return ((ServerLevelData)levelData).isAllowCommands();
        }
        return false;
    }

    public static boolean isOp(Player player) {
        if (player instanceof ServerPlayer) {
            ServerOpListEntry userEntry = (ServerOpListEntry)((ServerPlayer)player).getServer().getPlayerList().getOps().get((Object)player.getGameProfile());
            return userEntry != null;
        }
        return false;
    }

    public static boolean hasPermission(Player player) {
        if (player instanceof ServerPlayer) {
            return (Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)player), NaturesCompass.TELEPORT_PERMISSION, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
        }
        return false;
    }
}

